/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-01-01 08:43:32 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wyp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2611 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=641 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=1919 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wyp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wyp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=35513 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=8359 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wyp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_tinvwl_analytics` (
  `ID` varchar(32) NOT NULL,
  `wishlist_id` bigint(20) NOT NULL DEFAULT 0,
  `product_id` bigint(20) NOT NULL DEFAULT 0,
  `variation_id` bigint(20) NOT NULL DEFAULT 0,
  `visite_author` bigint(20) NOT NULL DEFAULT 0,
  `visite` bigint(20) NOT NULL DEFAULT 0,
  `click_author` bigint(20) NOT NULL DEFAULT 0,
  `click` bigint(20) NOT NULL DEFAULT 0,
  `cart` bigint(20) NOT NULL DEFAULT 0,
  `sell_of_wishlist` bigint(20) NOT NULL DEFAULT 0,
  `sell_as_gift` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `unique_product` (`wishlist_id`,`product_id`,`variation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wyp_tinvwl_items` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `wishlist_id` bigint(20) NOT NULL DEFAULT 0,
  `product_id` bigint(20) NOT NULL DEFAULT 0,
  `variation_id` bigint(20) NOT NULL DEFAULT 0,
  `formdata` text DEFAULT NULL,
  `author` bigint(20) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quantity` bigint(20) NOT NULL DEFAULT 1,
  `price` varchar(255) NOT NULL DEFAULT '0',
  `in_stock` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wyp_tinvwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `author` bigint(20) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` text DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'public',
  `type` varchar(20) NOT NULL DEFAULT 'list',
  `share_key` varchar(45) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wyp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=668 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  KEY `product_or_parent_id_term_id` (`product_or_parent_id`,`term_id`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wyp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://nicosloane.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://nicosloane.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Nicosloane", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Just another WordPress site", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "vinnerangless@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:81:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "twentytwentytwo", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "twentytwentytwo", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "51917", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1708336832", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "1", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:5:{i:1692784834;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1692784835;a:5:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1692784926;a:1:{s:28:\"wp_update_comment_type_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1692871234;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "_transient_doing_cron", "1692784987.5994250774383544921875", "yes");
INSERT INTO `wp_options` VALUES("118", "_transient_timeout_global_styles_twentytwentytwo", "1692784896", "no");
INSERT INTO `wp_options` VALUES("119", "_transient_global_styles_twentytwentytwo", "body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--color--foreground: #000000;--wp--preset--color--background: #ffffff;--wp--preset--color--primary: #1a4548;--wp--preset--color--secondary: #ffe2c7;--wp--preset--color--tertiary: #F6F6F6;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--gradient--vertical-secondary-to-tertiary: linear-gradient(to bottom,var(--wp--preset--color--secondary) 0%,var(--wp--preset--color--tertiary) 100%);--wp--preset--gradient--vertical-secondary-to-background: linear-gradient(to bottom,var(--wp--preset--color--secondary) 0%,var(--wp--preset--color--background) 100%);--wp--preset--gradient--vertical-tertiary-to-background: linear-gradient(to bottom,var(--wp--preset--color--tertiary) 0%,var(--wp--preset--color--background) 100%);--wp--preset--gradient--diagonal-primary-to-foreground: linear-gradient(to bottom right,var(--wp--preset--color--primary) 0%,var(--wp--preset--color--foreground) 100%);--wp--preset--gradient--diagonal-secondary-to-background: linear-gradient(to bottom right,var(--wp--preset--color--secondary) 50%,var(--wp--preset--color--background) 50%);--wp--preset--gradient--diagonal-background-to-secondary: linear-gradient(to bottom right,var(--wp--preset--color--background) 50%,var(--wp--preset--color--secondary) 50%);--wp--preset--gradient--diagonal-tertiary-to-background: linear-gradient(to bottom right,var(--wp--preset--color--tertiary) 50%,var(--wp--preset--color--background) 50%);--wp--preset--gradient--diagonal-background-to-tertiary: linear-gradient(to bottom right,var(--wp--preset--color--background) 50%,var(--wp--preset--color--tertiary) 50%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--duotone--foreground-and-background: url(\'#wp-duotone-foreground-and-background\');--wp--preset--duotone--foreground-and-secondary: url(\'#wp-duotone-foreground-and-secondary\');--wp--preset--duotone--foreground-and-tertiary: url(\'#wp-duotone-foreground-and-tertiary\');--wp--preset--duotone--primary-and-background: url(\'#wp-duotone-primary-and-background\');--wp--preset--duotone--primary-and-secondary: url(\'#wp-duotone-primary-and-secondary\');--wp--preset--duotone--primary-and-tertiary: url(\'#wp-duotone-primary-and-tertiary\');--wp--preset--font-size--small: 1rem;--wp--preset--font-size--medium: 1.125rem;--wp--preset--font-size--large: 1.75rem;--wp--preset--font-size--x-large: clamp(1.75rem, 3vw, 2.25rem);--wp--preset--font-family--system-font: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen-Sans,Ubuntu,Cantarell,\"Helvetica Neue\",sans-serif;--wp--preset--font-family--source-serif-pro: \"Source Serif Pro\", serif;--wp--custom--spacing--small: max(1.25rem, 5vw);--wp--custom--spacing--medium: clamp(2rem, 8vw, calc(4 * var(--wp--style--block-gap)));--wp--custom--spacing--large: clamp(4rem, 10vw, 8rem);--wp--custom--spacing--outer: var(--wp--custom--spacing--small, 1.25rem);--wp--custom--typography--font-size--huge: clamp(2.25rem, 4vw, 2.75rem);--wp--custom--typography--font-size--gigantic: clamp(2.75rem, 6vw, 3.25rem);--wp--custom--typography--font-size--colossal: clamp(3.25rem, 8vw, 6.25rem);--wp--custom--typography--line-height--tiny: 1.15;--wp--custom--typography--line-height--small: 1.2;--wp--custom--typography--line-height--medium: 1.4;--wp--custom--typography--line-height--normal: 1.6;}body { margin: 0; }body{background-color: var(--wp--preset--color--background);color: var(--wp--preset--color--foreground);font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);line-height: var(--wp--custom--typography--line-height--normal);--wp--style--block-gap: 1.5rem;}.wp-site-blocks > .alignleft { float: left; margin-right: 2em; }.wp-site-blocks > .alignright { float: right; margin-left: 2em; }.wp-site-blocks > .aligncenter { justify-content: center; margin-left: auto; margin-right: auto; }.wp-site-blocks > * { margin-top: 0; margin-bottom: 0; }.wp-site-blocks > * + * { margin-top: var( --wp--style--block-gap ); }h1{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--colossal);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h2{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--small);}h3{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--huge);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h4{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--preset--font-size--x-large);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h5{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: 700;line-height: var(--wp--custom--typography--line-height--normal);text-transform: uppercase;}h6{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: 400;line-height: var(--wp--custom--typography--line-height--normal);text-transform: uppercase;}a{color: var(--wp--preset--color--foreground);}.wp-block-button__link{background-color: var(--wp--preset--color--primary);border-radius: 0;color: var(--wp--preset--color--background);font-size: var(--wp--preset--font-size--medium);}.wp-block-post-title{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}.wp-block-post-comments{padding-top: var(--wp--custom--spacing--small);}.wp-block-pullquote{border-width: 1px 0;}.wp-block-query-title{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--small);}.wp-block-quote{border-width: 1px;}.wp-block-site-title{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: normal;line-height: var(--wp--custom--typography--line-height--normal);}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-color{color: var(--wp--preset--color--foreground) !important;}.has-background-color{color: var(--wp--preset--color--background) !important;}.has-primary-color{color: var(--wp--preset--color--primary) !important;}.has-secondary-color{color: var(--wp--preset--color--secondary) !important;}.has-tertiary-color{color: var(--wp--preset--color--tertiary) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-background-color{background-color: var(--wp--preset--color--foreground) !important;}.has-background-background-color{background-color: var(--wp--preset--color--background) !important;}.has-primary-background-color{background-color: var(--wp--preset--color--primary) !important;}.has-secondary-background-color{background-color: var(--wp--preset--color--secondary) !important;}.has-tertiary-background-color{background-color: var(--wp--preset--color--tertiary) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-border-color{border-color: var(--wp--preset--color--foreground) !important;}.has-background-border-color{border-color: var(--wp--preset--color--background) !important;}.has-primary-border-color{border-color: var(--wp--preset--color--primary) !important;}.has-secondary-border-color{border-color: var(--wp--preset--color--secondary) !important;}.has-tertiary-border-color{border-color: var(--wp--preset--color--tertiary) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-vertical-secondary-to-tertiary-gradient-background{background: var(--wp--preset--gradient--vertical-secondary-to-tertiary) !important;}.has-vertical-secondary-to-background-gradient-background{background: var(--wp--preset--gradient--vertical-secondary-to-background) !important;}.has-vertical-tertiary-to-background-gradient-background{background: var(--wp--preset--gradient--vertical-tertiary-to-background) !important;}.has-diagonal-primary-to-foreground-gradient-background{background: var(--wp--preset--gradient--diagonal-primary-to-foreground) !important;}.has-diagonal-secondary-to-background-gradient-background{background: var(--wp--preset--gradient--diagonal-secondary-to-background) !important;}.has-diagonal-background-to-secondary-gradient-background{background: var(--wp--preset--gradient--diagonal-background-to-secondary) !important;}.has-diagonal-tertiary-to-background-gradient-background{background: var(--wp--preset--gradient--diagonal-tertiary-to-background) !important;}.has-diagonal-background-to-tertiary-gradient-background{background: var(--wp--preset--gradient--diagonal-background-to-tertiary) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}.has-system-font-font-family{font-family: var(--wp--preset--font-family--system-font) !important;}.has-source-serif-pro-font-family{font-family: var(--wp--preset--font-family--source-serif-pro) !important;}", "no");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentytwo", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "_transient_timeout_global_styles_svg_filters_twentytwentytwo", "1692784896", "no");
INSERT INTO `wp_options` VALUES("122", "_transient_global_styles_svg_filters_twentytwentytwo", "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-background\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-secondary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.88627450980392\" /><feFuncB type=\"table\" tableValues=\"0 0.78039215686275\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-tertiary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncG type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncB type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-background\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 1\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 1\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-secondary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 1\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 0.88627450980392\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 0.78039215686275\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-tertiary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 0.96470588235294\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 0.96470588235294\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 0.96470588235294\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "", "0", "https://nicosloane.com/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("2", "1", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href=\"https://nicosloane.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->", "Sample Page", "", "publish", "closed", "open", "", "sample-page", "", "", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "", "0", "https://nicosloane.com/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "<!-- wp:heading --><h2>Who we are</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: https://nicosloane.com.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Comments</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Media</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Embedded content from other websites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Who we share your data with</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>How long we retain your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What rights you have over your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Where we send your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p><!-- /wp:paragraph -->", "Privacy Policy", "", "draft", "closed", "open", "", "privacy-policy", "", "", "2023-08-23 10:00:33", "2023-08-23 10:00:33", "", "0", "https://nicosloane.com/?page_id=3", "0", "page", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "1", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "LazyboI");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `wp_usermeta` VALUES("12", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("13", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `wp_usermeta` VALUES("15", "1", "show_welcome_panel", "1");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "LazyboI", "$P$BQ0UQ6pFb.r8iVHK2t9akxcn8.iN/S0", "lazyboi", "vinnerangless@gmail.com", "https://nicosloane.com", "2023-08-23 10:00:33", "", "0", "LazyboI");

/* INSERT TABLE DATA: wyp_actionscheduler_actions */
INSERT INTO `wyp_actionscheduler_actions` VALUES("64", "wc-admin_import_customers", "complete", "2024-01-01 08:40:54", "2024-01-01 08:40:54", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1704098454;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1704098454;}", "2", "1", "2024-01-01 08:41:32", "2024-01-01 08:41:32", "0", NULL);

/* INSERT TABLE DATA: wyp_actionscheduler_groups */
INSERT INTO `wyp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wyp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wyp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wyp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");

/* INSERT TABLE DATA: wyp_actionscheduler_logs */
INSERT INTO `wyp_actionscheduler_logs` VALUES("172", "64", "action created", "2024-01-01 08:40:49", "2024-01-01 08:40:49");
INSERT INTO `wyp_actionscheduler_logs` VALUES("174", "64", "action complete via Async Request", "2024-01-01 08:41:32", "2024-01-01 08:41:32");
INSERT INTO `wyp_actionscheduler_logs` VALUES("173", "64", "action started via Async Request", "2024-01-01 08:41:32", "2024-01-01 08:41:32");

/* INSERT TABLE DATA: wyp_comments */
INSERT INTO `wyp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2022-03-19 11:37:45", "2022-03-19 11:37:45", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wyp_duplicator_packages */
INSERT INTO `wyp_duplicator_packages` VALUES("6", "20220319_nicosloane_ForApril_new", "c0396bf7caf346733971_20220418152830", "100", "2022-04-18 15:29:28", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-04-18 15:28:30\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.3\";s:9:\"VersionDB\";s:6:\"10.6.7\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:32:\"20220319_nicosloane_ForApril_new\";s:4:\"Hash\";s:35:\"c0396bf7caf346733971_20220418152830\";s:8:\"NameHash\";s:68:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:78:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"70.60 sec.\";s:7:\"ExeSize\";s:7:\"64.61KB\";s:7:\"ZipSize\";s:8:\"309.85MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/nisloane/public_html\";s:4:\"Size\";i:324900590;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:19558;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/nisloane/public_html/wp-admin\";i:1;s:45:\"/home/nisloane/public_html/wp-content/uploads\";i:2;s:47:\"/home/nisloane/public_html/wp-content/languages\";i:3;s:44:\"/home/nisloane/public_html/wp-content/themes\";i:4;s:38:\"/home/nisloane/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/nisloane/public_html\";i:1;s:37:\"/home/nisloane/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/nisloane/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:82:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830_installer.php\";s:4:\"Size\";i:66159;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:17272916;s:4:\"File\";s:81:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:3:{i:0;s:18:\"utf8mb4_unicode_ci\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:18:\"utf8mb3_general_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"nisloane_bsr\";s:15:\"tablesBaseCount\";i:64;s:16:\"tablesFinalCount\";i:64;s:14:\"tablesRowCount\";s:5:\"7,354\";s:16:\"tablesSizeOnDisk\";s:6:\"15.4MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"10.6.7\";s:14:\"versionComment\";s:14:\"MariaDB Server\";s:18:\"tableWiseRowCounts\";a:64:{s:27:\"wyp_actionscheduler_actions\";s:2:\"55\";s:26:\"wyp_actionscheduler_claims\";s:1:\"0\";s:26:\"wyp_actionscheduler_groups\";s:1:\"4\";s:24:\"wyp_actionscheduler_logs\";s:3:\"165\";s:15:\"wyp_commentmeta\";s:1:\"0\";s:12:\"wyp_comments\";s:1:\"1\";s:23:\"wyp_duplicator_packages\";s:1:\"1\";s:17:\"wyp_e_submissions\";s:1:\"1\";s:29:\"wyp_e_submissions_actions_log\";s:1:\"1\";s:24:\"wyp_e_submissions_values\";s:1:\"3\";s:9:\"wyp_links\";s:1:\"0\";s:11:\"wyp_options\";s:3:\"495\";s:12:\"wyp_postmeta\";s:4:\"5737\";s:9:\"wyp_posts\";s:3:\"376\";s:17:\"wyp_revslider_css\";s:3:\"109\";s:21:\"wyp_revslider_css_bkp\";s:2:\"47\";s:30:\"wyp_revslider_layer_animations\";s:1:\"0\";s:34:\"wyp_revslider_layer_animations_bkp\";s:1:\"0\";s:25:\"wyp_revslider_navigations\";s:1:\"2\";s:29:\"wyp_revslider_navigations_bkp\";s:1:\"0\";s:21:\"wyp_revslider_sliders\";s:1:\"1\";s:25:\"wyp_revslider_sliders_bkp\";s:1:\"0\";s:20:\"wyp_revslider_slides\";s:1:\"3\";s:24:\"wyp_revslider_slides_bkp\";s:1:\"0\";s:27:\"wyp_revslider_static_slides\";s:1:\"1\";s:31:\"wyp_revslider_static_slides_bkp\";s:1:\"0\";s:22:\"wyp_term_relationships\";s:2:\"93\";s:17:\"wyp_term_taxonomy\";s:2:\"48\";s:12:\"wyp_termmeta\";s:2:\"39\";s:9:\"wyp_terms\";s:2:\"48\";s:20:\"wyp_tinvwl_analytics\";s:1:\"0\";s:16:\"wyp_tinvwl_items\";s:1:\"0\";s:16:\"wyp_tinvwl_lists\";s:1:\"1\";s:12:\"wyp_usermeta\";s:2:\"31\";s:9:\"wyp_users\";s:1:\"1\";s:25:\"wyp_wc_admin_note_actions\";s:2:\"40\";s:18:\"wyp_wc_admin_notes\";s:2:\"36\";s:22:\"wyp_wc_category_lookup\";s:1:\"2\";s:22:\"wyp_wc_customer_lookup\";s:1:\"0\";s:19:\"wyp_wc_download_log\";s:1:\"0\";s:26:\"wyp_wc_order_coupon_lookup\";s:1:\"0\";s:27:\"wyp_wc_order_product_lookup\";s:1:\"0\";s:18:\"wyp_wc_order_stats\";s:1:\"0\";s:23:\"wyp_wc_order_tax_lookup\";s:1:\"0\";s:32:\"wyp_wc_product_attributes_lookup\";s:1:\"0\";s:26:\"wyp_wc_product_meta_lookup\";s:2:\"10\";s:18:\"wyp_wc_rate_limits\";s:1:\"0\";s:21:\"wyp_wc_reserved_stock\";s:1:\"0\";s:23:\"wyp_wc_tax_rate_classes\";s:1:\"2\";s:15:\"wyp_wc_webhooks\";s:1:\"0\";s:24:\"wyp_woocommerce_api_keys\";s:1:\"0\";s:36:\"wyp_woocommerce_attribute_taxonomies\";s:1:\"0\";s:48:\"wyp_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:19:\"wyp_woocommerce_log\";s:1:\"0\";s:30:\"wyp_woocommerce_order_itemmeta\";s:1:\"0\";s:27:\"wyp_woocommerce_order_items\";s:1:\"0\";s:33:\"wyp_woocommerce_payment_tokenmeta\";s:1:\"0\";s:30:\"wyp_woocommerce_payment_tokens\";s:1:\"0\";s:24:\"wyp_woocommerce_sessions\";s:1:\"1\";s:39:\"wyp_woocommerce_shipping_zone_locations\";s:1:\"0\";s:37:\"wyp_woocommerce_shipping_zone_methods\";s:1:\"0\";s:30:\"wyp_woocommerce_shipping_zones\";s:1:\"0\";s:34:\"wyp_woocommerce_tax_rate_locations\";s:1:\"0\";s:25:\"wyp_woocommerce_tax_rates\";s:1:\"0\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:140:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp/20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-04-18 15:28:30\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.3\";s:9:\"VersionDB\";s:6:\"10.6.7\";s:10:\"VersionPHP\";s:6:\"7.4.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20220319_nicosloane_ForApril_new\";s:4:\"Hash\";s:35:\"c0396bf7caf346733971_20220418152830\";s:8:\"NameHash\";s:68:\"20220319_nicosloane_ForApril_new_c0396bf7caf346733971_20220418152830\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:189;}}}");
INSERT INTO `wyp_duplicator_packages` VALUES("8", "20230823_nicosloane_Aug_new", "814d86973e34e38e8550_20230823103615", "100", "2023-08-23 10:37:10", "LazyboI", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-08-23 10:36:15\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:3:\"6.3\";s:9:\"VersionDB\";s:7:\"10.6.14\";s:10:\"VersionPHP\";s:5:\"8.1.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:8;s:4:\"Name\";s:27:\"20230823_nicosloane_Aug_new\";s:4:\"Hash\";s:35:\"814d86973e34e38e8550_20230823103615\";s:8:\"NameHash\";s:63:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:73:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"68.05 sec.\";s:7:\"ExeSize\";s:7:\"73.48KB\";s:7:\"ZipSize\";s:8:\"210.59MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"LazyboI\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:75:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/nisloane/public_html\";s:4:\"Size\";i:220823563;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2968;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17983;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:20950;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/nisloane/public_html/wp-admin\";i:1;s:38:\"/home/nisloane/public_html/wp-includes\";i:2;s:47:\"/home/nisloane/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/nisloane/public_html\";i:1;s:26:\"/home/nisloane/public_html\";i:2;s:37:\"/home/nisloane/public_html/wp-content\";i:3;s:45:\"/home/nisloane/public_html/wp-content/uploads\";i:4;s:45:\"/home/nisloane/public_html/wp-content/plugins\";i:5;s:48:\"/home/nisloane/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/nisloane/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:81:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615_installer.php.bak\";s:4:\"Size\";i:75248;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:110:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp/original_files_814d869-23103615/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:90:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp/original_files_814d869-23103615\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:26:\"/home/nisloane/public_html\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/nisloane/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3197:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'nisloane_bsr\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'nisloane_bws\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'0N=g@5(=ST#}\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \')*_lr#)wK[mRUHxjtTZ;9.cx3,OgsGJQ67K8zDRhnHJ|c+g$#O#sz8T!JD/9Yw84\' );\ndefine( \'SECURE_AUTH_KEY\',  \'YNQEtg:[g@-u,=C{q#W8}xqfv9-HsQ1snpk[`[q}{FHI!iB$:tVLM]lp@O%4B}wc\' );\ndefine( \'LOGGED_IN_KEY\',    \'+%.9+*;&dDfWO3Sa4{D2,5FLM_hu$l{3-u2S5p7^T}F]hgeiXBKcEZ8yx+i/p1N \' );\ndefine( \'NONCE_KEY\',        \'sIDGfbgL}vk5zs+O]T-uQf&(O pq=i,yN?@%Pli+L(k,|lDdne)mLrgt9;v@f|/q\' );\ndefine( \'AUTH_SALT\',        \'HX#6*6z^M {Zgmu[a[Qq@0:~8OMajA]{}Y/K:k8BocuI0iLe$vbWFN0{a%QYxM1*\' );\ndefine( \'SECURE_AUTH_SALT\', \'%9GyYKdjTGEfF3p?=60l9;`kpJ/C^l?IXcjDX*m1GI|qoOL;1BrL[rn^Vc[T!Ef6\' );\ndefine( \'LOGGED_IN_SALT\',   \'L!>9OP #(~iG>OJO{gTmrJc#I Eg%8q>Jx4W<(#dTAxvyK4_h]SAM]x-JMt5)kaU\' );\ndefine( \'NONCE_SALT\',       \'q<e] Unwt?B}`X?CE,P~@~vwWZ4D+?u&;s6!_P=}0sw -^g!sO$zDULplk+]vyls\' );\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wyp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:16:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:36:\"define( \'DB_NAME\', \'nisloane_bsr\' );\";s:5:\"value\";s:14:\"\'nisloane_bsr\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:17:\", \'nisloane_bsr\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:36:\"define( \'DB_USER\', \'nisloane_bws\' );\";s:5:\"value\";s:14:\"\'nisloane_bws\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:17:\", \'nisloane_bws\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:40:\"define( \'DB_PASSWORD\', \'0N=g@5(=ST#}\' );\";s:5:\"value\";s:14:\"\'0N=g@5(=ST#}\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:17:\", \'0N=g@5(=ST#}\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \')*_lr#)wK[mRUHxjtTZ;9.cx3,OgsGJQ67K8zDRhnHJ|c+g$#O#sz8T!JD/9Yw84\' );\";s:5:\"value\";s:66:\"\')*_lr#)wK[mRUHxjtTZ;9.cx3,OgsGJQ67K8zDRhnHJ|c+g$#O#sz8T!JD/9Yw84\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \')*_lr#)wK[mRUHxjtTZ;9.cx3,OgsGJQ67K8zDRhnHJ|c+g$#O#sz8T!JD/9Yw84\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'YNQEtg:[g@-u,=C{q#W8}xqfv9-HsQ1snpk[`[q}{FHI!iB$:tVLM]lp@O%4B}wc\' );\";s:5:\"value\";s:66:\"\'YNQEtg:[g@-u,=C{q#W8}xqfv9-HsQ1snpk[`[q}{FHI!iB$:tVLM]lp@O%4B}wc\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'YNQEtg:[g@-u,=C{q#W8}xqfv9-HsQ1snpk[`[q}{FHI!iB$:tVLM]lp@O%4B}wc\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'+%.9+*;&dDfWO3Sa4{D2,5FLM_hu$l{3-u2S5p7^T}F]hgeiXBKcEZ8yx+i/p1N \' );\";s:5:\"value\";s:66:\"\'+%.9+*;&dDfWO3Sa4{D2,5FLM_hu$l{3-u2S5p7^T}F]hgeiXBKcEZ8yx+i/p1N \'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'+%.9+*;&dDfWO3Sa4{D2,5FLM_hu$l{3-u2S5p7^T}F]hgeiXBKcEZ8yx+i/p1N \' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'sIDGfbgL}vk5zs+O]T-uQf&(O pq=i,yN?@%Pli+L(k,|lDdne)mLrgt9;v@f|/q\' );\";s:5:\"value\";s:66:\"\'sIDGfbgL}vk5zs+O]T-uQf&(O pq=i,yN?@%Pli+L(k,|lDdne)mLrgt9;v@f|/q\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'sIDGfbgL}vk5zs+O]T-uQf&(O pq=i,yN?@%Pli+L(k,|lDdne)mLrgt9;v@f|/q\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'HX#6*6z^M {Zgmu[a[Qq@0:~8OMajA]{}Y/K:k8BocuI0iLe$vbWFN0{a%QYxM1*\' );\";s:5:\"value\";s:66:\"\'HX#6*6z^M {Zgmu[a[Qq@0:~8OMajA]{}Y/K:k8BocuI0iLe$vbWFN0{a%QYxM1*\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'HX#6*6z^M {Zgmu[a[Qq@0:~8OMajA]{}Y/K:k8BocuI0iLe$vbWFN0{a%QYxM1*\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'%9GyYKdjTGEfF3p?=60l9;`kpJ/C^l?IXcjDX*m1GI|qoOL;1BrL[rn^Vc[T!Ef6\' );\";s:5:\"value\";s:66:\"\'%9GyYKdjTGEfF3p?=60l9;`kpJ/C^l?IXcjDX*m1GI|qoOL;1BrL[rn^Vc[T!Ef6\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'%9GyYKdjTGEfF3p?=60l9;`kpJ/C^l?IXcjDX*m1GI|qoOL;1BrL[rn^Vc[T!Ef6\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'L!>9OP #(~iG>OJO{gTmrJc#I Eg%8q>Jx4W<(#dTAxvyK4_h]SAM]x-JMt5)kaU\' );\";s:5:\"value\";s:66:\"\'L!>9OP #(~iG>OJO{gTmrJc#I Eg%8q>Jx4W<(#dTAxvyK4_h]SAM]x-JMt5)kaU\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'L!>9OP #(~iG>OJO{gTmrJc#I Eg%8q>Jx4W<(#dTAxvyK4_h]SAM]x-JMt5)kaU\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'q<e] Unwt?B}`X?CE,P~@~vwWZ4D+?u&;s6!_P=}0sw -^g!sO$zDULplk+]vyls\' );\";s:5:\"value\";s:66:\"\'q<e] Unwt?B}`X?CE,P~@~vwWZ4D+?u&;s6!_P=}0sw -^g!sO$zDULplk+]vyls\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'q<e] Unwt?B}`X?CE,P~@~vwWZ4D+?u&;s6!_P=}0sw -^g!sO$zDULplk+]vyls\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:23:\"$table_prefix = \'wyp_\';\";s:5:\"value\";s:6:\"\'wyp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:8:\" \'wyp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:19283546;s:4:\"File\";s:76:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:4:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb3_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"MyISAM\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:12:\"nisloane_bsr\";s:15:\"tablesBaseCount\";i:78;s:16:\"tablesFinalCount\";i:78;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:9407;s:16:\"tablesSizeOnDisk\";i:17979262;s:10:\"tablesList\";a:78:{s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:7492;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:122;s:12:\"insertedRows\";i:122;s:4:\"size\";i:59296;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:10344;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:19312;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:13352;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:3093;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:4136;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:15;s:12:\"insertedRows\";i:15;s:4:\"size\";i:10912;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:8316;}s:27:\"wyp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:17;s:12:\"insertedRows\";i:17;s:4:\"size\";i:27516;}s:26:\"wyp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:3086;}s:26:\"wyp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:9364;}s:24:\"wyp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:51;s:12:\"insertedRows\";i:51;s:4:\"size\";i:16576;}s:15:\"wyp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:12:\"wyp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:8516;}s:23:\"wyp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16796;}s:17:\"wyp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:401;s:12:\"insertedRows\";i:401;s:4:\"size\";i:272452;}s:29:\"wyp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:81;s:12:\"insertedRows\";i:81;s:4:\"size\";i:20544;}s:24:\"wyp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:1201;s:12:\"insertedRows\";i:1201;s:4:\"size\";i:792828;}s:9:\"wyp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:17:\"wyp_litespeed_url\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:22:\"wyp_litespeed_url_file\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wyp_options\";a:3:{s:14:\"inaccurateRows\";i:702;s:12:\"insertedRows\";i:702;s:4:\"size\";i:3728700;}s:12:\"wyp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:5719;s:12:\"insertedRows\";i:5719;s:4:\"size\";i:9796928;}s:9:\"wyp_posts\";a:3:{s:14:\"inaccurateRows\";i:376;s:12:\"insertedRows\";i:376;s:4:\"size\";i:2336684;}s:17:\"wyp_revslider_css\";a:3:{s:14:\"inaccurateRows\";i:109;s:12:\"insertedRows\";i:109;s:4:\"size\";i:100772;}s:21:\"wyp_revslider_css_bkp\";a:3:{s:14:\"inaccurateRows\";i:47;s:12:\"insertedRows\";i:47;s:4:\"size\";i:19064;}s:30:\"wyp_revslider_layer_animations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"wyp_revslider_layer_animations_bkp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"wyp_revslider_navigations\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:5328;}s:29:\"wyp_revslider_navigations_bkp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:21:\"wyp_revslider_sliders\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:12532;}s:25:\"wyp_revslider_sliders_bkp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"wyp_revslider_slides\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:67188;}s:24:\"wyp_revslider_slides_bkp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:27:\"wyp_revslider_static_slides\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:4320;}s:31:\"wyp_revslider_static_slides_bkp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:12:\"wyp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:39;s:4:\"size\";i:12532;}s:9:\"wyp_terms\";a:3:{s:14:\"inaccurateRows\";i:48;s:12:\"insertedRows\";i:48;s:4:\"size\";i:14936;}s:22:\"wyp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:93;s:12:\"insertedRows\";i:93;s:4:\"size\";i:9121;}s:17:\"wyp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:48;s:12:\"insertedRows\";i:48;s:4:\"size\";i:8232;}s:20:\"wyp_tinvwl_analytics\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wyp_tinvwl_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wyp_tinvwl_lists\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2096;}s:12:\"wyp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:32;s:12:\"insertedRows\";i:32;s:4:\"size\";i:13456;}s:9:\"wyp_users\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:8316;}s:18:\"wyp_wc_admin_notes\";a:3:{s:14:\"inaccurateRows\";i:36;s:12:\"insertedRows\";i:36;s:4:\"size\";i:17728;}s:25:\"wyp_wc_admin_note_actions\";a:3:{s:14:\"inaccurateRows\";i:40;s:12:\"insertedRows\";i:40;s:4:\"size\";i:9168;}s:22:\"wyp_wc_category_lookup\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}s:22:\"wyp_wc_customer_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:19:\"wyp_wc_download_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wyp_wc_order_coupon_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:27:\"wyp_wc_order_product_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wyp_wc_order_stats\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:23:\"wyp_wc_order_tax_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:32:\"wyp_wc_product_attributes_lookup\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wyp_wc_product_meta_lookup\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:10824;}s:18:\"wyp_wc_rate_limits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:21:\"wyp_wc_reserved_stock\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:23:\"wyp_wc_tax_rate_classes\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:9288;}s:15:\"wyp_wc_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"wyp_woocommerce_api_keys\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:36:\"wyp_woocommerce_attribute_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:48:\"wyp_woocommerce_downloadable_product_permissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:19:\"wyp_woocommerce_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:30:\"wyp_woocommerce_order_itemmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:27:\"wyp_woocommerce_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:33:\"wyp_woocommerce_payment_tokenmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:30:\"wyp_woocommerce_payment_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"wyp_woocommerce_sessions\";a:3:{s:14:\"inaccurateRows\";i:190;s:12:\"insertedRows\";i:190;s:4:\"size\";i:426644;}s:30:\"wyp_woocommerce_shipping_zones\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:39:\"wyp_woocommerce_shipping_zone_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:37:\"wyp_woocommerce_shipping_zone_methods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"wyp_woocommerce_tax_rates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"wyp_woocommerce_tax_rate_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:7:\"MariaDB\";s:7:\"version\";s:7:\"10.6.14\";s:14:\"versionComment\";s:14:\"MariaDB Server\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:135:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp/20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-08-23 10:36:15\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:3:\"6.3\";s:9:\"VersionDB\";s:7:\"10.6.14\";s:10:\"VersionPHP\";s:5:\"8.1.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"20230823_nicosloane_Aug_new\";s:4:\"Hash\";s:35:\"814d86973e34e38e8550_20230823103615\";s:8:\"NameHash\";s:63:\"20230823_nicosloane_Aug_new_814d86973e34e38e8550_20230823103615\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:227;s:13:\"BuildProgress\";r:586;}}}");
INSERT INTO `wyp_duplicator_packages` VALUES("9", "20240101_nicosloane_NewYear", "aab48f68631cf14b8945_20240101084220", "22", "2024-01-01 08:43:32", "LazyboI", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-01 08:42:20\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:3:\"6.3\";s:9:\"VersionDB\";s:7:\"10.6.16\";s:10:\"VersionPHP\";s:5:\"8.1.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:9;s:4:\"Name\";s:27:\"20240101_nicosloane_NewYear\";s:4:\"Hash\";s:35:\"aab48f68631cf14b8945_20240101084220\";s:8:\"NameHash\";s:63:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:73:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.3\";s:6:\"WPUser\";s:7:\"LazyboI\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:75:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/nisloane/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2975;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18020;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-01 08:42:20\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:3:\"6.3\";s:9:\"VersionDB\";s:7:\"10.6.16\";s:10:\"VersionPHP\";s:5:\"8.1.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"20240101_nicosloane_NewYear\";s:4:\"Hash\";s:35:\"aab48f68631cf14b8945_20240101084220\";s:8:\"NameHash\";s:63:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:81:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/nisloane/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:76:\"20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:135:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp/20240101_nicosloane_NewYear_aab48f68631cf14b8945_20240101084220_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/nisloane/public_html/wp-admin\";i:1;s:38:\"/home/nisloane/public_html/wp-includes\";i:2;s:47:\"/home/nisloane/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/nisloane/public_html\";i:1;s:26:\"/home/nisloane/public_html\";i:2;s:37:\"/home/nisloane/public_html/wp-content\";i:3;s:45:\"/home/nisloane/public_html/wp-content/uploads\";i:4;s:45:\"/home/nisloane/public_html/wp-content/plugins\";i:5;s:48:\"/home/nisloane/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/nisloane/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/nisloane/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wyp_e_submissions */
INSERT INTO `wyp_e_submissions` VALUES("1", "submission", "2be52907-d533-43b7-b85c-25cf0bc0bb6b", "1", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.10.247", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-04-17 07:12:33", "2022-04-17 07:12:34", "2022-04-17 07:12:33", "2022-04-17 07:12:34");
INSERT INTO `wyp_e_submissions` VALUES("2", "submission", "4290a193-9b4a-4bf9-b8d3-c34f77395f04", "4", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.3.4.248", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-06-03 13:51:04", "2022-06-03 13:51:05", "2022-06-03 13:51:04", "2022-06-03 13:51:05");
INSERT INTO `wyp_e_submissions` VALUES("3", "submission", "07f319ee-3f8f-4c7f-8b0f-000e049d70e3", "7", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "154.16.4.52", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-06-11 17:29:59", "2022-06-11 17:30:00", "2022-06-11 17:29:59", "2022-06-11 17:30:00");
INSERT INTO `wyp_e_submissions` VALUES("4", "submission", "4e8c54b6-e3c1-4d72-8ba0-5fa36d7888d0", "10", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.172.130.195", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.139 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-07-01 22:47:50", "2022-07-01 22:47:50", "2022-07-01 22:47:50", "2022-07-01 22:47:50");
INSERT INTO `wyp_e_submissions` VALUES("5", "submission", "8930454d-81d9-4a8f-bfde-261d13780ecf", "13", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.210.165.118", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.139 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-07-02 01:14:51", "2022-07-02 01:14:52", "2022-07-02 01:14:51", "2022-07-02 01:14:52");
INSERT INTO `wyp_e_submissions` VALUES("6", "submission", "494b212d-6e8a-4f86-8a71-6047af5b4829", "16", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "96.8.122.11", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.66 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-07-03 09:20:56", "2022-07-03 09:20:56", "2022-07-03 09:20:56", "2022-07-03 09:20:56");
INSERT INTO `wyp_e_submissions` VALUES("7", "submission", "09ca248f-ce6c-4593-8839-8f42dc560180", "19", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.172.35.25", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/10.1.2 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-07-06 14:19:49", "2022-07-06 14:19:50", "2022-07-06 14:19:49", "2022-07-06 14:19:50");
INSERT INTO `wyp_e_submissions` VALUES("8", "submission", "add0a00a-9425-454e-800c-eaac15456721", "22", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.182.215", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-07-11 18:12:32", "2022-07-11 18:12:32", "2022-07-11 18:12:32", "2022-07-11 18:12:32");
INSERT INTO `wyp_e_submissions` VALUES("9", "submission", "e6930b5b-075f-4486-9f89-5790aaa69925", "25", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "105.112.182.29", "Mozilla/5.0 (Linux; Android 11; SAMSUNG SM-A125F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/18.0 Chrome/99.0.4844.88 Mobile Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-08 09:52:06", "2022-09-08 09:52:07", "2022-09-08 09:52:06", "2022-09-08 09:52:07");
INSERT INTO `wyp_e_submissions` VALUES("10", "submission", "1948f7fb-34bb-464d-8e48-1cb5d905fc60", "28", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.31.13", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-09 22:09:40", "2022-09-09 22:09:40", "2022-09-09 22:09:40", "2022-09-09 22:09:40");
INSERT INTO `wyp_e_submissions` VALUES("11", "submission", "ddba1b82-a5f2-4418-925a-09d9cf35dab0", "31", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "209.127.28.137", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-12 05:12:06", "2022-09-12 05:12:07", "2022-09-12 05:12:06", "2022-09-12 05:12:07");
INSERT INTO `wyp_e_submissions` VALUES("12", "submission", "53e5a3b0-15f8-4357-b217-2546c916021f", "34", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.6", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-14 07:29:52", "2022-09-14 07:29:52", "2022-09-14 07:29:52", "2022-09-14 07:29:52");
INSERT INTO `wyp_e_submissions` VALUES("13", "submission", "e09dfb3e-b739-407c-8685-8d8f6fb044a0", "37", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.151", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-18 08:26:44", "2022-09-18 08:26:44", "2022-09-18 08:26:44", "2022-09-18 08:26:44");
INSERT INTO `wyp_e_submissions` VALUES("14", "submission", "71840884-a898-4380-b594-ae2368016652", "40", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.152", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-18 08:26:52", "2022-09-18 08:26:53", "2022-09-18 08:26:52", "2022-09-18 08:26:53");
INSERT INTO `wyp_e_submissions` VALUES("15", "submission", "93b03870-bbb5-4182-b62f-702ada97922b", "43", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.136", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-21 04:43:52", "2022-09-21 04:43:52", "2022-09-21 04:43:52", "2022-09-21 04:43:52");
INSERT INTO `wyp_e_submissions` VALUES("16", "submission", "4415a0e5-5d2d-461e-967c-c4d1c5e2f2ba", "46", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.105", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-21 06:16:13", "2022-09-21 06:16:15", "2022-09-21 06:16:13", "2022-09-21 06:16:15");
INSERT INTO `wyp_e_submissions` VALUES("17", "submission", "504be86c-6959-4ce1-a762-c380be2b9e34", "49", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-24 21:34:50", "2022-09-24 21:34:51", "2022-09-24 21:34:50", "2022-09-24 21:34:51");
INSERT INTO `wyp_e_submissions` VALUES("18", "submission", "60f89dd6-0ca4-485f-8779-4e963257cf21", "52", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "172.245.220.204", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-25 17:56:21", "2022-09-25 17:56:22", "2022-09-25 17:56:21", "2022-09-25 17:56:22");
INSERT INTO `wyp_e_submissions` VALUES("19", "submission", "071b18fb-9ad2-4b41-9b63-0796e55260f8", "55", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.142", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-09-30 21:14:57", "2022-09-30 21:14:58", "2022-09-30 21:14:57", "2022-09-30 21:14:58");
INSERT INTO `wyp_e_submissions` VALUES("20", "submission", "9ad152cb-1929-4e1d-ab6f-f52e2b3e8b86", "58", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.80.92", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-05 00:06:40", "2022-10-05 00:06:42", "2022-10-05 00:06:40", "2022-10-05 00:06:42");
INSERT INTO `wyp_e_submissions` VALUES("21", "submission", "20c75691-a7c1-4a6f-b18b-f239cb778537", "61", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.63.158", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-05 10:05:50", "2022-10-05 10:05:51", "2022-10-05 10:05:50", "2022-10-05 10:05:51");
INSERT INTO `wyp_e_submissions` VALUES("22", "submission", "c27627eb-2f93-4a30-b7a9-2118acba7a8f", "64", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.46", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-05 16:32:43", "2022-10-05 16:32:43", "2022-10-05 16:32:43", "2022-10-05 16:32:43");
INSERT INTO `wyp_e_submissions` VALUES("23", "submission", "96d61085-c70c-402a-8f76-d1d919159cd3", "67", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.217.26", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-10 10:06:39", "2022-10-10 10:06:40", "2022-10-10 10:06:39", "2022-10-10 10:06:40");
INSERT INTO `wyp_e_submissions` VALUES("24", "submission", "c26012bd-de36-4fe1-a93e-3ea5aa6eb63e", "70", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.71", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-10 23:17:02", "2022-10-10 23:17:02", "2022-10-10 23:17:02", "2022-10-10 23:17:02");
INSERT INTO `wyp_e_submissions` VALUES("25", "submission", "4d600664-6347-4651-a17b-ca90b03f78ed", "73", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.215.176.24", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-16 18:51:37", "2022-10-16 18:51:37", "2022-10-16 18:51:37", "2022-10-16 18:51:37");
INSERT INTO `wyp_e_submissions` VALUES("26", "submission", "5d9718d7-7166-4d44-9b47-ffda11b92082", "76", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.47", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-17 01:23:57", "2022-10-17 01:23:57", "2022-10-17 01:23:57", "2022-10-17 01:23:57");
INSERT INTO `wyp_e_submissions` VALUES("27", "submission", "92c4bc04-2a63-425f-b3aa-a72c7705d9ac", "79", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.215.176.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.39", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-19 08:15:10", "2022-10-19 08:15:11", "2022-10-19 08:15:10", "2022-10-19 08:15:11");
INSERT INTO `wyp_e_submissions` VALUES("28", "submission", "c37cd0b7-49b4-4778-b14f-12261f580f88", "82", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.45", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.49", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-21 18:10:39", "2022-10-21 18:10:39", "2022-10-21 18:10:39", "2022-10-21 18:10:39");
INSERT INTO `wyp_e_submissions` VALUES("29", "submission", "c0dd6ac4-425c-4224-b3dc-b575200e3b2e", "85", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "172.245.220.204", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-22 02:51:29", "2022-10-22 02:51:29", "2022-10-22 02:51:29", "2022-10-22 02:51:29");
INSERT INTO `wyp_e_submissions` VALUES("30", "submission", "749551e0-e4b0-4a5a-8530-e9229de1b112", "88", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.70", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-23 05:41:50", "2022-10-23 05:41:51", "2022-10-23 05:41:50", "2022-10-23 05:41:51");
INSERT INTO `wyp_e_submissions` VALUES("31", "submission", "80007e86-5282-4b9f-87db-c61c96f07022", "91", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.29.50", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.86 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-24 03:01:04", "2022-10-24 03:01:04", "2022-10-24 03:01:04", "2022-10-24 03:01:04");
INSERT INTO `wyp_e_submissions` VALUES("32", "submission", "97fdf11d-9be1-419d-8a99-50fc5f74a993", "94", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.15", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-25 23:28:53", "2022-10-25 23:28:53", "2022-10-25 23:28:53", "2022-10-25 23:28:53");
INSERT INTO `wyp_e_submissions` VALUES("33", "submission", "68abe8d3-799d-4586-8088-114e2484ddd6", "97", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.27", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-27 05:47:44", "2022-10-27 05:47:44", "2022-10-27 05:47:44", "2022-10-27 05:47:44");
INSERT INTO `wyp_e_submissions` VALUES("34", "submission", "d9e2665b-4bb0-4524-993e-a2f6859a5e38", "100", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.49.43", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-10-27 17:17:27", "2022-10-27 17:17:27", "2022-10-27 17:17:27", "2022-10-27 17:17:27");
INSERT INTO `wyp_e_submissions` VALUES("35", "submission", "75d35693-0c99-494e-a6e8-7607c67fe677", "103", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "144.168.228.75", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-02 20:01:56", "2022-11-02 20:01:57", "2022-11-02 20:01:56", "2022-11-02 20:01:57");
INSERT INTO `wyp_e_submissions` VALUES("36", "submission", "b0bbc4cc-281a-4f84-9e2f-c4df93023a57", "106", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.201.215", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-03 17:27:17", "2022-11-03 17:27:18", "2022-11-03 17:27:17", "2022-11-03 17:27:18");
INSERT INTO `wyp_e_submissions` VALUES("37", "submission", "b65a5320-f2df-43cf-890a-2e9560b149e5", "109", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "143.244.37.30", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-12 23:20:34", "2022-11-12 23:20:34", "2022-11-12 23:20:34", "2022-11-12 23:20:34");
INSERT INTO `wyp_e_submissions` VALUES("38", "submission", "0f8cccce-2c71-4870-88b8-88d491894b53", "112", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.222.121", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-18 17:39:27", "2022-11-18 17:39:28", "2022-11-18 17:39:27", "2022-11-18 17:39:28");
INSERT INTO `wyp_e_submissions` VALUES("39", "submission", "63c38920-77c9-4c9c-9433-54f720862bec", "115", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "172.245.220.204", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-19 11:20:38", "2022-11-19 11:20:38", "2022-11-19 11:20:38", "2022-11-19 11:20:38");
INSERT INTO `wyp_e_submissions` VALUES("40", "submission", "3ff71b6b-d164-4e05-857d-28649009e046", "118", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.99.109", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-22 15:53:13", "2022-11-22 15:53:13", "2022-11-22 15:53:13", "2022-11-22 15:53:13");
INSERT INTO `wyp_e_submissions` VALUES("41", "submission", "255910a0-c776-45cc-bcf2-452a99503af4", "121", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.157.61.132", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-23 06:32:59", "2022-11-23 06:32:59", "2022-11-23 06:32:59", "2022-11-23 06:32:59");
INSERT INTO `wyp_e_submissions` VALUES("42", "submission", "31925d9c-8652-4051-a724-fea994dbc2c0", "124", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.230", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-24 20:50:57", "2022-11-24 20:50:57", "2022-11-24 20:50:57", "2022-11-24 20:50:57");
INSERT INTO `wyp_e_submissions` VALUES("43", "submission", "bc0c3703-5d9c-41a2-95bf-5722b0cbcf70", "127", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.36.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-25 06:23:19", "2022-11-25 06:23:19", "2022-11-25 06:23:19", "2022-11-25 06:23:19");
INSERT INTO `wyp_e_submissions` VALUES("44", "submission", "6aa780ac-cb82-4024-989c-4c9eccab0664", "130", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.157.62.217", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-28 00:58:30", "2022-11-28 00:58:31", "2022-11-28 00:58:30", "2022-11-28 00:58:31");
INSERT INTO `wyp_e_submissions` VALUES("45", "submission", "0c8e3889-e7a2-4c62-be0b-27912c02e5f7", "133", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.224.85", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-28 17:28:55", "2022-11-28 17:28:55", "2022-11-28 17:28:55", "2022-11-28 17:28:55");
INSERT INTO `wyp_e_submissions` VALUES("46", "submission", "c7779e63-65c0-4324-8d7b-e1a9bd87f818", "136", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.157.61.132", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-29 15:29:37", "2022-11-29 15:29:37", "2022-11-29 15:29:37", "2022-11-29 15:29:37");
INSERT INTO `wyp_e_submissions` VALUES("47", "submission", "e270dde3-5477-452f-94aa-0037d830af1a", "139", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.47.6", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-11-29 21:21:06", "2022-11-29 21:21:06", "2022-11-29 21:21:06", "2022-11-29 21:21:06");
INSERT INTO `wyp_e_submissions` VALUES("48", "submission", "834ed5b6-7f49-4abb-8b15-e64742977fd7", "142", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.157.8.89", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-02 16:00:57", "2022-12-02 16:00:57", "2022-12-02 16:00:57", "2022-12-02 16:00:57");
INSERT INTO `wyp_e_submissions` VALUES("49", "submission", "4aeb7aa1-5be4-40d8-88ea-87a6aa0634e5", "145", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.255.195", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-04 02:49:20", "2022-12-04 02:49:20", "2022-12-04 02:49:20", "2022-12-04 02:49:20");
INSERT INTO `wyp_e_submissions` VALUES("50", "submission", "94e714d6-fadb-44d1-b846-08b779ee9a9c", "148", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.189.114.116", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-04 07:58:40", "2022-12-04 07:58:40", "2022-12-04 07:58:40", "2022-12-04 07:58:40");
INSERT INTO `wyp_e_submissions` VALUES("51", "submission", "7b9401e6-b698-4a53-b169-e00fd7d4339b", "151", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.53.19", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-08 18:04:14", "2022-12-08 18:04:14", "2022-12-08 18:04:14", "2022-12-08 18:04:14");
INSERT INTO `wyp_e_submissions` VALUES("52", "submission", "26ce34ab-d4b7-4bde-93d7-1d96a6b42232", "154", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.55.220", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-08 23:38:08", "2022-12-08 23:38:08", "2022-12-08 23:38:08", "2022-12-08 23:38:08");
INSERT INTO `wyp_e_submissions` VALUES("53", "submission", "327ff018-4f4a-4ba5-af57-0bc7459338b7", "157", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.123.220", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-10 11:41:44", "2022-12-10 11:41:44", "2022-12-10 11:41:44", "2022-12-10 11:41:44");
INSERT INTO `wyp_e_submissions` VALUES("54", "submission", "01e99d12-39a8-4e1f-a901-9dbb92301d0d", "160", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.221.234.201", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-11 20:26:04", "2022-12-11 20:26:04", "2022-12-11 20:26:04", "2022-12-11 20:26:04");
INSERT INTO `wyp_e_submissions` VALUES("55", "submission", "f592d48c-fab2-4bfc-b33f-9bb70b33b7d2", "163", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.219.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-13 02:24:46", "2022-12-13 02:24:46", "2022-12-13 02:24:46", "2022-12-13 02:24:46");
INSERT INTO `wyp_e_submissions` VALUES("56", "submission", "c4ec2c22-2c4a-4ba0-a78a-e8c352de8826", "166", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.55.222", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-13 11:45:51", "2022-12-13 11:45:51", "2022-12-13 11:45:51", "2022-12-13 11:45:51");
INSERT INTO `wyp_e_submissions` VALUES("57", "submission", "5e391d98-6278-417d-97b1-c5fbe8da30ea", "169", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.36.191", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-15 04:01:28", "2022-12-15 04:01:28", "2022-12-15 04:01:28", "2022-12-15 04:01:28");
INSERT INTO `wyp_e_submissions` VALUES("58", "submission", "2f5c633b-709d-4539-8b18-ef7fdb63adf8", "172", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.204.110.160", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-16 08:19:32", "2022-12-16 08:19:33", "2022-12-16 08:19:32", "2022-12-16 08:19:33");
INSERT INTO `wyp_e_submissions` VALUES("59", "submission", "5f149226-ad8d-46e2-a5fc-7d6f65323ed6", "175", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.20", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-16 23:58:35", "2022-12-16 23:58:35", "2022-12-16 23:58:35", "2022-12-16 23:58:35");
INSERT INTO `wyp_e_submissions` VALUES("60", "submission", "513cf301-9bd0-492f-8aa3-9dd436d9ea31", "178", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "104.160.14.216", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-17 13:37:18", "2022-12-17 13:37:18", "2022-12-17 13:37:18", "2022-12-17 13:37:18");
INSERT INTO `wyp_e_submissions` VALUES("61", "submission", "958febe4-d6c8-4ded-b8de-2e5fa2de64b9", "181", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.9.183", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-19 19:29:54", "2022-12-19 19:29:54", "2022-12-19 19:29:54", "2022-12-19 19:29:54");
INSERT INTO `wyp_e_submissions` VALUES("62", "submission", "c5924e97-382b-44fb-a0ea-229343ccb505", "184", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "168.90.196.41", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-19 19:32:37", "2022-12-19 19:32:38", "2022-12-19 19:32:37", "2022-12-19 19:32:38");
INSERT INTO `wyp_e_submissions` VALUES("63", "submission", "9e42345d-24bd-4b4f-872d-fde73f0af4b1", "187", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.219.67", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-19 19:54:23", "2022-12-19 19:54:23", "2022-12-19 19:54:23", "2022-12-19 19:54:23");
INSERT INTO `wyp_e_submissions` VALUES("64", "submission", "d10cfce3-b141-49c9-a0bc-dd4dc99b2678", "190", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.213", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-20 13:09:33", "2022-12-20 13:09:33", "2022-12-20 13:09:33", "2022-12-20 13:09:33");
INSERT INTO `wyp_e_submissions` VALUES("65", "submission", "84ae0bb5-95a5-45db-b1f9-e76fdb39e7dc", "193", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.122", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-20 14:47:09", "2022-12-20 14:47:09", "2022-12-20 14:47:09", "2022-12-20 14:47:09");
INSERT INTO `wyp_e_submissions` VALUES("66", "submission", "67ba5a33-acbc-48ed-b144-6138d952a3ee", "196", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.142", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-20 15:49:41", "2022-12-20 15:49:42", "2022-12-20 15:49:41", "2022-12-20 15:49:42");
INSERT INTO `wyp_e_submissions` VALUES("67", "submission", "eaaa34e4-8d41-4dee-b08d-cbb0190263fc", "199", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.11", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-20 16:50:40", "2022-12-20 16:50:40", "2022-12-20 16:50:40", "2022-12-20 16:50:40");
INSERT INTO `wyp_e_submissions` VALUES("68", "submission", "bb39ecd0-0dad-442f-94ad-5f909df5e2f7", "202", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.181.118", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-22 22:44:16", "2022-12-22 22:44:16", "2022-12-22 22:44:16", "2022-12-22 22:44:16");
INSERT INTO `wyp_e_submissions` VALUES("69", "submission", "0d17ad68-5e99-4e83-be61-56c44fb32ed7", "205", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.8.55", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-23 19:43:41", "2022-12-23 19:43:42", "2022-12-23 19:43:41", "2022-12-23 19:43:42");
INSERT INTO `wyp_e_submissions` VALUES("70", "submission", "c503c55f-e077-46cc-a03a-b57647a98831", "208", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "50.3.82.78", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-26 08:17:03", "2022-12-26 08:17:03", "2022-12-26 08:17:03", "2022-12-26 08:17:03");
INSERT INTO `wyp_e_submissions` VALUES("71", "submission", "69a1e871-25c4-44f4-8d2b-33596c6a01b6", "211", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.235", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-27 18:49:10", "2022-12-27 18:49:10", "2022-12-27 18:49:10", "2022-12-27 18:49:10");
INSERT INTO `wyp_e_submissions` VALUES("72", "submission", "dd61f3a8-2194-4285-b2c1-2c8109e0a0a4", "214", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.200.141", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-28 12:25:47", "2022-12-28 12:25:47", "2022-12-28 12:25:47", "2022-12-28 12:25:47");
INSERT INTO `wyp_e_submissions` VALUES("73", "submission", "4f2dcf1d-8a57-4570-9e45-4e5060dec0dd", "217", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.90.40.135", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-28 22:10:16", "2022-12-28 22:10:16", "2022-12-28 22:10:16", "2022-12-28 22:10:16");
INSERT INTO `wyp_e_submissions` VALUES("74", "submission", "8efcf0ee-a4db-43e7-9f53-24c3515f4ea0", "220", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.24.11", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2022-12-29 12:02:06", "2022-12-29 12:02:06", "2022-12-29 12:02:06", "2022-12-29 12:02:06");
INSERT INTO `wyp_e_submissions` VALUES("75", "submission", "e21205b4-2a7c-4430-b664-f651382fdb6d", "223", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-01 12:18:15", "2023-01-01 12:18:18", "2023-01-01 12:18:15", "2023-01-01 12:18:18");
INSERT INTO `wyp_e_submissions` VALUES("76", "submission", "b90acd98-005c-4caa-986b-8a743a84cf6b", "226", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.203.30", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-02 01:09:27", "2023-01-02 01:09:28", "2023-01-02 01:09:27", "2023-01-02 01:09:28");
INSERT INTO `wyp_e_submissions` VALUES("77", "submission", "e6a44325-2309-40dd-a452-da9ef4b06e51", "229", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-06 10:37:58", "2023-01-06 10:37:58", "2023-01-06 10:37:58", "2023-01-06 10:37:58");
INSERT INTO `wyp_e_submissions` VALUES("78", "submission", "b20fe8c8-9607-4799-847e-52bb60345224", "232", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.224.12", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-07 19:18:14", "2023-01-07 19:18:15", "2023-01-07 19:18:14", "2023-01-07 19:18:15");
INSERT INTO `wyp_e_submissions` VALUES("79", "submission", "4202cacd-7f1a-4e28-941f-37c7b9ea8e3d", "235", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.181.123", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-09 00:26:57", "2023-01-09 00:26:57", "2023-01-09 00:26:57", "2023-01-09 00:26:57");
INSERT INTO `wyp_e_submissions` VALUES("80", "submission", "708aa22a-6ec7-4812-a197-e27ab8f4fc02", "238", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.130.85", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-09 05:22:54", "2023-01-09 05:22:54", "2023-01-09 05:22:54", "2023-01-09 05:22:54");
INSERT INTO `wyp_e_submissions` VALUES("81", "submission", "8ac6a3e3-255b-429a-adf3-4a8548361540", "241", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.51.3", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-11 00:55:24", "2023-01-11 00:55:24", "2023-01-11 00:55:24", "2023-01-11 00:55:24");
INSERT INTO `wyp_e_submissions` VALUES("82", "submission", "26d84639-019f-4104-ab18-4ca5b40bf22d", "244", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.122.108", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-12 17:50:25", "2023-01-12 17:50:25", "2023-01-12 17:50:25", "2023-01-12 17:50:25");
INSERT INTO `wyp_e_submissions` VALUES("83", "submission", "05b8ee53-9f0d-442c-b394-e4a6f92c4669", "247", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.164", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-12 17:58:52", "2023-01-12 17:58:52", "2023-01-12 17:58:52", "2023-01-12 17:58:52");
INSERT INTO `wyp_e_submissions` VALUES("84", "submission", "6c598fdc-86e6-4692-bf1b-040746cb5a78", "250", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "91.238.82.67", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4427.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-14 06:05:32", "2023-01-14 06:05:32", "2023-01-14 06:05:32", "2023-01-14 06:05:32");
INSERT INTO `wyp_e_submissions` VALUES("85", "submission", "491d6c8a-2741-460c-894d-f1b52f3b2fd0", "253", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.250.80", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-14 15:22:48", "2023-01-14 15:22:48", "2023-01-14 15:22:48", "2023-01-14 15:22:48");
INSERT INTO `wyp_e_submissions` VALUES("86", "submission", "50077afe-2629-4c1f-a0c7-b4069278d076", "256", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.176", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-14 15:31:07", "2023-01-14 15:31:07", "2023-01-14 15:31:07", "2023-01-14 15:31:07");
INSERT INTO `wyp_e_submissions` VALUES("87", "submission", "61948e50-9de5-4cac-bb90-9a4ccb08a183", "259", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.151.174", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-14 18:41:43", "2023-01-14 18:41:43", "2023-01-14 18:41:43", "2023-01-14 18:41:43");
INSERT INTO `wyp_e_submissions` VALUES("88", "submission", "bb5b79c2-3fd4-4b3e-a151-de4e90996716", "262", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.219", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-14 18:50:00", "2023-01-14 18:50:00", "2023-01-14 18:50:00", "2023-01-14 18:50:00");
INSERT INTO `wyp_e_submissions` VALUES("89", "submission", "97ed4a09-f621-435a-b6b9-00b1f23d3011", "265", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.9.203", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-15 12:35:12", "2023-01-15 12:35:12", "2023-01-15 12:35:12", "2023-01-15 12:35:12");
INSERT INTO `wyp_e_submissions` VALUES("90", "submission", "a43a0006-21ac-4a9d-b729-5f04f86561de", "268", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.200.108", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-15 12:42:20", "2023-01-15 12:42:20", "2023-01-15 12:42:20", "2023-01-15 12:42:20");
INSERT INTO `wyp_e_submissions` VALUES("91", "submission", "08ec16ad-a92a-480e-bc69-966db28dc74d", "271", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.206.17", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-16 12:37:18", "2023-01-16 12:37:18", "2023-01-16 12:37:18", "2023-01-16 12:37:18");
INSERT INTO `wyp_e_submissions` VALUES("92", "submission", "6e0b3a17-1aea-456f-a3d7-902ea51fbec1", "274", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "172.245.220.204", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-19 06:39:52", "2023-01-19 06:39:52", "2023-01-19 06:39:52", "2023-01-19 06:39:52");
INSERT INTO `wyp_e_submissions` VALUES("93", "submission", "1e0b41d5-4825-4919-9d22-4de1cdd7a004", "277", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.88", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-20 06:04:50", "2023-01-20 06:04:50", "2023-01-20 06:04:50", "2023-01-20 06:04:50");
INSERT INTO `wyp_e_submissions` VALUES("94", "submission", "9a7d0b15-92da-44f5-9bc0-099c98c13ad4", "280", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.147.43", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-20 06:13:19", "2023-01-20 06:13:19", "2023-01-20 06:13:19", "2023-01-20 06:13:19");
INSERT INTO `wyp_e_submissions` VALUES("95", "submission", "31a5f6c1-9db9-468e-a931-7ecf46685dc2", "283", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.132", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-21 10:13:39", "2023-01-21 10:13:39", "2023-01-21 10:13:39", "2023-01-21 10:13:39");
INSERT INTO `wyp_e_submissions` VALUES("96", "submission", "11766fac-2087-4bed-b7f8-9d10dcb71913", "286", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.57", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-22 22:29:54", "2023-01-22 22:29:54", "2023-01-22 22:29:54", "2023-01-22 22:29:54");
INSERT INTO `wyp_e_submissions` VALUES("97", "submission", "89bb25ff-8e9a-4245-8767-a53eaa538708", "289", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.78", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-22 22:47:57", "2023-01-22 22:47:57", "2023-01-22 22:47:57", "2023-01-22 22:47:57");
INSERT INTO `wyp_e_submissions` VALUES("98", "submission", "59ea418c-310a-4be5-bb4f-0cba98e6caef", "292", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "138.122.192.173", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-23 10:23:05", "2023-01-23 10:23:05", "2023-01-23 10:23:05", "2023-01-23 10:23:05");
INSERT INTO `wyp_e_submissions` VALUES("99", "submission", "85d0373f-d465-43fd-95ad-fa710aca3107", "295", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "138.122.192.173", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-23 10:27:01", "2023-01-23 10:27:01", "2023-01-23 10:27:01", "2023-01-23 10:27:01");
INSERT INTO `wyp_e_submissions` VALUES("100", "submission", "d6e3efcd-98da-44a2-81b7-63c0a38183d2", "298", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-24 19:51:24", "2023-01-24 19:51:24", "2023-01-24 19:51:24", "2023-01-24 19:51:24");
INSERT INTO `wyp_e_submissions` VALUES("101", "submission", "d55ca576-030a-4ffe-bfe0-b5b3b8b5126a", "301", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.219", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-25 09:59:12", "2023-01-25 09:59:12", "2023-01-25 09:59:12", "2023-01-25 09:59:12");
INSERT INTO `wyp_e_submissions` VALUES("102", "submission", "4f1e23fc-00df-4976-80ee-478d6415345e", "304", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.219", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-25 10:03:42", "2023-01-25 10:03:42", "2023-01-25 10:03:42", "2023-01-25 10:03:42");
INSERT INTO `wyp_e_submissions` VALUES("103", "submission", "a44a0590-b493-455c-b298-1a0138b8579f", "307", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "149.34.242.238", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-25 21:19:13", "2023-01-25 21:19:13", "2023-01-25 21:19:13", "2023-01-25 21:19:13");
INSERT INTO `wyp_e_submissions` VALUES("104", "submission", "4b3f1139-1ffb-417e-8412-535d88e9ebc6", "310", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.70.228", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-27 05:46:35", "2023-01-27 05:46:35", "2023-01-27 05:46:35", "2023-01-27 05:46:35");
INSERT INTO `wyp_e_submissions` VALUES("105", "submission", "86a6726c-2cc4-4279-b4c8-969c5878b462", "313", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.70.228", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-27 05:50:54", "2023-01-27 05:50:54", "2023-01-27 05:50:54", "2023-01-27 05:50:54");
INSERT INTO `wyp_e_submissions` VALUES("106", "submission", "9b28aa68-8b85-47a4-ac3c-ef611f0bcb6a", "316", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.182", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-27 23:56:32", "2023-01-27 23:56:32", "2023-01-27 23:56:32", "2023-01-27 23:56:32");
INSERT INTO `wyp_e_submissions` VALUES("107", "submission", "652752b4-5a51-4f83-8bd2-f3e0f607431d", "319", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.182", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-28 00:01:12", "2023-01-28 00:01:12", "2023-01-28 00:01:12", "2023-01-28 00:01:12");
INSERT INTO `wyp_e_submissions` VALUES("108", "submission", "d47accb2-433b-4e1e-91c8-cf90352129ca", "322", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.78", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-28 14:47:27", "2023-01-28 14:47:27", "2023-01-28 14:47:27", "2023-01-28 14:47:27");
INSERT INTO `wyp_e_submissions` VALUES("109", "submission", "6c31429b-3e12-49c3-8612-0998cab43b82", "325", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.78", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-28 14:51:50", "2023-01-28 14:51:50", "2023-01-28 14:51:50", "2023-01-28 14:51:50");
INSERT INTO `wyp_e_submissions` VALUES("110", "submission", "000c929e-f36f-4d79-a420-a77de441a4eb", "328", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.147.43", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-29 12:18:01", "2023-01-29 12:18:01", "2023-01-29 12:18:01", "2023-01-29 12:18:01");
INSERT INTO `wyp_e_submissions` VALUES("111", "submission", "3869240a-8a1e-4edb-8c44-a69559cf9cbd", "331", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.147.43", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-01-29 12:22:34", "2023-01-29 12:22:34", "2023-01-29 12:22:34", "2023-01-29 12:22:34");
INSERT INTO `wyp_e_submissions` VALUES("112", "submission", "9b8bffac-f05a-45cc-a6da-106dabcf1fe9", "334", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.63", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-01 01:36:04", "2023-02-01 01:36:04", "2023-02-01 01:36:04", "2023-02-01 01:36:04");
INSERT INTO `wyp_e_submissions` VALUES("113", "submission", "deb4e072-1510-4275-856d-55312c244662", "337", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-01 01:50:46", "2023-02-01 01:50:46", "2023-02-01 01:50:46", "2023-02-01 01:50:46");
INSERT INTO `wyp_e_submissions` VALUES("114", "submission", "680fbd01-0949-4585-a76b-f9357335ef7e", "340", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.178", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-01 05:47:26", "2023-02-01 05:47:26", "2023-02-01 05:47:26", "2023-02-01 05:47:26");
INSERT INTO `wyp_e_submissions` VALUES("115", "submission", "daa92c8e-38de-4b95-9bf7-0319460a7ff1", "343", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.99", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-01 06:00:30", "2023-02-01 06:00:30", "2023-02-01 06:00:30", "2023-02-01 06:00:30");
INSERT INTO `wyp_e_submissions` VALUES("116", "submission", "cadfc3ae-9620-4aaa-8b47-b481173bf2dd", "346", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.113", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-02 03:01:26", "2023-02-02 03:01:26", "2023-02-02 03:01:26", "2023-02-02 03:01:26");
INSERT INTO `wyp_e_submissions` VALUES("117", "submission", "b0575a24-dbd0-4562-860d-52a490bf9f6a", "349", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.71.8", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-06 04:13:03", "2023-02-06 04:13:03", "2023-02-06 04:13:03", "2023-02-06 04:13:03");
INSERT INTO `wyp_e_submissions` VALUES("118", "submission", "b968573c-6079-42ee-9845-3edba66473cf", "352", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.70.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-06 04:19:37", "2023-02-06 04:19:37", "2023-02-06 04:19:37", "2023-02-06 04:19:37");
INSERT INTO `wyp_e_submissions` VALUES("119", "submission", "a2077450-ac2b-460c-a0b8-3467d619cbfc", "355", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.71.227", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-06 04:25:43", "2023-02-06 04:25:43", "2023-02-06 04:25:43", "2023-02-06 04:25:43");
INSERT INTO `wyp_e_submissions` VALUES("120", "submission", "d4c4d5d7-8bf3-47cf-b8ef-023ffc15f679", "358", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-06 06:45:30", "2023-02-06 06:45:30", "2023-02-06 06:45:30", "2023-02-06 06:45:30");
INSERT INTO `wyp_e_submissions` VALUES("121", "submission", "45ad542c-7175-48fd-a5b8-e6e4b3ed6f44", "361", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.250.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-07 11:00:46", "2023-02-07 11:00:46", "2023-02-07 11:00:46", "2023-02-07 11:00:46");
INSERT INTO `wyp_e_submissions` VALUES("122", "submission", "625b3302-4c13-4dec-9aaa-ebec7a59b148", "364", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.119.198", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-09 11:21:17", "2023-02-09 11:21:17", "2023-02-09 11:21:17", "2023-02-09 11:21:17");
INSERT INTO `wyp_e_submissions` VALUES("123", "submission", "8799d5b0-485b-4cae-bdb7-f9d02f517025", "367", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.119.198", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-09 11:22:09", "2023-02-09 11:22:09", "2023-02-09 11:22:09", "2023-02-09 11:22:09");
INSERT INTO `wyp_e_submissions` VALUES("124", "submission", "1a3ee5c1-5f15-4730-a50b-e3c00a5d090c", "370", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.250", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-09 18:24:48", "2023-02-09 18:24:48", "2023-02-09 18:24:48", "2023-02-09 18:24:48");
INSERT INTO `wyp_e_submissions` VALUES("125", "submission", "270b3df0-1f76-4414-8174-7b838c95211b", "373", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "104.206.81.112", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-10 14:27:41", "2023-02-10 14:27:41", "2023-02-10 14:27:41", "2023-02-10 14:27:41");
INSERT INTO `wyp_e_submissions` VALUES("126", "submission", "cc34a073-48ea-4337-9923-2d40e18c38b6", "376", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "104.206.81.112", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-10 14:28:35", "2023-02-10 14:28:35", "2023-02-10 14:28:35", "2023-02-10 14:28:35");
INSERT INTO `wyp_e_submissions` VALUES("127", "submission", "2ef75d89-6e13-4357-b192-4488d3f276b1", "379", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.150.247", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-10 19:45:01", "2023-02-10 19:45:01", "2023-02-10 19:45:01", "2023-02-10 19:45:01");
INSERT INTO `wyp_e_submissions` VALUES("128", "submission", "393f8ce7-182e-4b22-8c28-5dbbf42dda01", "382", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.150.247", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-10 19:45:57", "2023-02-10 19:45:57", "2023-02-10 19:45:57", "2023-02-10 19:45:57");
INSERT INTO `wyp_e_submissions` VALUES("129", "submission", "24713152-afb1-4afa-8747-929c82c51d09", "385", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.195", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 03:32:51", "2023-02-12 03:32:51", "2023-02-12 03:32:51", "2023-02-12 03:32:51");
INSERT INTO `wyp_e_submissions` VALUES("130", "submission", "2b6ff304-a5ba-49f7-81e5-c5a9c750a4eb", "388", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.195", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 03:33:40", "2023-02-12 03:33:40", "2023-02-12 03:33:40", "2023-02-12 03:33:40");
INSERT INTO `wyp_e_submissions` VALUES("131", "submission", "021ff235-3344-4bd9-b293-c723ee51b7fd", "391", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.202.54", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 04:59:09", "2023-02-12 04:59:09", "2023-02-12 04:59:09", "2023-02-12 04:59:09");
INSERT INTO `wyp_e_submissions` VALUES("132", "submission", "378f6923-c478-41c4-a49f-416521d57fd0", "394", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.205.19", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 05:05:52", "2023-02-12 05:05:52", "2023-02-12 05:05:52", "2023-02-12 05:05:52");
INSERT INTO `wyp_e_submissions` VALUES("133", "submission", "04061b2f-c789-4141-ba3c-6cd12ee18b1b", "397", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.252.189.175", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 17:33:06", "2023-02-12 17:33:06", "2023-02-12 17:33:06", "2023-02-12 17:33:06");
INSERT INTO `wyp_e_submissions` VALUES("134", "submission", "6646a9fd-5fb0-4df8-b3ed-83edef8911cd", "400", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.92.178", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-12 17:39:59", "2023-02-12 17:39:59", "2023-02-12 17:39:59", "2023-02-12 17:39:59");
INSERT INTO `wyp_e_submissions` VALUES("135", "submission", "fd436673-ee5a-4af6-a7b9-7d5ea22009e1", "403", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.206.40", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-14 19:38:03", "2023-02-14 19:38:03", "2023-02-14 19:38:03", "2023-02-14 19:38:03");
INSERT INTO `wyp_e_submissions` VALUES("136", "submission", "d719a77f-6b09-4070-a1a7-dbb10b3eee77", "406", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.9.94", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-15 22:11:32", "2023-02-15 22:11:32", "2023-02-15 22:11:32", "2023-02-15 22:11:32");
INSERT INTO `wyp_e_submissions` VALUES("137", "submission", "f7a0d5ec-db52-4e83-8a06-4d40b0d84747", "409", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "172.245.84.232", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-15 22:17:16", "2023-02-15 22:17:16", "2023-02-15 22:17:16", "2023-02-15 22:17:16");
INSERT INTO `wyp_e_submissions` VALUES("138", "submission", "bcc0f50f-835f-46aa-b16b-ace49e7d0f22", "412", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.7", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-17 12:21:44", "2023-02-17 12:21:44", "2023-02-17 12:21:44", "2023-02-17 12:21:44");
INSERT INTO `wyp_e_submissions` VALUES("139", "submission", "d9deff16-f788-446c-99d5-9fce7ccd3eb2", "415", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.7", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-17 12:23:10", "2023-02-17 12:23:10", "2023-02-17 12:23:10", "2023-02-17 12:23:10");
INSERT INTO `wyp_e_submissions` VALUES("140", "submission", "455676c5-3330-4110-b8d1-3532f1787c4e", "418", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.37", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-18 09:03:17", "2023-02-18 09:03:17", "2023-02-18 09:03:17", "2023-02-18 09:03:17");
INSERT INTO `wyp_e_submissions` VALUES("141", "submission", "0e63434f-ea99-4aea-b70b-2cf8453b4656", "421", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.37", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-18 09:04:02", "2023-02-18 09:04:02", "2023-02-18 09:04:02", "2023-02-18 09:04:02");
INSERT INTO `wyp_e_submissions` VALUES("142", "submission", "debc34ac-ee7a-4244-a64c-6536f7e25079", "424", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "168.90.199.67", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-19 22:37:27", "2023-02-19 22:37:27", "2023-02-19 22:37:27", "2023-02-19 22:37:27");
INSERT INTO `wyp_e_submissions` VALUES("143", "submission", "baf24ecb-6c1e-4aa4-938d-247272f08144", "427", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "168.90.199.67", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-19 22:38:12", "2023-02-19 22:38:12", "2023-02-19 22:38:12", "2023-02-19 22:38:12");
INSERT INTO `wyp_e_submissions` VALUES("144", "submission", "2a44bfe2-4c37-42d0-9068-9d536e6542c4", "430", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.95.64", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 11:08:22", "2023-02-20 11:08:22", "2023-02-20 11:08:22", "2023-02-20 11:08:22");
INSERT INTO `wyp_e_submissions` VALUES("145", "submission", "fc866dfe-7def-4af5-a8b5-e1b7b8da252f", "433", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.53", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 11:15:39", "2023-02-20 11:15:39", "2023-02-20 11:15:39", "2023-02-20 11:15:39");
INSERT INTO `wyp_e_submissions` VALUES("146", "submission", "cda4950c-66a9-4ec6-bfb0-68a5056d3e2b", "436", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.186", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 13:59:53", "2023-02-20 13:59:53", "2023-02-20 13:59:53", "2023-02-20 13:59:53");
INSERT INTO `wyp_e_submissions` VALUES("147", "submission", "81ed7b12-9626-4467-b874-60fa7eea63b6", "439", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.235", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 14:07:37", "2023-02-20 14:07:37", "2023-02-20 14:07:37", "2023-02-20 14:07:37");
INSERT INTO `wyp_e_submissions` VALUES("148", "submission", "f4192332-2c20-4e17-a2e2-d1090b8fb227", "442", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.152.140.22", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 16:12:01", "2023-02-20 16:12:01", "2023-02-20 16:12:01", "2023-02-20 16:12:01");
INSERT INTO `wyp_e_submissions` VALUES("149", "submission", "a8e348f7-20bc-447d-9919-f449a9901082", "445", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.152.140.22", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-20 16:12:49", "2023-02-20 16:12:49", "2023-02-20 16:12:49", "2023-02-20 16:12:49");
INSERT INTO `wyp_e_submissions` VALUES("150", "submission", "0d96b37a-d062-4c65-9ccf-30d1e61032a1", "448", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.30", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-21 05:12:51", "2023-02-21 05:12:51", "2023-02-21 05:12:51", "2023-02-21 05:12:51");
INSERT INTO `wyp_e_submissions` VALUES("151", "submission", "3fe0653f-f6f4-4888-9ab3-cf6ae7b6d6eb", "451", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.30", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-21 05:14:16", "2023-02-21 05:14:16", "2023-02-21 05:14:16", "2023-02-21 05:14:16");
INSERT INTO `wyp_e_submissions` VALUES("152", "submission", "0919af09-64e3-4b12-8637-5973f900b493", "454", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.159", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-21 17:28:31", "2023-02-21 17:28:31", "2023-02-21 17:28:31", "2023-02-21 17:28:31");
INSERT INTO `wyp_e_submissions` VALUES("153", "submission", "760bc279-27a9-454c-9419-a3e2a94e9052", "457", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.217.59", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-22 07:32:29", "2023-02-22 07:32:29", "2023-02-22 07:32:29", "2023-02-22 07:32:29");
INSERT INTO `wyp_e_submissions` VALUES("154", "submission", "d1c9e818-3050-4395-86cb-87a79cfbdc6c", "460", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.47.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-23 14:02:02", "2023-02-23 14:02:02", "2023-02-23 14:02:02", "2023-02-23 14:02:02");
INSERT INTO `wyp_e_submissions` VALUES("155", "submission", "c50e8550-9387-425d-b556-1c1862f77a91", "463", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.103", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-23 19:45:35", "2023-02-23 19:45:35", "2023-02-23 19:45:35", "2023-02-23 19:45:35");
INSERT INTO `wyp_e_submissions` VALUES("156", "submission", "3aa1897a-1729-47f0-bce9-c52029ae86b9", "466", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.102", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-23 19:59:36", "2023-02-23 19:59:36", "2023-02-23 19:59:36", "2023-02-23 19:59:36");
INSERT INTO `wyp_e_submissions` VALUES("157", "submission", "3e8d645f-a784-48d3-a170-29203cfaaa40", "469", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.195.49", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-25 05:47:22", "2023-02-25 05:47:22", "2023-02-25 05:47:22", "2023-02-25 05:47:22");
INSERT INTO `wyp_e_submissions` VALUES("158", "submission", "440edd84-1e62-4a17-b23a-730bcb62855a", "472", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.195.49", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-25 05:48:03", "2023-02-25 05:48:03", "2023-02-25 05:48:03", "2023-02-25 05:48:03");
INSERT INTO `wyp_e_submissions` VALUES("159", "submission", "819f95ab-8a4d-4ce8-bb87-06969715c0dc", "475", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.224.133", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-25 15:43:25", "2023-02-25 15:43:25", "2023-02-25 15:43:25", "2023-02-25 15:43:25");
INSERT INTO `wyp_e_submissions` VALUES("160", "submission", "b00cfb35-ac1b-4203-990d-4219c6be6230", "478", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.195", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-25 15:54:22", "2023-02-25 15:54:22", "2023-02-25 15:54:22", "2023-02-25 15:54:22");
INSERT INTO `wyp_e_submissions` VALUES("161", "submission", "72bec6c1-fcd0-4742-b0c9-41ff928a559a", "481", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.34.70", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-26 00:36:15", "2023-02-26 00:36:15", "2023-02-26 00:36:15", "2023-02-26 00:36:15");
INSERT INTO `wyp_e_submissions` VALUES("162", "submission", "a0eecfa3-4ab1-44be-af43-61810c49cea3", "484", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.122.149", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-26 00:47:40", "2023-02-26 00:47:40", "2023-02-26 00:47:40", "2023-02-26 00:47:40");
INSERT INTO `wyp_e_submissions` VALUES("163", "submission", "b2248336-6dbb-4685-8813-45e8eb546b75", "487", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.231.32.120", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-26 19:48:52", "2023-02-26 19:48:52", "2023-02-26 19:48:52", "2023-02-26 19:48:52");
INSERT INTO `wyp_e_submissions` VALUES("164", "submission", "a522a7f3-5fea-4ab7-af5b-2e22e0ef99db", "490", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.197", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-26 20:01:11", "2023-02-26 20:01:11", "2023-02-26 20:01:11", "2023-02-26 20:01:11");
INSERT INTO `wyp_e_submissions` VALUES("165", "submission", "91a1ff42-5811-49a2-accd-8206ef9a886f", "493", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.130", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-27 19:52:36", "2023-02-27 19:52:36", "2023-02-27 19:52:36", "2023-02-27 19:52:36");
INSERT INTO `wyp_e_submissions` VALUES("166", "submission", "71f7ccba-0d8b-442c-a093-2564453e352d", "496", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.130", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-02-27 19:53:21", "2023-02-27 19:53:21", "2023-02-27 19:53:21", "2023-02-27 19:53:21");
INSERT INTO `wyp_e_submissions` VALUES("167", "submission", "e098686e-a58f-49fc-94dc-9bf029e3615c", "499", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.36.111", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-02 09:03:50", "2023-03-02 09:03:50", "2023-03-02 09:03:50", "2023-03-02 09:03:50");
INSERT INTO `wyp_e_submissions` VALUES("168", "submission", "c9c9a228-1bdd-4448-9c71-95b18ab98351", "502", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.8", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-05 18:42:05", "2023-03-05 18:42:05", "2023-03-05 18:42:05", "2023-03-05 18:42:05");
INSERT INTO `wyp_e_submissions` VALUES("169", "submission", "8e4a8024-20e2-4050-ae8f-ef484f04fb2b", "505", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.245", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-10 14:11:49", "2023-03-10 14:11:49", "2023-03-10 14:11:49", "2023-03-10 14:11:49");
INSERT INTO `wyp_e_submissions` VALUES("170", "submission", "7a164305-f5cd-43a3-9b40-11ddb6a6dcd3", "508", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.34.133", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-10 14:32:46", "2023-03-10 14:32:46", "2023-03-10 14:32:46", "2023-03-10 14:32:46");
INSERT INTO `wyp_e_submissions` VALUES("171", "submission", "ed8bd4b3-dd00-40e3-9573-cbee7956a05e", "511", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.148", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-10 20:16:15", "2023-03-10 20:16:15", "2023-03-10 20:16:15", "2023-03-10 20:16:15");
INSERT INTO `wyp_e_submissions` VALUES("172", "submission", "8ba7fc82-2c7b-4b00-93e9-52dc5cdeaf10", "514", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "38.153.123.197", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-13 17:03:32", "2023-03-13 17:03:32", "2023-03-13 17:03:32", "2023-03-13 17:03:32");
INSERT INTO `wyp_e_submissions` VALUES("173", "submission", "c949dafc-e2c1-49b6-bd78-2d784faf2dc6", "517", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.169", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-13 17:09:25", "2023-03-13 17:09:25", "2023-03-13 17:09:25", "2023-03-13 17:09:25");
INSERT INTO `wyp_e_submissions` VALUES("174", "submission", "e59b1cda-ee81-474d-bfb4-05b2cdfaa5da", "520", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.182.5", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-15 02:32:42", "2023-03-15 02:32:42", "2023-03-15 02:32:42", "2023-03-15 02:32:42");
INSERT INTO `wyp_e_submissions` VALUES("175", "submission", "d787f23f-aa56-403e-988b-67c2e718c8ec", "523", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.205.204", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-15 02:40:06", "2023-03-15 02:40:06", "2023-03-15 02:40:06", "2023-03-15 02:40:06");
INSERT INTO `wyp_e_submissions` VALUES("176", "submission", "004f4d78-39da-4ba3-b557-679638d4100e", "526", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.102", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-16 17:06:10", "2023-03-16 17:06:10", "2023-03-16 17:06:10", "2023-03-16 17:06:10");
INSERT INTO `wyp_e_submissions` VALUES("177", "submission", "1685f19d-ca1b-435e-a8fb-67be583cb229", "529", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.202.140", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 04:25:28", "2023-03-17 04:25:28", "2023-03-17 04:25:28", "2023-03-17 04:25:28");
INSERT INTO `wyp_e_submissions` VALUES("178", "submission", "d56c5f7d-5e08-484d-aa42-c142d3c96e4c", "532", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.34.171", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 04:29:12", "2023-03-17 04:29:12", "2023-03-17 04:29:12", "2023-03-17 04:29:12");
INSERT INTO `wyp_e_submissions` VALUES("179", "submission", "83b901e7-cc8c-485e-abee-93f0b4505c91", "535", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.223", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 04:31:04", "2023-03-17 04:31:04", "2023-03-17 04:31:04", "2023-03-17 04:31:04");
INSERT INTO `wyp_e_submissions` VALUES("180", "submission", "0378d201-48fe-4d59-8afd-2211b178a5a0", "538", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.205.159", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 04:33:12", "2023-03-17 04:33:12", "2023-03-17 04:33:12", "2023-03-17 04:33:12");
INSERT INTO `wyp_e_submissions` VALUES("181", "submission", "207afb43-5a42-4698-a054-8311210b5eb0", "541", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.205.159", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 04:35:28", "2023-03-17 04:35:28", "2023-03-17 04:35:28", "2023-03-17 04:35:28");
INSERT INTO `wyp_e_submissions` VALUES("182", "submission", "7186ec58-5bc1-4618-81fb-6f17498e9a18", "544", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.224", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 05:10:07", "2023-03-17 05:10:07", "2023-03-17 05:10:07", "2023-03-17 05:10:07");
INSERT INTO `wyp_e_submissions` VALUES("183", "submission", "ca4e5fe2-497b-4e03-a3d9-c79e0c9763df", "547", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.224", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 05:15:08", "2023-03-17 05:15:08", "2023-03-17 05:15:08", "2023-03-17 05:15:08");
INSERT INTO `wyp_e_submissions` VALUES("184", "submission", "185e1476-4b55-4019-a666-005af5003ca3", "550", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.202.76", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 23:01:56", "2023-03-17 23:01:56", "2023-03-17 23:01:56", "2023-03-17 23:01:56");
INSERT INTO `wyp_e_submissions` VALUES("185", "submission", "60c5ec2a-cb16-462c-8563-90a7fe981de1", "553", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.20.26", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-17 23:14:21", "2023-03-17 23:14:21", "2023-03-17 23:14:21", "2023-03-17 23:14:21");
INSERT INTO `wyp_e_submissions` VALUES("186", "submission", "c89568e7-c5fd-40ee-beaf-b85bac1f4c64", "556", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.182.212", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-18 15:12:40", "2023-03-18 15:12:40", "2023-03-18 15:12:40", "2023-03-18 15:12:40");
INSERT INTO `wyp_e_submissions` VALUES("187", "submission", "cfa2e997-f9c8-40c3-937d-ffe6c3c5a923", "559", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.150", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-18 15:25:51", "2023-03-18 15:25:51", "2023-03-18 15:25:51", "2023-03-18 15:25:51");
INSERT INTO `wyp_e_submissions` VALUES("188", "submission", "904695f6-10a8-4598-879d-fdfbc5c728b3", "562", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.82", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-19 17:50:31", "2023-03-19 17:50:31", "2023-03-19 17:50:31", "2023-03-19 17:50:31");
INSERT INTO `wyp_e_submissions` VALUES("189", "submission", "9ce24c68-f260-40ba-83e3-50f1c9c1457d", "565", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.110", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-19 22:14:34", "2023-03-19 22:14:34", "2023-03-19 22:14:34", "2023-03-19 22:14:34");
INSERT INTO `wyp_e_submissions` VALUES("190", "submission", "fe0eaa98-fac3-461d-8e8e-2f311abb86d5", "568", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.32", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-19 22:30:22", "2023-03-19 22:30:22", "2023-03-19 22:30:22", "2023-03-19 22:30:22");
INSERT INTO `wyp_e_submissions` VALUES("191", "submission", "9a31cf7f-56a7-4937-aefa-b0641d28531b", "571", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.111", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-20 07:58:39", "2023-03-20 07:58:39", "2023-03-20 07:58:39", "2023-03-20 07:58:39");
INSERT INTO `wyp_e_submissions` VALUES("192", "submission", "13e64199-ba54-4c88-bcc2-2cbae9be0ae5", "574", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.68", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-20 18:46:38", "2023-03-20 18:46:38", "2023-03-20 18:46:38", "2023-03-20 18:46:38");
INSERT INTO `wyp_e_submissions` VALUES("193", "submission", "671b8ff1-b14e-442d-921e-4441650a12bf", "577", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.68", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-20 18:50:13", "2023-03-20 18:50:13", "2023-03-20 18:50:13", "2023-03-20 18:50:13");
INSERT INTO `wyp_e_submissions` VALUES("194", "submission", "4c6f0f66-68d6-4f9d-84c8-88bbb08e8122", "580", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "37.46.113.172", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-21 06:07:40", "2023-03-21 06:07:40", "2023-03-21 06:07:40", "2023-03-21 06:07:40");
INSERT INTO `wyp_e_submissions` VALUES("195", "submission", "03cb39dc-8a9e-49cd-8568-f6d0c4c4b3f7", "583", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "149.34.242.231", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-23 16:40:52", "2023-03-23 16:40:52", "2023-03-23 16:40:52", "2023-03-23 16:40:52");
INSERT INTO `wyp_e_submissions` VALUES("196", "submission", "6d947701-c152-44ee-be7a-a13c4a22f653", "586", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.168.114", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4400.8 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-24 22:20:01", "2023-03-24 22:20:01", "2023-03-24 22:20:01", "2023-03-24 22:20:01");
INSERT INTO `wyp_e_submissions` VALUES("197", "submission", "f9d679cb-cac3-4c6a-89a8-1617b3b3b456", "589", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "170.83.177.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-29 00:13:16", "2023-03-29 00:13:16", "2023-03-29 00:13:16", "2023-03-29 00:13:16");
INSERT INTO `wyp_e_submissions` VALUES("198", "submission", "872d08da-ddef-4c6b-aef7-5bc38e55e70d", "592", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.53.21", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-03-30 00:07:36", "2023-03-30 00:07:36", "2023-03-30 00:07:36", "2023-03-30 00:07:36");
INSERT INTO `wyp_e_submissions` VALUES("199", "submission", "416959af-ebd0-4036-a170-16b4c1ccd57e", "595", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.107", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-01 06:59:07", "2023-04-01 06:59:07", "2023-04-01 06:59:07", "2023-04-01 06:59:07");
INSERT INTO `wyp_e_submissions` VALUES("200", "submission", "38b2b709-5ccb-4d4b-ac9a-c661c3d0a50a", "598", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.107", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-01 07:02:52", "2023-04-01 07:02:52", "2023-04-01 07:02:52", "2023-04-01 07:02:52");
INSERT INTO `wyp_e_submissions` VALUES("201", "submission", "41286047-5d83-44fb-9909-f832f90ebffa", "601", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.119", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-04 10:41:16", "2023-04-04 10:41:16", "2023-04-04 10:41:16", "2023-04-04 10:41:16");
INSERT INTO `wyp_e_submissions` VALUES("202", "submission", "eea73265-e1bb-4198-af80-fdc2c9158b37", "604", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-04 11:06:48", "2023-04-04 11:06:48", "2023-04-04 11:06:48", "2023-04-04 11:06:48");
INSERT INTO `wyp_e_submissions` VALUES("203", "submission", "7184176c-4584-4a38-ab9f-4179d131430e", "607", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "170.83.177.119", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-05 08:14:05", "2023-04-05 08:14:05", "2023-04-05 08:14:05", "2023-04-05 08:14:05");
INSERT INTO `wyp_e_submissions` VALUES("204", "submission", "90e0f644-7585-41fa-8d0b-c01dba49b29c", "610", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.125.245.161", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-05 08:19:31", "2023-04-05 08:19:31", "2023-04-05 08:19:31", "2023-04-05 08:19:31");
INSERT INTO `wyp_e_submissions` VALUES("205", "submission", "fc02f2ca-b2a6-42d4-aad1-216a185e2950", "613", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.150.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-05 09:16:50", "2023-04-05 09:16:50", "2023-04-05 09:16:50", "2023-04-05 09:16:50");
INSERT INTO `wyp_e_submissions` VALUES("206", "submission", "5f85bcba-3755-42e3-ae8c-216102be5e9b", "616", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.150.103", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-05 09:20:11", "2023-04-05 09:20:11", "2023-04-05 09:20:11", "2023-04-05 09:20:11");
INSERT INTO `wyp_e_submissions` VALUES("207", "submission", "b7111ede-3cb9-4a91-a477-394ff7f438fc", "619", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.72", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-06 09:26:09", "2023-04-06 09:26:09", "2023-04-06 09:26:09", "2023-04-06 09:26:09");
INSERT INTO `wyp_e_submissions` VALUES("208", "submission", "6cf79d43-5665-44f5-b28d-8a2f320d4c2a", "622", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.99.236", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-06 13:01:25", "2023-04-06 13:01:25", "2023-04-06 13:01:25", "2023-04-06 13:01:25");
INSERT INTO `wyp_e_submissions` VALUES("209", "submission", "8a06b15a-e126-4a50-ac3f-3626f8de4a25", "625", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.10.227", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-06 13:07:45", "2023-04-06 13:07:45", "2023-04-06 13:07:45", "2023-04-06 13:07:45");
INSERT INTO `wyp_e_submissions` VALUES("210", "submission", "160d4674-dc0f-4609-b95c-fb40119d3b11", "628", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.154.89", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-09 09:29:10", "2023-04-09 09:29:10", "2023-04-09 09:29:10", "2023-04-09 09:29:10");
INSERT INTO `wyp_e_submissions` VALUES("211", "submission", "cd377077-6f72-4fe1-bc9a-399f3bd374a9", "631", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.154.89", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-09 09:31:14", "2023-04-09 09:31:14", "2023-04-09 09:31:14", "2023-04-09 09:31:14");
INSERT INTO `wyp_e_submissions` VALUES("212", "submission", "8b423cd3-ca99-41a4-be8e-1c82f9f50319", "634", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.50", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-10 21:28:23", "2023-04-10 21:28:23", "2023-04-10 21:28:23", "2023-04-10 21:28:23");
INSERT INTO `wyp_e_submissions` VALUES("213", "submission", "19f70f52-5241-4684-8810-0b5f2d4e3843", "637", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "181.215.16.113", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-10 21:34:03", "2023-04-10 21:34:03", "2023-04-10 21:34:03", "2023-04-10 21:34:03");
INSERT INTO `wyp_e_submissions` VALUES("214", "submission", "5bfe29f5-1d5a-493c-be9a-ad245d01a40e", "640", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.35", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-12 06:37:53", "2023-04-12 06:37:53", "2023-04-12 06:37:53", "2023-04-12 06:37:53");
INSERT INTO `wyp_e_submissions` VALUES("215", "submission", "246051a0-e512-4dad-8693-f6ab58958f4d", "643", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.35", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-12 06:42:35", "2023-04-12 06:42:35", "2023-04-12 06:42:35", "2023-04-12 06:42:35");
INSERT INTO `wyp_e_submissions` VALUES("216", "submission", "03c4d3ef-e721-4bb8-8023-de64a1d594f7", "646", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.9", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-12 17:07:23", "2023-04-12 17:07:23", "2023-04-12 17:07:23", "2023-04-12 17:07:23");
INSERT INTO `wyp_e_submissions` VALUES("217", "submission", "822c2a11-a5b1-4169-9be3-8bcc20520ef5", "649", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.229", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-13 16:59:07", "2023-04-13 16:59:07", "2023-04-13 16:59:07", "2023-04-13 16:59:07");
INSERT INTO `wyp_e_submissions` VALUES("218", "submission", "114bdc94-83be-4caa-8d0b-b144f2017692", "652", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.229", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-13 17:04:02", "2023-04-13 17:04:02", "2023-04-13 17:04:02", "2023-04-13 17:04:02");
INSERT INTO `wyp_e_submissions` VALUES("219", "submission", "6a0dd4eb-21e2-4dad-8eaf-ecf95dd7780c", "655", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.36.211", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-13 20:34:35", "2023-04-13 20:34:35", "2023-04-13 20:34:35", "2023-04-13 20:34:35");
INSERT INTO `wyp_e_submissions` VALUES("220", "submission", "a8386cc4-f360-4aad-b9a8-d2d4d457d71c", "658", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.141", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-15 13:55:39", "2023-04-15 13:55:39", "2023-04-15 13:55:39", "2023-04-15 13:55:39");
INSERT INTO `wyp_e_submissions` VALUES("221", "submission", "c80c844e-8ffb-4ab9-ba04-0325bc651fcd", "661", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.141", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-15 14:00:51", "2023-04-15 14:00:51", "2023-04-15 14:00:51", "2023-04-15 14:00:51");
INSERT INTO `wyp_e_submissions` VALUES("222", "submission", "6eaf256d-a154-423a-9a29-c2b7ef730d34", "664", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.126", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-15 21:14:46", "2023-04-15 21:14:46", "2023-04-15 21:14:46", "2023-04-15 21:14:46");
INSERT INTO `wyp_e_submissions` VALUES("223", "submission", "5311cd03-e9f4-40c0-a1ab-435c6097bdf2", "667", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.141", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-15 21:23:30", "2023-04-15 21:23:30", "2023-04-15 21:23:30", "2023-04-15 21:23:30");
INSERT INTO `wyp_e_submissions` VALUES("224", "submission", "0507897d-9ab8-4eb5-89db-ca1bbb4f8a18", "670", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "168.90.196.180", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-19 00:25:46", "2023-04-19 00:25:46", "2023-04-19 00:25:46", "2023-04-19 00:25:46");
INSERT INTO `wyp_e_submissions` VALUES("225", "submission", "949e39d0-c184-40eb-ae8e-d2c206dcded4", "673", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "168.90.196.180", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-19 00:30:10", "2023-04-19 00:30:10", "2023-04-19 00:30:10", "2023-04-19 00:30:10");
INSERT INTO `wyp_e_submissions` VALUES("226", "submission", "be6237db-1cb7-46f0-8303-ad6453bad968", "676", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.43", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-19 02:05:30", "2023-04-19 02:05:30", "2023-04-19 02:05:30", "2023-04-19 02:05:30");
INSERT INTO `wyp_e_submissions` VALUES("227", "submission", "ce334537-507c-4796-8a9f-17f4e5503928", "679", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.141", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-19 02:13:11", "2023-04-19 02:13:11", "2023-04-19 02:13:11", "2023-04-19 02:13:11");
INSERT INTO `wyp_e_submissions` VALUES("228", "submission", "3ebd0db6-6028-4fad-ae18-61c80692b851", "682", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.53.25", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-20 13:57:14", "2023-04-20 13:57:14", "2023-04-20 13:57:14", "2023-04-20 13:57:14");
INSERT INTO `wyp_e_submissions` VALUES("229", "submission", "5cdddd62-7278-43f3-9297-fe64d39f2ab3", "685", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "194.32.122.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-20 15:55:31", "2023-04-20 15:55:31", "2023-04-20 15:55:31", "2023-04-20 15:55:31");
INSERT INTO `wyp_e_submissions` VALUES("230", "submission", "401c051c-5c1a-47f2-a07e-b6ed1d20a365", "688", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.55.118", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-21 14:29:00", "2023-04-21 14:29:00", "2023-04-21 14:29:00", "2023-04-21 14:29:00");
INSERT INTO `wyp_e_submissions` VALUES("231", "submission", "e87d5f59-444c-4bd4-a667-c9f848e0e2eb", "691", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.81.229.215", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-21 14:36:10", "2023-04-21 14:36:10", "2023-04-21 14:36:10", "2023-04-21 14:36:10");
INSERT INTO `wyp_e_submissions` VALUES("232", "submission", "f9a06877-5d22-41bc-8264-c3a3dc2df732", "694", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.102.154.101", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-22 15:27:06", "2023-04-22 15:27:06", "2023-04-22 15:27:06", "2023-04-22 15:27:06");
INSERT INTO `wyp_e_submissions` VALUES("233", "submission", "d9a50ee1-099c-4d87-be4a-4392f07c52f8", "697", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.188", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-22 15:33:03", "2023-04-22 15:33:03", "2023-04-22 15:33:03", "2023-04-22 15:33:03");
INSERT INTO `wyp_e_submissions` VALUES("234", "submission", "3db350ac-ebd8-4cd8-9dde-0f1f765e52d9", "700", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.147.19", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-23 17:54:56", "2023-04-23 17:54:56", "2023-04-23 17:54:56", "2023-04-23 17:54:56");
INSERT INTO `wyp_e_submissions` VALUES("235", "submission", "0ac74c80-afd6-48b1-a195-65360bfa8e9b", "703", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.165", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-23 18:01:58", "2023-04-23 18:01:58", "2023-04-23 18:01:58", "2023-04-23 18:01:58");
INSERT INTO `wyp_e_submissions` VALUES("236", "submission", "d47cb7d0-3c19-448e-b4bf-6314799a2624", "706", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.20.233", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-25 07:40:01", "2023-04-25 07:40:01", "2023-04-25 07:40:01", "2023-04-25 07:40:01");
INSERT INTO `wyp_e_submissions` VALUES("237", "submission", "95022ae0-d473-4c00-a9b2-1503dc99975a", "709", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.112.0.11", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-25 07:46:59", "2023-04-25 07:46:59", "2023-04-25 07:46:59", "2023-04-25 07:46:59");
INSERT INTO `wyp_e_submissions` VALUES("238", "submission", "3edc1959-c460-411b-9f62-4f3e3a84b012", "712", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "188.126.89.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-25 18:48:59", "2023-04-25 18:48:59", "2023-04-25 18:48:59", "2023-04-25 18:48:59");
INSERT INTO `wyp_e_submissions` VALUES("239", "submission", "1e6972fb-f5c3-4973-a7d0-2352d1bd74bb", "715", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.35", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-26 01:42:32", "2023-04-26 01:42:32", "2023-04-26 01:42:32", "2023-04-26 01:42:32");
INSERT INTO `wyp_e_submissions` VALUES("240", "submission", "6c455afa-4da3-4e67-aa44-87e3a414f454", "718", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.234", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-26 01:56:18", "2023-04-26 01:56:18", "2023-04-26 01:56:18", "2023-04-26 01:56:18");
INSERT INTO `wyp_e_submissions` VALUES("241", "submission", "b35fc3f6-68db-4fcd-af21-a88d8ecf9375", "721", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.35", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-26 05:43:21", "2023-04-26 05:43:21", "2023-04-26 05:43:21", "2023-04-26 05:43:21");
INSERT INTO `wyp_e_submissions` VALUES("242", "submission", "a3626d39-db6f-4904-8da7-70fa982389a4", "724", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "36.255.190.99", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-26 05:49:54", "2023-04-26 05:49:54", "2023-04-26 05:49:54", "2023-04-26 05:49:54");
INSERT INTO `wyp_e_submissions` VALUES("243", "submission", "bde1dc3a-1794-4b04-b67a-3119a225517b", "727", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.49", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-30 05:56:10", "2023-04-30 05:56:10", "2023-04-30 05:56:10", "2023-04-30 05:56:10");
INSERT INTO `wyp_e_submissions` VALUES("244", "submission", "c82dc7fa-f016-4e3a-92b6-f6debbbc1df7", "730", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.145.71.140", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-04-30 16:16:11", "2023-04-30 16:16:11", "2023-04-30 16:16:11", "2023-04-30 16:16:11");
INSERT INTO `wyp_e_submissions` VALUES("245", "submission", "0c73c2ae-27e9-4c78-b276-e4d46f29f985", "733", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.198.161", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-01 12:41:10", "2023-05-01 12:41:10", "2023-05-01 12:41:10", "2023-05-01 12:41:10");
INSERT INTO `wyp_e_submissions` VALUES("246", "submission", "999d131f-fb1d-4858-9ca0-a047a48674b3", "736", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-01 12:49:11", "2023-05-01 12:49:11", "2023-05-01 12:49:11", "2023-05-01 12:49:11");
INSERT INTO `wyp_e_submissions` VALUES("247", "submission", "bb75a7c6-754a-4117-824f-1ac5edfc2a17", "739", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.134", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-02 21:34:16", "2023-05-02 21:34:16", "2023-05-02 21:34:16", "2023-05-02 21:34:16");
INSERT INTO `wyp_e_submissions` VALUES("248", "submission", "8830f1d2-6672-4e56-8d95-d2bdcc6193f0", "742", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.247.217", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-02 21:42:06", "2023-05-02 21:42:06", "2023-05-02 21:42:06", "2023-05-02 21:42:06");
INSERT INTO `wyp_e_submissions` VALUES("249", "submission", "fc5d558d-62cb-4fd2-8a73-c137fc945dfa", "745", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.122", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-04 05:56:54", "2023-05-04 05:56:54", "2023-05-04 05:56:54", "2023-05-04 05:56:54");
INSERT INTO `wyp_e_submissions` VALUES("250", "submission", "4cbff732-0510-48b8-a54a-555df8a7d045", "748", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.20.74", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-04 06:08:57", "2023-05-04 06:08:57", "2023-05-04 06:08:57", "2023-05-04 06:08:57");
INSERT INTO `wyp_e_submissions` VALUES("251", "submission", "a8ecaf73-7218-47c1-93ec-662b6f66b45a", "751", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.217.215", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-05 05:25:29", "2023-05-05 05:25:29", "2023-05-05 05:25:29", "2023-05-05 05:25:29");
INSERT INTO `wyp_e_submissions` VALUES("252", "submission", "0d144ff2-af55-4ec7-a5a3-8bb48f739e59", "754", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "36.255.190.99", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-08 15:20:13", "2023-05-08 15:20:13", "2023-05-08 15:20:13", "2023-05-08 15:20:13");
INSERT INTO `wyp_e_submissions` VALUES("253", "submission", "0262250f-6aec-4a57-89f7-5db6abcb10f1", "757", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "36.255.188.207", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-08 15:29:52", "2023-05-08 15:29:52", "2023-05-08 15:29:52", "2023-05-08 15:29:52");
INSERT INTO `wyp_e_submissions` VALUES("254", "submission", "bd3ea58d-3446-4868-88a8-8d97c4c4c06f", "760", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.63", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-08 18:41:48", "2023-05-08 18:41:48", "2023-05-08 18:41:48", "2023-05-08 18:41:48");
INSERT INTO `wyp_e_submissions` VALUES("255", "submission", "96e2f101-54e5-4240-b92a-4ada8a4bb477", "763", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.126", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-08 18:52:13", "2023-05-08 18:52:13", "2023-05-08 18:52:13", "2023-05-08 18:52:13");
INSERT INTO `wyp_e_submissions` VALUES("256", "submission", "e97afde2-50b7-4461-8361-bc41718620eb", "766", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.90", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-09 22:41:53", "2023-05-09 22:41:53", "2023-05-09 22:41:53", "2023-05-09 22:41:53");
INSERT INTO `wyp_e_submissions` VALUES("257", "submission", "8087606a-7afe-47c2-a5ad-080c34f4a5fa", "769", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.43.20", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-10 23:42:12", "2023-05-10 23:42:12", "2023-05-10 23:42:12", "2023-05-10 23:42:12");
INSERT INTO `wyp_e_submissions` VALUES("258", "submission", "f2b28624-4f6b-471c-8b8c-4d0de1355a90", "772", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.150", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-17 06:48:49", "2023-05-17 06:48:49", "2023-05-17 06:48:49", "2023-05-17 06:48:49");
INSERT INTO `wyp_e_submissions` VALUES("259", "submission", "f61c78c3-0864-4bd4-bc73-93df004ddb03", "775", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.247.233", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-17 06:55:39", "2023-05-17 06:55:39", "2023-05-17 06:55:39", "2023-05-17 06:55:39");
INSERT INTO `wyp_e_submissions` VALUES("260", "submission", "96c0e77e-311d-4056-88f0-ecb633fe7f2f", "778", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.55.166", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-18 03:50:19", "2023-05-18 03:50:19", "2023-05-18 03:50:19", "2023-05-18 03:50:19");
INSERT INTO `wyp_e_submissions` VALUES("261", "submission", "84fdd304-571b-4d6c-be4f-29c85d66ee85", "781", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-18 04:05:10", "2023-05-18 04:05:10", "2023-05-18 04:05:10", "2023-05-18 04:05:10");
INSERT INTO `wyp_e_submissions` VALUES("262", "submission", "8451627c-d194-4f17-bddd-77ebdc0696de", "784", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.217.166", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-18 04:12:24", "2023-05-18 04:12:24", "2023-05-18 04:12:24", "2023-05-18 04:12:24");
INSERT INTO `wyp_e_submissions` VALUES("263", "submission", "83bee66f-c5fd-4f64-9add-fa95d89548bb", "787", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.112", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-18 20:51:46", "2023-05-18 20:51:46", "2023-05-18 20:51:46", "2023-05-18 20:51:46");
INSERT INTO `wyp_e_submissions` VALUES("264", "submission", "6cf72620-acea-44c8-821d-228e9748276b", "790", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.163.251", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-19 08:59:02", "2023-05-19 08:59:02", "2023-05-19 08:59:02", "2023-05-19 08:59:02");
INSERT INTO `wyp_e_submissions` VALUES("265", "submission", "b45c2951-6de8-4377-bf44-4d99c0c6da77", "793", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.199.164", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-19 09:06:22", "2023-05-19 09:06:22", "2023-05-19 09:06:22", "2023-05-19 09:06:22");
INSERT INTO `wyp_e_submissions` VALUES("266", "submission", "60b8daba-eb8a-4990-8f3c-099d92fcd63d", "796", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.122.170.51", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-22 08:04:54", "2023-05-22 08:04:54", "2023-05-22 08:04:54", "2023-05-22 08:04:54");
INSERT INTO `wyp_e_submissions` VALUES("267", "submission", "55cb89a0-7242-41e5-ab74-9a3faa10fc11", "799", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.108", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-22 08:11:18", "2023-05-22 08:11:18", "2023-05-22 08:11:18", "2023-05-22 08:11:18");
INSERT INTO `wyp_e_submissions` VALUES("268", "submission", "4368d3ba-e396-4555-9c31-7536831570e1", "802", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.108", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-22 20:52:31", "2023-05-22 20:52:31", "2023-05-22 20:52:31", "2023-05-22 20:52:31");
INSERT INTO `wyp_e_submissions` VALUES("269", "submission", "2614b6c8-d4f1-4c15-970e-4ad6852664be", "805", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.252", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-22 21:01:46", "2023-05-22 21:01:46", "2023-05-22 21:01:46", "2023-05-22 21:01:46");
INSERT INTO `wyp_e_submissions` VALUES("270", "submission", "24944e7d-b6f2-4ae9-9531-5627146b3261", "808", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.4.123", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-23 13:34:19", "2023-05-23 13:34:19", "2023-05-23 13:34:19", "2023-05-23 13:34:19");
INSERT INTO `wyp_e_submissions` VALUES("271", "submission", "99dc586b-f5ed-4202-9402-4b9fdb6d98ed", "811", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.150", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-23 13:46:22", "2023-05-23 13:46:22", "2023-05-23 13:46:22", "2023-05-23 13:46:22");
INSERT INTO `wyp_e_submissions` VALUES("272", "submission", "1c215016-47dc-47fb-b70c-595c8a4d31ea", "814", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.49.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-29 02:23:51", "2023-05-29 02:23:51", "2023-05-29 02:23:51", "2023-05-29 02:23:51");
INSERT INTO `wyp_e_submissions` VALUES("273", "submission", "113a791d-5a36-42d2-b285-74a33c37d399", "817", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.163", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-29 05:30:18", "2023-05-29 05:30:18", "2023-05-29 05:30:18", "2023-05-29 05:30:18");
INSERT INTO `wyp_e_submissions` VALUES("274", "submission", "d40ec253-7fbc-49f6-996e-3917f274ae3e", "820", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.169", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-29 05:43:59", "2023-05-29 05:43:59", "2023-05-29 05:43:59", "2023-05-29 05:43:59");
INSERT INTO `wyp_e_submissions` VALUES("275", "submission", "c8ac4ede-dce9-4f26-ad3c-965cf9349a5f", "823", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.152.182.149", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-05-30 22:15:41", "2023-05-30 22:15:41", "2023-05-30 22:15:41", "2023-05-30 22:15:41");
INSERT INTO `wyp_e_submissions` VALUES("276", "submission", "320cf455-e50d-40db-a027-90bd06069cab", "826", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.15", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-02 08:36:50", "2023-06-02 08:36:50", "2023-06-02 08:36:50", "2023-06-02 08:36:50");
INSERT INTO `wyp_e_submissions` VALUES("277", "submission", "dca9695b-1399-4ef1-b83e-4e1fe72c32c7", "829", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.125.245.154", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-02 08:52:18", "2023-06-02 08:52:18", "2023-06-02 08:52:18", "2023-06-02 08:52:18");
INSERT INTO `wyp_e_submissions` VALUES("278", "submission", "c4224dc5-f0cb-4836-b8ec-6e3202e30655", "832", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "87.249.132.23", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-04 17:50:25", "2023-06-04 17:50:25", "2023-06-04 17:50:25", "2023-06-04 17:50:25");
INSERT INTO `wyp_e_submissions` VALUES("279", "submission", "c5dd9903-4c41-4ffb-a705-bc941d60b321", "835", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.254", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-04 22:47:24", "2023-06-04 22:47:24", "2023-06-04 22:47:24", "2023-06-04 22:47:24");
INSERT INTO `wyp_e_submissions` VALUES("280", "submission", "d4ba27f0-69e8-472e-bd8c-24305fc8d478", "838", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.204", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-04 22:57:23", "2023-06-04 22:57:23", "2023-06-04 22:57:23", "2023-06-04 22:57:23");
INSERT INTO `wyp_e_submissions` VALUES("281", "submission", "e869b503-5524-4624-8580-9c4674789ae8", "841", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.252.140", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-05 00:10:13", "2023-06-05 00:10:13", "2023-06-05 00:10:13", "2023-06-05 00:10:13");
INSERT INTO `wyp_e_submissions` VALUES("282", "submission", "8f54182c-e971-493c-9192-53a0e5e13dae", "844", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.153", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-05 00:24:14", "2023-06-05 00:24:14", "2023-06-05 00:24:14", "2023-06-05 00:24:14");
INSERT INTO `wyp_e_submissions` VALUES("283", "submission", "4cbd2f54-ec48-4929-b086-ff4bd255108c", "847", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.217.156", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-05 12:43:22", "2023-06-05 12:43:22", "2023-06-05 12:43:22", "2023-06-05 12:43:22");
INSERT INTO `wyp_e_submissions` VALUES("284", "submission", "c9dbe4cd-e65d-4f64-bd02-45dd035260d7", "850", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.252.158", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-05 12:57:16", "2023-06-05 12:57:16", "2023-06-05 12:57:16", "2023-06-05 12:57:16");
INSERT INTO `wyp_e_submissions` VALUES("285", "submission", "9ea42438-b234-471b-b781-de81360f5b51", "853", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "154.13.101.105", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-06 11:57:24", "2023-06-06 11:57:24", "2023-06-06 11:57:24", "2023-06-06 11:57:24");
INSERT INTO `wyp_e_submissions` VALUES("286", "submission", "69e1f19d-ecfc-4a8f-bb7c-fa7d3702ac71", "856", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.195.105", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-08 19:19:18", "2023-06-08 19:19:18", "2023-06-08 19:19:18", "2023-06-08 19:19:18");
INSERT INTO `wyp_e_submissions` VALUES("287", "submission", "df014d19-e8ff-499f-a2a9-3f81378cb630", "859", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.4.73", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-08 22:53:23", "2023-06-08 22:53:23", "2023-06-08 22:53:23", "2023-06-08 22:53:23");
INSERT INTO `wyp_e_submissions` VALUES("288", "submission", "9ec53558-6fbe-4076-a4e1-fcd4213c694e", "862", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.4.160", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-09 11:38:28", "2023-06-09 11:38:28", "2023-06-09 11:38:28", "2023-06-09 11:38:28");
INSERT INTO `wyp_e_submissions` VALUES("289", "submission", "34dfae8a-5afd-464f-afc6-9bd83db38d2e", "865", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.10.58", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-09 11:48:23", "2023-06-09 11:48:23", "2023-06-09 11:48:23", "2023-06-09 11:48:23");
INSERT INTO `wyp_e_submissions` VALUES("290", "submission", "0f7a04a8-bb18-4e79-9f48-185294b25b8a", "868", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.236", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-10 15:54:16", "2023-06-10 15:54:16", "2023-06-10 15:54:16", "2023-06-10 15:54:16");
INSERT INTO `wyp_e_submissions` VALUES("291", "submission", "143cef1d-d7cd-48e4-ae85-3d55c0b707b4", "871", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.177", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-11 03:27:18", "2023-06-11 03:27:18", "2023-06-11 03:27:18", "2023-06-11 03:27:18");
INSERT INTO `wyp_e_submissions` VALUES("292", "submission", "c3fbc311-153c-4ab7-9df5-75adf5eabc11", "874", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.163.202", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-11 09:44:37", "2023-06-11 09:44:37", "2023-06-11 09:44:37", "2023-06-11 09:44:37");
INSERT INTO `wyp_e_submissions` VALUES("293", "submission", "c85ba9ee-db51-4ce1-8d83-54709d0eb0d1", "877", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.93", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-11 10:23:10", "2023-06-11 10:23:10", "2023-06-11 10:23:10", "2023-06-11 10:23:10");
INSERT INTO `wyp_e_submissions` VALUES("294", "submission", "fd8ab144-fc55-4f54-a720-68119e58ceba", "880", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "193.56.113.57", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-12 06:41:38", "2023-06-12 06:41:38", "2023-06-12 06:41:38", "2023-06-12 06:41:38");
INSERT INTO `wyp_e_submissions` VALUES("295", "submission", "69a5f5b1-cc11-4ff8-8b44-d7d9547aadaf", "883", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.51.132", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-13 02:41:47", "2023-06-13 02:41:47", "2023-06-13 02:41:47", "2023-06-13 02:41:47");
INSERT INTO `wyp_e_submissions` VALUES("296", "submission", "404cb1fe-d91a-47be-8101-36a2d127a00d", "886", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.159.129", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-13 02:49:47", "2023-06-13 02:49:47", "2023-06-13 02:49:47", "2023-06-13 02:49:47");
INSERT INTO `wyp_e_submissions` VALUES("297", "submission", "cff788af-beb8-44ef-9dd1-37f8a03f37b9", "889", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.195", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-13 14:10:46", "2023-06-13 14:10:46", "2023-06-13 14:10:46", "2023-06-13 14:10:46");
INSERT INTO `wyp_e_submissions` VALUES("298", "submission", "c8db8323-c874-4d7b-b766-3ddecbdd5b82", "892", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.200.71", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-13 20:29:23", "2023-06-13 20:29:23", "2023-06-13 20:29:23", "2023-06-13 20:29:23");
INSERT INTO `wyp_e_submissions` VALUES("299", "submission", "efd9e932-6de9-4bf8-a54d-a472927c2633", "895", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.200.187", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-13 20:37:02", "2023-06-13 20:37:02", "2023-06-13 20:37:02", "2023-06-13 20:37:02");
INSERT INTO `wyp_e_submissions` VALUES("300", "submission", "54189a11-f483-48dd-a254-6323accc8dc6", "898", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.122.230", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 05:49:38", "2023-06-14 05:49:38", "2023-06-14 05:49:38", "2023-06-14 05:49:38");
INSERT INTO `wyp_e_submissions` VALUES("301", "submission", "06f35595-4428-447b-8746-00121e0f9b61", "901", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.120.51.18", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 05:56:06", "2023-06-14 05:56:06", "2023-06-14 05:56:06", "2023-06-14 05:56:06");
INSERT INTO `wyp_e_submissions` VALUES("302", "submission", "e171bcae-8947-4479-8547-d1e4cc46be21", "904", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.108", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.106", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 07:17:55", "2023-06-14 07:17:55", "2023-06-14 07:17:55", "2023-06-14 07:17:55");
INSERT INTO `wyp_e_submissions` VALUES("303", "submission", "6421dd28-7763-4347-9373-5bacef6c410a", "907", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.123.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 11:16:23", "2023-06-14 11:16:23", "2023-06-14 11:16:23", "2023-06-14 11:16:23");
INSERT INTO `wyp_e_submissions` VALUES("304", "submission", "df178578-abd4-45b0-9247-1dd5a4a63531", "910", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.181.205", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 13:39:44", "2023-06-14 13:39:44", "2023-06-14 13:39:44", "2023-06-14 13:39:44");
INSERT INTO `wyp_e_submissions` VALUES("305", "submission", "f5ceae3e-2e69-4103-85c2-f1bd7dc3076c", "913", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.183", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 13:55:18", "2023-06-14 13:55:18", "2023-06-14 13:55:18", "2023-06-14 13:55:18");
INSERT INTO `wyp_e_submissions` VALUES("306", "submission", "78ccfc1e-d194-47ed-a4fc-9b6586e32162", "916", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.54.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-14 21:07:05", "2023-06-14 21:07:05", "2023-06-14 21:07:05", "2023-06-14 21:07:05");
INSERT INTO `wyp_e_submissions` VALUES("307", "submission", "fdc08a18-f607-4ecb-ac3c-697fac668c6b", "919", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.93", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-15 14:34:43", "2023-06-15 14:34:43", "2023-06-15 14:34:43", "2023-06-15 14:34:43");
INSERT INTO `wyp_e_submissions` VALUES("308", "submission", "a74477b7-c48d-4e07-95b9-f7253a5e404c", "922", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.55.20", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-15 14:41:17", "2023-06-15 14:41:17", "2023-06-15 14:41:17", "2023-06-15 14:41:17");
INSERT INTO `wyp_e_submissions` VALUES("309", "submission", "b520b2c6-9b09-478b-a4a9-a4d3d89d75bd", "925", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "169.150.226.200", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-15 21:53:44", "2023-06-15 21:53:44", "2023-06-15 21:53:44", "2023-06-15 21:53:44");
INSERT INTO `wyp_e_submissions` VALUES("310", "submission", "dcd59a37-b20a-4a28-b72a-17065c45b5d7", "928", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "193.56.113.54", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-17 11:26:12", "2023-06-17 11:26:12", "2023-06-17 11:26:12", "2023-06-17 11:26:12");
INSERT INTO `wyp_e_submissions` VALUES("311", "submission", "09f027a7-e576-4492-a151-040371cbbd8c", "931", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.114.239", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-20 13:52:10", "2023-06-20 13:52:10", "2023-06-20 13:52:10", "2023-06-20 13:52:10");
INSERT INTO `wyp_e_submissions` VALUES("312", "submission", "43ba524e-81da-4665-8a61-f74b3fc54050", "934", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "149.62.41.78", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-20 14:25:07", "2023-06-20 14:25:07", "2023-06-20 14:25:07", "2023-06-20 14:25:07");
INSERT INTO `wyp_e_submissions` VALUES("313", "submission", "47b0278e-2bdd-48a6-9418-2a448511473c", "937", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.120.51.215", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-20 17:38:57", "2023-06-20 17:38:57", "2023-06-20 17:38:57", "2023-06-20 17:38:57");
INSERT INTO `wyp_e_submissions` VALUES("314", "submission", "3557f1ff-c358-4d01-adf3-fb354d47dced", "940", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.10.111", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-20 17:46:51", "2023-06-20 17:46:51", "2023-06-20 17:46:51", "2023-06-20 17:46:51");
INSERT INTO `wyp_e_submissions` VALUES("315", "submission", "ecadf0a8-d893-481a-97b3-c59cb450ff5e", "943", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.69", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-20 21:06:23", "2023-06-20 21:06:23", "2023-06-20 21:06:23", "2023-06-20 21:06:23");
INSERT INTO `wyp_e_submissions` VALUES("316", "submission", "ba8bbf7c-c624-4b0f-95e6-95e9d1f6d461", "0", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.130.177.90", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-22 06:33:10", "2023-06-22 06:33:10", "2023-06-22 06:33:10", "2023-06-22 06:33:10");
INSERT INTO `wyp_e_submissions` VALUES("317", "submission", "a53b0a88-515e-4f8c-9853-dd2f39ff3801", "947", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "188.95.54.21", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-22 10:39:33", "2023-06-22 10:39:33", "2023-06-22 10:39:33", "2023-06-22 10:39:33");
INSERT INTO `wyp_e_submissions` VALUES("318", "submission", "6f057f3a-df6c-4c16-bebf-73411174730a", "950", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "188.234.43.231", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-23 05:36:28", "2023-06-23 05:36:28", "2023-06-23 05:36:28", "2023-06-23 05:36:28");
INSERT INTO `wyp_e_submissions` VALUES("319", "submission", "5c7e94a7-2859-4277-937d-7d11f114e987", "953", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.137", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-27 22:44:46", "2023-06-27 22:44:46", "2023-06-27 22:44:46", "2023-06-27 22:44:46");
INSERT INTO `wyp_e_submissions` VALUES("320", "submission", "58f71d2e-7685-4c44-a6b8-f7fd5dfa7b61", "956", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.120.51.115", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-28 20:19:42", "2023-06-28 20:19:42", "2023-06-28 20:19:42", "2023-06-28 20:19:42");
INSERT INTO `wyp_e_submissions` VALUES("321", "submission", "b6ffae4e-dba2-43e7-80ed-32fac75d688f", "959", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.114.15", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-28 20:29:29", "2023-06-28 20:29:29", "2023-06-28 20:29:29", "2023-06-28 20:29:29");
INSERT INTO `wyp_e_submissions` VALUES("322", "submission", "3c277bb1-9067-4d72-b219-a2eca18896d9", "962", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "37.120.232.84", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-28 23:09:09", "2023-06-28 23:09:09", "2023-06-28 23:09:09", "2023-06-28 23:09:09");
INSERT INTO `wyp_e_submissions` VALUES("323", "submission", "50805c62-5a0c-4269-afa3-d125c3df921f", "965", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "188.126.89.123", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-29 03:05:19", "2023-06-29 03:05:19", "2023-06-29 03:05:19", "2023-06-29 03:05:19");
INSERT INTO `wyp_e_submissions` VALUES("324", "submission", "33f7ec3c-c7ac-42ec-80f9-cc409f3e073e", "968", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "193.56.113.19", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-29 16:59:21", "2023-06-29 16:59:21", "2023-06-29 16:59:21", "2023-06-29 16:59:21");
INSERT INTO `wyp_e_submissions` VALUES("325", "submission", "c7c8d177-b970-4350-bfd6-df2f2f8a5052", "971", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.116", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-29 19:17:32", "2023-06-29 19:17:32", "2023-06-29 19:17:32", "2023-06-29 19:17:32");
INSERT INTO `wyp_e_submissions` VALUES("326", "submission", "29a39406-864a-46ba-a81c-a69c39ff1fe5", "974", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "104.247.115.207", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-29 19:27:14", "2023-06-29 19:27:14", "2023-06-29 19:27:14", "2023-06-29 19:27:14");
INSERT INTO `wyp_e_submissions` VALUES("327", "submission", "b4d56f1a-8b51-45d9-bc8a-eead6dfa40e4", "977", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.206", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-30 08:25:09", "2023-06-30 08:25:09", "2023-06-30 08:25:09", "2023-06-30 08:25:09");
INSERT INTO `wyp_e_submissions` VALUES("328", "submission", "2f32e6d7-5e63-4ee4-94ff-53a051855d38", "980", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "104.247.115.107", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-30 22:07:45", "2023-06-30 22:07:45", "2023-06-30 22:07:45", "2023-06-30 22:07:45");
INSERT INTO `wyp_e_submissions` VALUES("329", "submission", "207654f9-4e26-4cfa-8b25-b0cc8e0ebf71", "983", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.146", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-06-30 22:49:46", "2023-06-30 22:49:46", "2023-06-30 22:49:46", "2023-06-30 22:49:46");
INSERT INTO `wyp_e_submissions` VALUES("330", "submission", "98cf2d0e-5f5d-4dbb-9cbc-f5f0c333f027", "986", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "193.56.113.64", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-01 06:56:41", "2023-07-01 06:56:41", "2023-07-01 06:56:41", "2023-07-01 06:56:41");
INSERT INTO `wyp_e_submissions` VALUES("331", "submission", "a5d7a706-f8cf-405f-92cd-6dc3fbceed8d", "989", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "165.231.159.22", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-01 17:35:22", "2023-07-01 17:35:22", "2023-07-01 17:35:22", "2023-07-01 17:35:22");
INSERT INTO `wyp_e_submissions` VALUES("332", "submission", "f719ce76-b3f9-4b90-a1f4-1e75e681ee09", "992", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "38.153.113.150", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-01 17:44:44", "2023-07-01 17:44:44", "2023-07-01 17:44:44", "2023-07-01 17:44:44");
INSERT INTO `wyp_e_submissions` VALUES("333", "submission", "cd25af63-d225-48cd-9c99-eb46744f484e", "995", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.127.244", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-02 12:29:43", "2023-07-02 12:29:43", "2023-07-02 12:29:43", "2023-07-02 12:29:43");
INSERT INTO `wyp_e_submissions` VALUES("334", "submission", "2462c785-f3e5-47ce-b34e-b52c507e74cb", "998", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.70.8", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-02 14:58:20", "2023-07-02 14:58:20", "2023-07-02 14:58:20", "2023-07-02 14:58:20");
INSERT INTO `wyp_e_submissions` VALUES("335", "submission", "4e8db7cc-ed0c-49cc-a395-e647684b93ac", "1001", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.187.243.237", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-02 15:10:07", "2023-07-02 15:10:07", "2023-07-02 15:10:07", "2023-07-02 15:10:07");
INSERT INTO `wyp_e_submissions` VALUES("336", "submission", "8968826f-c5a2-4119-88ba-2c35d19ad889", "1004", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.116", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-03 10:01:38", "2023-07-03 10:01:38", "2023-07-03 10:01:38", "2023-07-03 10:01:38");
INSERT INTO `wyp_e_submissions` VALUES("337", "submission", "3a4f6a5c-1b1b-467d-83c8-487f23da17d5", "1007", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "193.56.113.27", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OpenWave/97.4.2043.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-03 15:49:35", "2023-07-03 15:49:35", "2023-07-03 15:49:35", "2023-07-03 15:49:35");
INSERT INTO `wyp_e_submissions` VALUES("338", "submission", "25393bd5-9caf-4de7-a13a-a44ecba79226", "1010", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.150.70.209", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-05 20:29:40", "2023-07-05 20:29:40", "2023-07-05 20:29:40", "2023-07-05 20:29:40");
INSERT INTO `wyp_e_submissions` VALUES("339", "submission", "4022cda3-d08a-4de6-a168-3549bff2656e", "1013", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.210.201.177", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-05 20:42:27", "2023-07-05 20:42:27", "2023-07-05 20:42:27", "2023-07-05 20:42:27");
INSERT INTO `wyp_e_submissions` VALUES("340", "submission", "093337c8-9876-4802-a9eb-08bd543f2f76", "1016", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "27.34.104.35", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-05 23:28:36", "2023-07-05 23:28:36", "2023-07-05 23:28:36", "2023-07-05 23:28:36");
INSERT INTO `wyp_e_submissions` VALUES("341", "submission", "9085ff00-4e9d-4224-8fae-9aa17848b743", "1019", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "107.158.118.60", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-07 08:51:08", "2023-07-07 08:51:08", "2023-07-07 08:51:08", "2023-07-07 08:51:08");
INSERT INTO `wyp_e_submissions` VALUES("342", "submission", "f4a8f40f-1cfd-41d0-a767-05d031f1c664", "1022", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "38.153.113.124", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-07 09:00:23", "2023-07-07 09:00:23", "2023-07-07 09:00:23", "2023-07-07 09:00:23");
INSERT INTO `wyp_e_submissions` VALUES("343", "submission", "7ca5f361-917d-41e0-984d-f7aee007fe03", "1025", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.54.242", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-08 15:59:52", "2023-07-08 15:59:52", "2023-07-08 15:59:52", "2023-07-08 15:59:52");
INSERT INTO `wyp_e_submissions` VALUES("344", "submission", "aa42f3e5-eb3d-4564-a0a5-b866d25ee149", "1028", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.205", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-08 18:55:39", "2023-07-08 18:55:39", "2023-07-08 18:55:39", "2023-07-08 18:55:39");
INSERT INTO `wyp_e_submissions` VALUES("345", "submission", "e1829aed-65e3-4c01-a192-512d94cdbc82", "1031", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.83.69.72", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-10 06:34:14", "2023-07-10 06:34:14", "2023-07-10 06:34:14", "2023-07-10 06:34:14");
INSERT INTO `wyp_e_submissions` VALUES("346", "submission", "d1f42a0f-d2d4-4252-8994-4080537d7e92", "1034", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.216", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-11 00:06:33", "2023-07-11 00:06:33", "2023-07-11 00:06:33", "2023-07-11 00:06:33");
INSERT INTO `wyp_e_submissions` VALUES("347", "submission", "bee640db-7142-4e2e-ac76-7c538be173b1", "1037", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.216", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-11 06:06:50", "2023-07-11 06:06:50", "2023-07-11 06:06:50", "2023-07-11 06:06:50");
INSERT INTO `wyp_e_submissions` VALUES("348", "submission", "bb7d363d-1283-4b9a-8d45-f8f9eda66cde", "1040", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.189.114.124", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-12 11:27:58", "2023-07-12 11:27:58", "2023-07-12 11:27:58", "2023-07-12 11:27:58");
INSERT INTO `wyp_e_submissions` VALUES("349", "submission", "30b30c68-8b54-48e2-81d0-f4aa0aa334d2", "1043", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.200.112", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-12 19:54:45", "2023-07-12 19:54:45", "2023-07-12 19:54:45", "2023-07-12 19:54:45");
INSERT INTO `wyp_e_submissions` VALUES("350", "submission", "49ce8689-42dd-4cd6-8821-ed76c394fffe", "1046", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.120.51.131", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-12 20:02:04", "2023-07-12 20:02:04", "2023-07-12 20:02:04", "2023-07-12 20:02:04");
INSERT INTO `wyp_e_submissions` VALUES("351", "submission", "1ce75f8e-9f78-4cf6-bea2-dab193b88bb8", "1049", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.157.207", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-14 14:11:20", "2023-07-14 14:11:20", "2023-07-14 14:11:20", "2023-07-14 14:11:20");
INSERT INTO `wyp_e_submissions` VALUES("352", "submission", "c615b45b-f07f-4ab6-b24b-77ae8add7cbd", "1052", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.136", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-14 14:17:57", "2023-07-14 14:17:57", "2023-07-14 14:17:57", "2023-07-14 14:17:57");
INSERT INTO `wyp_e_submissions` VALUES("353", "submission", "5b6ff305-478e-49c0-8667-41efc37e0548", "1055", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.76.9.52", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-15 19:44:00", "2023-07-15 19:44:00", "2023-07-15 19:44:00", "2023-07-15 19:44:00");
INSERT INTO `wyp_e_submissions` VALUES("354", "submission", "9ec3ab40-d5c4-47c4-9c1e-a84d7c7aabc6", "1058", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "151.106.11.180", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-15 20:40:51", "2023-07-15 20:40:51", "2023-07-15 20:40:51", "2023-07-15 20:40:51");
INSERT INTO `wyp_e_submissions` VALUES("355", "submission", "22bf8235-0dfa-48a7-81bc-5162f17e7476", "1061", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.52", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-17 21:02:30", "2023-07-17 21:02:30", "2023-07-17 21:02:30", "2023-07-17 21:02:30");
INSERT INTO `wyp_e_submissions` VALUES("356", "submission", "081e089e-942d-44a5-91e3-6c7177fa93c0", "1064", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.120", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-17 21:09:11", "2023-07-17 21:09:11", "2023-07-17 21:09:11", "2023-07-17 21:09:11");
INSERT INTO `wyp_e_submissions` VALUES("357", "submission", "09fa48d6-07ac-4329-a892-b946f244c2ac", "1067", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.89.210", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-18 18:33:22", "2023-07-18 18:33:22", "2023-07-18 18:33:22", "2023-07-18 18:33:22");
INSERT INTO `wyp_e_submissions` VALUES("358", "submission", "f044c503-7f36-4eb9-89dc-a27b702a9e7a", "1070", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.158.75", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-18 18:40:07", "2023-07-18 18:40:07", "2023-07-18 18:40:07", "2023-07-18 18:40:07");
INSERT INTO `wyp_e_submissions` VALUES("359", "submission", "4878ebb9-46d6-4413-b5fd-378c92d8bce4", "1073", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "216.162.199.246", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-21 07:52:30", "2023-07-21 07:52:30", "2023-07-21 07:52:30", "2023-07-21 07:52:30");
INSERT INTO `wyp_e_submissions` VALUES("360", "submission", "416b717e-8499-468e-9a87-6b593b6543db", "1076", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.36.230", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-21 13:19:57", "2023-07-21 13:19:57", "2023-07-21 13:19:57", "2023-07-21 13:19:57");
INSERT INTO `wyp_e_submissions` VALUES("361", "submission", "7b954b25-f585-4a2f-9a91-9ce191f607a7", "1079", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.147", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-21 14:01:06", "2023-07-21 14:01:06", "2023-07-21 14:01:06", "2023-07-21 14:01:06");
INSERT INTO `wyp_e_submissions` VALUES("362", "submission", "33f47cdd-693a-4f16-8bf3-543115926888", "1082", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.200.5", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-21 14:07:45", "2023-07-21 14:07:45", "2023-07-21 14:07:45", "2023-07-21 14:07:45");
INSERT INTO `wyp_e_submissions` VALUES("363", "submission", "efd7afe2-84b5-42ab-8755-aa1fbbee6115", "1085", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.55.193", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-23 19:14:30", "2023-07-23 19:14:30", "2023-07-23 19:14:30", "2023-07-23 19:14:30");
INSERT INTO `wyp_e_submissions` VALUES("364", "submission", "fc458ad5-c2d1-419d-9b6d-08fc64a81222", "1088", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.159", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-23 19:23:24", "2023-07-23 19:23:24", "2023-07-23 19:23:24", "2023-07-23 19:23:24");
INSERT INTO `wyp_e_submissions` VALUES("365", "submission", "b6e1be0b-a472-4090-84e2-3d3d87a5a65f", "1091", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-24 03:13:48", "2023-07-24 03:13:48", "2023-07-24 03:13:48", "2023-07-24 03:13:48");
INSERT INTO `wyp_e_submissions` VALUES("366", "submission", "58afa673-87b1-4718-8e07-8773ebc86799", "1094", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.46.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-24 03:21:28", "2023-07-24 03:21:28", "2023-07-24 03:21:28", "2023-07-24 03:21:28");
INSERT INTO `wyp_e_submissions` VALUES("367", "submission", "143a9787-cbe7-4cfa-a018-8358b4b798f9", "1097", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-26 15:52:57", "2023-07-26 15:52:57", "2023-07-26 15:52:57", "2023-07-26 15:52:57");
INSERT INTO `wyp_e_submissions` VALUES("368", "submission", "370ea7f3-c021-4e49-8fb5-a3dfab649f30", "1100", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.158.217", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-27 03:02:10", "2023-07-27 03:02:10", "2023-07-27 03:02:10", "2023-07-27 03:02:10");
INSERT INTO `wyp_e_submissions` VALUES("369", "submission", "d0f4b520-51b1-4542-bb71-bfd7ac65f1c8", "1103", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "122.176.193.196", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-27 10:48:42", "2023-07-27 10:48:42", "2023-07-27 10:48:42", "2023-07-27 10:48:42");
INSERT INTO `wyp_e_submissions` VALUES("370", "submission", "c5817eb5-4a39-4e0e-b1bc-b0b42461bada", "1106", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-30 06:30:37", "2023-07-30 06:30:37", "2023-07-30 06:30:37", "2023-07-30 06:30:37");
INSERT INTO `wyp_e_submissions` VALUES("371", "submission", "86d77a70-3810-4962-9414-5c3bd0a8e955", "1109", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.115.167", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-30 11:06:56", "2023-07-30 11:06:56", "2023-07-30 11:06:56", "2023-07-30 11:06:56");
INSERT INTO `wyp_e_submissions` VALUES("372", "submission", "8f82e228-9e54-4ff6-9371-2e2c0d2e166f", "1112", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.157.224", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-31 05:53:49", "2023-07-31 05:53:49", "2023-07-31 05:53:49", "2023-07-31 05:53:49");
INSERT INTO `wyp_e_submissions` VALUES("373", "submission", "d05f7ce1-b16e-4a1c-842f-c66f38e00321", "1115", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.249.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-07-31 06:05:32", "2023-07-31 06:05:32", "2023-07-31 06:05:32", "2023-07-31 06:05:32");
INSERT INTO `wyp_e_submissions` VALUES("374", "submission", "ba884839-fd54-4467-8dad-05aee73fefc7", "1118", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "38.111.111.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-01 02:03:31", "2023-08-01 02:03:31", "2023-08-01 02:03:31", "2023-08-01 02:03:31");
INSERT INTO `wyp_e_submissions` VALUES("375", "submission", "65ac1747-199c-468e-9e82-232cd4fe0051", "1121", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "38.111.111.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-01 06:14:50", "2023-08-01 06:14:50", "2023-08-01 06:14:50", "2023-08-01 06:14:50");
INSERT INTO `wyp_e_submissions` VALUES("376", "submission", "15faf5b3-eeb4-477b-a85e-1a04a71e2bdd", "1124", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.115.55", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-02 01:42:15", "2023-08-02 01:42:15", "2023-08-02 01:42:15", "2023-08-02 01:42:15");
INSERT INTO `wyp_e_submissions` VALUES("377", "submission", "b78f524e-4d3b-49dd-984a-e904125a446d", "1127", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.254.199", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-02 01:51:31", "2023-08-02 01:51:31", "2023-08-02 01:51:31", "2023-08-02 01:51:31");
INSERT INTO `wyp_e_submissions` VALUES("378", "submission", "41793c87-72cd-4226-93d1-e9526995b787", "1130", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "176.111.174.153", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-03 10:11:10", "2023-08-03 10:11:10", "2023-08-03 10:11:10", "2023-08-03 10:11:10");
INSERT INTO `wyp_e_submissions` VALUES("379", "submission", "998054d7-cdf4-4a6b-8c9c-e89ad255abb7", "1133", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.169", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-03 16:55:00", "2023-08-03 16:55:00", "2023-08-03 16:55:00", "2023-08-03 16:55:00");
INSERT INTO `wyp_e_submissions` VALUES("380", "submission", "6e59e320-a57a-460e-b5a9-fa0d4dbc463d", "1136", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.20.127", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-04 04:09:49", "2023-08-04 04:09:49", "2023-08-04 04:09:49", "2023-08-04 04:09:49");
INSERT INTO `wyp_e_submissions` VALUES("381", "submission", "23df51eb-23f1-497d-8a3c-5ea54a157e19", "1139", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.247.35", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-04 04:25:10", "2023-08-04 04:25:10", "2023-08-04 04:25:10", "2023-08-04 04:25:10");
INSERT INTO `wyp_e_submissions` VALUES("382", "submission", "ecb8199d-94c0-42ac-b93e-b183644d0662", "1142", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.20.24", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-04 21:17:20", "2023-08-04 21:17:20", "2023-08-04 21:17:20", "2023-08-04 21:17:20");
INSERT INTO `wyp_e_submissions` VALUES("383", "submission", "3dcedbe2-ddf4-495c-887c-43e49918eddd", "1145", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.57.16", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-04 21:32:22", "2023-08-04 21:32:22", "2023-08-04 21:32:22", "2023-08-04 21:32:22");
INSERT INTO `wyp_e_submissions` VALUES("384", "submission", "3961b032-80e5-4b4d-8e10-47d27cd3bfe9", "1148", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "149.34.242.225", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36 Kinza/4.8.2", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-08 13:15:15", "2023-08-08 13:15:15", "2023-08-08 13:15:15", "2023-08-08 13:15:15");
INSERT INTO `wyp_e_submissions` VALUES("385", "submission", "fd1cd28a-f0d3-4b69-a0cf-d928806ec596", "1151", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.214.218.146", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-08 13:30:55", "2023-08-08 13:30:55", "2023-08-08 13:30:55", "2023-08-08 13:30:55");
INSERT INTO `wyp_e_submissions` VALUES("386", "submission", "0ece53fc-ee99-413e-a5e8-be2a4ca9386f", "1154", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.195.148", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-08 15:46:02", "2023-08-08 15:46:02", "2023-08-08 15:46:02", "2023-08-08 15:46:02");
INSERT INTO `wyp_e_submissions` VALUES("387", "submission", "4178a4f9-1849-46d9-94ed-4756dd55f618", "1157", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.121", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-10 04:15:20", "2023-08-10 04:15:20", "2023-08-10 04:15:20", "2023-08-10 04:15:20");
INSERT INTO `wyp_e_submissions` VALUES("388", "submission", "9ba60bd4-9f14-4701-99f9-5fa94e9661a7", "1160", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.191", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-10 23:52:35", "2023-08-10 23:52:35", "2023-08-10 23:52:35", "2023-08-10 23:52:35");
INSERT INTO `wyp_e_submissions` VALUES("389", "submission", "3b20e5be-ae3d-4ae2-924c-a4bd51be421a", "1163", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.121", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-11 01:01:37", "2023-08-11 01:01:37", "2023-08-11 01:01:37", "2023-08-11 01:01:37");
INSERT INTO `wyp_e_submissions` VALUES("390", "submission", "cba09e7f-98a1-45ff-8e03-50bf5edf371b", "1166", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.100", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-12 09:36:43", "2023-08-12 09:36:43", "2023-08-12 09:36:43", "2023-08-12 09:36:43");
INSERT INTO `wyp_e_submissions` VALUES("391", "submission", "706315b5-a617-4d8f-88fc-e92a7b79ef97", "1169", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.158.75", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-12 09:45:36", "2023-08-12 09:45:36", "2023-08-12 09:45:36", "2023-08-12 09:45:36");
INSERT INTO `wyp_e_submissions` VALUES("392", "submission", "04e2d8c8-a8b7-4678-9e4f-21a1e7c50f86", "1172", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "37.156.216.212", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-12 19:42:37", "2023-08-12 19:42:37", "2023-08-12 19:42:37", "2023-08-12 19:42:37");
INSERT INTO `wyp_e_submissions` VALUES("393", "submission", "c0e25b8c-fb10-4e86-a3eb-f273bfe00969", "1175", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.60", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-13 18:24:21", "2023-08-13 18:24:21", "2023-08-13 18:24:21", "2023-08-13 18:24:21");
INSERT INTO `wyp_e_submissions` VALUES("394", "submission", "abe8bfc2-f0bc-4671-87a9-b7a6fbe60f95", "1178", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.178.9", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-13 18:29:31", "2023-08-13 18:29:31", "2023-08-13 18:29:31", "2023-08-13 18:29:31");
INSERT INTO `wyp_e_submissions` VALUES("395", "submission", "df964636-1db0-4315-8d4d-fd5175452962", "1181", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.83.89.3", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-13 19:00:15", "2023-08-13 19:00:15", "2023-08-13 19:00:15", "2023-08-13 19:00:15");
INSERT INTO `wyp_e_submissions` VALUES("396", "submission", "0d7d5432-aebe-4a1b-812b-274d48e93106", "1184", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.200.41", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-13 19:06:36", "2023-08-13 19:06:36", "2023-08-13 19:06:36", "2023-08-13 19:06:36");
INSERT INTO `wyp_e_submissions` VALUES("397", "submission", "a07f0db4-8606-4c88-91f8-bd7824d70aa0", "1187", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.39", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-14 23:56:04", "2023-08-14 23:56:04", "2023-08-14 23:56:04", "2023-08-14 23:56:04");
INSERT INTO `wyp_e_submissions` VALUES("398", "submission", "b92a43e4-2096-4435-8853-32c491c37490", "1190", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.158.254", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-15 00:02:34", "2023-08-15 00:02:34", "2023-08-15 00:02:34", "2023-08-15 00:02:34");
INSERT INTO `wyp_e_submissions` VALUES("399", "submission", "f080d081-2e7e-4cc7-9df6-c84c51eefd91", "1193", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "31.171.155.14", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-19 12:10:00", "2023-08-19 12:10:00", "2023-08-19 12:10:00", "2023-08-19 12:10:00");
INSERT INTO `wyp_e_submissions` VALUES("400", "submission", "3dd43e47-1209-470e-8f7e-2fca7c29a1a3", "1196", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.47", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-19 16:12:08", "2023-08-19 16:12:08", "2023-08-19 16:12:08", "2023-08-19 16:12:08");
INSERT INTO `wyp_e_submissions` VALUES("401", "submission", "387f8faf-baa2-41c8-9b89-3b8b2ab49405", "1199", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.158.114", "Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-19 16:18:32", "2023-08-19 16:18:32", "2023-08-19 16:18:32", "2023-08-19 16:18:32");
INSERT INTO `wyp_e_submissions` VALUES("402", "submission", "98ff6c33-e0b4-4eee-88ac-2fb4d9aceb79", "1202", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.15", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-24 19:27:35", "2023-08-24 19:27:35", "2023-08-24 19:27:35", "2023-08-24 19:27:35");
INSERT INTO `wyp_e_submissions` VALUES("403", "submission", "bdbfe0ef-6251-4679-b7cb-25011f01633a", "1205", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-25 17:43:30", "2023-08-25 17:43:30", "2023-08-25 17:43:30", "2023-08-25 17:43:30");
INSERT INTO `wyp_e_submissions` VALUES("404", "submission", "ff4589fc-08f1-4266-b5c4-ab0243987b98", "1208", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.98", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-25 21:23:46", "2023-08-25 21:23:46", "2023-08-25 21:23:46", "2023-08-25 21:23:46");
INSERT INTO `wyp_e_submissions` VALUES("405", "submission", "52e6c390-84c6-49cd-9f7a-343995c0a422", "1211", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.188", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-27 20:54:34", "2023-08-27 20:54:34", "2023-08-27 20:54:34", "2023-08-27 20:54:34");
INSERT INTO `wyp_e_submissions` VALUES("406", "submission", "2c8262cb-b6c2-40ad-9301-dac8cb358cab", "1214", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.52.102", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-28 12:10:19", "2023-08-28 12:10:19", "2023-08-28 12:10:19", "2023-08-28 12:10:19");
INSERT INTO `wyp_e_submissions` VALUES("407", "submission", "cd1fcabd-2705-4727-839f-733fe48a9bdc", "1217", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.47", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-28 12:21:16", "2023-08-28 12:21:16", "2023-08-28 12:21:16", "2023-08-28 12:21:16");
INSERT INTO `wyp_e_submissions` VALUES("408", "submission", "c6cc5909-ba38-4656-ba6b-32b47c0baf1b", "1220", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OpenWave/97.4.2043.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-30 00:19:15", "2023-08-30 00:19:15", "2023-08-30 00:19:15", "2023-08-30 00:19:15");
INSERT INTO `wyp_e_submissions` VALUES("409", "submission", "022e68e8-b26b-4b19-9705-758cbdd65fe8", "1223", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.188", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-08-30 21:02:55", "2023-08-30 21:02:55", "2023-08-30 21:02:55", "2023-08-30 21:02:55");
INSERT INTO `wyp_e_submissions` VALUES("410", "submission", "970925c0-f88f-4d4b-94c5-1c2538c0d5fa", "1226", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.189.114.120", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-01 04:11:54", "2023-09-01 04:11:54", "2023-09-01 04:11:54", "2023-09-01 04:11:54");
INSERT INTO `wyp_e_submissions` VALUES("411", "submission", "c080888f-d8a9-4f68-a721-c2656fc5b189", "1229", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.188", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-01 10:38:37", "2023-09-01 10:38:37", "2023-09-01 10:38:37", "2023-09-01 10:38:37");
INSERT INTO `wyp_e_submissions` VALUES("412", "submission", "e6d675e1-60ea-4aa2-92d3-79e620e299fe", "1232", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "89.187.164.166", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-01 18:49:30", "2023-09-01 18:49:30", "2023-09-01 18:49:30", "2023-09-01 18:49:30");
INSERT INTO `wyp_e_submissions` VALUES("413", "submission", "ceba67f6-ea5f-40c7-aeea-039fde4da2c5", "1235", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.188", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-02 11:29:28", "2023-09-02 11:29:28", "2023-09-02 11:29:28", "2023-09-02 11:29:28");
INSERT INTO `wyp_e_submissions` VALUES("414", "submission", "31832ca4-e463-42b9-828f-2e0a216a9c07", "1238", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "74.63.204.211", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-02 19:37:16", "2023-09-02 19:37:16", "2023-09-02 19:37:16", "2023-09-02 19:37:16");
INSERT INTO `wyp_e_submissions` VALUES("415", "submission", "7d6572be-fd68-4fe2-89fc-9b862bb0c26a", "1241", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-03 10:35:44", "2023-09-03 10:35:44", "2023-09-03 10:35:44", "2023-09-03 10:35:44");
INSERT INTO `wyp_e_submissions` VALUES("416", "submission", "acb561a9-5565-44d3-9747-bbacb02c5ef1", "1244", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.200", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-04 11:35:59", "2023-09-04 11:35:59", "2023-09-04 11:35:59", "2023-09-04 11:35:59");
INSERT INTO `wyp_e_submissions` VALUES("417", "submission", "7146ba7e-16ac-4944-bf6f-d6bc425e6f2f", "1247", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.109.83", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-04 12:19:47", "2023-09-04 12:19:47", "2023-09-04 12:19:47", "2023-09-04 12:19:47");
INSERT INTO `wyp_e_submissions` VALUES("418", "submission", "923ba919-1ea2-45d1-ace8-2c52394f76d4", "1250", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.47.7", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36 Edg/90.0.818.46", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-05 01:45:59", "2023-09-05 01:45:59", "2023-09-05 01:45:59", "2023-09-05 01:45:59");
INSERT INTO `wyp_e_submissions` VALUES("419", "submission", "1f25dae2-832b-4a19-b162-39949894c1ac", "1253", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "154.47.27.22", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-05 06:39:22", "2023-09-05 06:39:22", "2023-09-05 06:39:22", "2023-09-05 06:39:22");
INSERT INTO `wyp_e_submissions` VALUES("420", "submission", "b49c9970-7d7c-4fca-94fe-0cd6738d8fc4", "1256", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.115", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-07 14:22:26", "2023-09-07 14:22:26", "2023-09-07 14:22:26", "2023-09-07 14:22:26");
INSERT INTO `wyp_e_submissions` VALUES("421", "submission", "414687f1-9b71-4091-b9e3-c81a6dcacb1c", "1259", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.15", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-08 12:18:57", "2023-09-08 12:18:57", "2023-09-08 12:18:57", "2023-09-08 12:18:57");
INSERT INTO `wyp_e_submissions` VALUES("422", "submission", "4c107248-5630-435a-9deb-a3fbc061bedd", "1262", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "154.16.20.23", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-09 13:36:47", "2023-09-09 13:36:47", "2023-09-09 13:36:47", "2023-09-09 13:36:47");
INSERT INTO `wyp_e_submissions` VALUES("423", "submission", "e0a20779-6c00-4b2a-a0cf-294465a8f66a", "1265", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "198.202.171.130", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-09 14:04:27", "2023-09-09 14:04:27", "2023-09-09 14:04:27", "2023-09-09 14:04:27");
INSERT INTO `wyp_e_submissions` VALUES("424", "submission", "a73dacc0-f153-4372-a4ad-eea9c8cba8bc", "1268", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.254.58.195", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-11 07:38:19", "2023-09-11 07:38:19", "2023-09-11 07:38:19", "2023-09-11 07:38:19");
INSERT INTO `wyp_e_submissions` VALUES("425", "submission", "cef93d90-d985-4187-95b5-e6c5e3b49bcf", "1271", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "202.94.175.163", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-12 12:33:57", "2023-09-12 12:33:57", "2023-09-12 12:33:57", "2023-09-12 12:33:57");
INSERT INTO `wyp_e_submissions` VALUES("426", "submission", "1e920092-57bc-4371-9ce3-7c8db7fdb328", "1274", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.112.0.82", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-12 12:46:41", "2023-09-12 12:46:41", "2023-09-12 12:46:41", "2023-09-12 12:46:41");
INSERT INTO `wyp_e_submissions` VALUES("427", "submission", "d3b4c207-a9eb-4417-8455-5afb579b3de0", "1277", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "122.180.191.236", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-12 14:01:22", "2023-09-12 14:01:22", "2023-09-12 14:01:22", "2023-09-12 14:01:22");
INSERT INTO `wyp_e_submissions` VALUES("428", "submission", "4c54ac09-e9a3-44f3-9505-96c7d61aab71", "1280", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "122.180.191.236", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-12 19:15:11", "2023-09-12 19:15:11", "2023-09-12 19:15:11", "2023-09-12 19:15:11");
INSERT INTO `wyp_e_submissions` VALUES("429", "submission", "50f60ab3-596e-40b5-81a1-51fb9fdcfbaa", "1283", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "122.180.191.236", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-12 20:30:55", "2023-09-12 20:30:55", "2023-09-12 20:30:55", "2023-09-12 20:30:55");
INSERT INTO `wyp_e_submissions` VALUES("430", "submission", "7c378f11-5ab9-4a28-be7c-8f68371674fc", "1286", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.198", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-14 04:04:07", "2023-09-14 04:04:07", "2023-09-14 04:04:07", "2023-09-14 04:04:07");
INSERT INTO `wyp_e_submissions` VALUES("431", "submission", "02f36f12-3748-44ed-a1b8-7bd1d259dd4f", "1289", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "179.61.156.168", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-15 13:18:42", "2023-09-15 13:18:42", "2023-09-15 13:18:42", "2023-09-15 13:18:42");
INSERT INTO `wyp_e_submissions` VALUES("432", "submission", "413fd101-df94-4f63-b319-71cb2d7362d7", "1292", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.112.0.85", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-15 13:26:52", "2023-09-15 13:26:52", "2023-09-15 13:26:52", "2023-09-15 13:26:52");
INSERT INTO `wyp_e_submissions` VALUES("433", "submission", "b088c08d-4019-4ae6-9132-ae5a9b5ea69a", "1295", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "154.16.20.199", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-16 15:50:30", "2023-09-16 15:50:30", "2023-09-16 15:50:30", "2023-09-16 15:50:30");
INSERT INTO `wyp_e_submissions` VALUES("434", "submission", "a5d81063-5e0f-42dc-9e5b-f01a6b1b2fa5", "1298", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.73", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-16 16:02:53", "2023-09-16 16:02:53", "2023-09-16 16:02:53", "2023-09-16 16:02:53");
INSERT INTO `wyp_e_submissions` VALUES("435", "submission", "67934637-72c2-4999-9889-8f4eb0468b1f", "1301", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.190.42.200", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-16 18:20:50", "2023-09-16 18:20:50", "2023-09-16 18:20:50", "2023-09-16 18:20:50");
INSERT INTO `wyp_e_submissions` VALUES("436", "submission", "3ff6bdf8-6d90-451c-a021-8eb22ebe83f0", "1304", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.148", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-16 19:08:36", "2023-09-16 19:08:36", "2023-09-16 19:08:36", "2023-09-16 19:08:36");
INSERT INTO `wyp_e_submissions` VALUES("437", "submission", "8fbc539c-57ae-4126-8420-a5e5a6924cec", "1307", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.89", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-16 19:16:08", "2023-09-16 19:16:08", "2023-09-16 19:16:08", "2023-09-16 19:16:08");
INSERT INTO `wyp_e_submissions` VALUES("438", "submission", "fa54ae23-0409-4bee-9ef1-a412e1dc9ccc", "1310", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.63.31", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-17 13:12:50", "2023-09-17 13:12:50", "2023-09-17 13:12:50", "2023-09-17 13:12:50");
INSERT INTO `wyp_e_submissions` VALUES("439", "submission", "83896b73-46af-45cb-bb34-f80a7606aef6", "1313", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.57.64", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-18 11:19:36", "2023-09-18 11:19:36", "2023-09-18 11:19:36", "2023-09-18 11:19:36");
INSERT INTO `wyp_e_submissions` VALUES("440", "submission", "aa991655-c3b1-4be8-b19c-324140a0561c", "1316", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.99.235", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-18 11:27:14", "2023-09-18 11:27:14", "2023-09-18 11:27:14", "2023-09-18 11:27:14");
INSERT INTO `wyp_e_submissions` VALUES("441", "submission", "9226594b-0f36-4d00-8a4f-792feb314bfa", "1319", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "179.61.156.67", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-18 14:54:05", "2023-09-18 14:54:05", "2023-09-18 14:54:05", "2023-09-18 14:54:05");
INSERT INTO `wyp_e_submissions` VALUES("442", "submission", "8cd8d2f2-2e63-4877-812f-d06bb05c301a", "1322", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.109.110.35", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-18 15:09:45", "2023-09-18 15:09:45", "2023-09-18 15:09:45", "2023-09-18 15:09:45");
INSERT INTO `wyp_e_submissions` VALUES("443", "submission", "9fde4463-56b4-4cf8-bac1-7d90e1996311", "1325", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.103", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-19 01:49:46", "2023-09-19 01:49:46", "2023-09-19 01:49:46", "2023-09-19 01:49:46");
INSERT INTO `wyp_e_submissions` VALUES("444", "submission", "bf2bf5f3-be10-4d86-b1ce-9b17f5ba85b8", "1328", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.181.148", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-19 01:59:01", "2023-09-19 01:59:01", "2023-09-19 01:59:01", "2023-09-19 01:59:01");
INSERT INTO `wyp_e_submissions` VALUES("445", "submission", "650643c7-5b34-4684-a555-73e47fec8afa", "1331", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-20 03:07:33", "2023-09-20 03:07:33", "2023-09-20 03:07:33", "2023-09-20 03:07:33");
INSERT INTO `wyp_e_submissions` VALUES("446", "submission", "8c831319-297c-453b-8993-c4d096a3fb29", "1334", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "193.43.118.143", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-20 13:03:26", "2023-09-20 13:03:26", "2023-09-20 13:03:26", "2023-09-20 13:03:26");
INSERT INTO `wyp_e_submissions` VALUES("447", "submission", "6c10f00e-1d62-4c31-a6b9-1ee96dedb76e", "1337", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "192.109.110.55", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-20 13:12:09", "2023-09-20 13:12:09", "2023-09-20 13:12:09", "2023-09-20 13:12:09");
INSERT INTO `wyp_e_submissions` VALUES("448", "submission", "beb57d6a-50ac-4596-901c-abc1f730e1b5", "1340", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "179.61.156.67", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-21 06:02:13", "2023-09-21 06:02:13", "2023-09-21 06:02:13", "2023-09-21 06:02:13");
INSERT INTO `wyp_e_submissions` VALUES("449", "submission", "9a99f069-1d1d-499e-8cd6-dd972ce4565e", "1343", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "179.61.156.247", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-21 06:10:41", "2023-09-21 06:10:41", "2023-09-21 06:10:41", "2023-09-21 06:10:41");
INSERT INTO `wyp_e_submissions` VALUES("450", "submission", "294cdd24-ca08-4393-a503-a1e9b6170787", "1346", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "88.202.186.131", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-21 06:34:30", "2023-09-21 06:34:30", "2023-09-21 06:34:30", "2023-09-21 06:34:30");
INSERT INTO `wyp_e_submissions` VALUES("451", "submission", "fc1f169b-5c3c-4db5-9ab6-fe6376629b4e", "1349", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "88.202.186.131", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-21 12:03:05", "2023-09-21 12:03:05", "2023-09-21 12:03:05", "2023-09-21 12:03:05");
INSERT INTO `wyp_e_submissions` VALUES("452", "submission", "9658ee0b-95f8-4137-a38b-5eea417baa0e", "1352", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.73", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 01:59:05", "2023-09-22 01:59:05", "2023-09-22 01:59:05", "2023-09-22 01:59:05");
INSERT INTO `wyp_e_submissions` VALUES("453", "submission", "4c0f782f-34a7-42e4-8a4c-1a906bc215ad", "1355", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.52.174", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 02:05:55", "2023-09-22 02:05:55", "2023-09-22 02:05:55", "2023-09-22 02:05:55");
INSERT INTO `wyp_e_submissions` VALUES("454", "submission", "3e8f4d35-8505-43fb-99a8-dcfbe6e2a358", "1358", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.49", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 05:31:22", "2023-09-22 05:31:22", "2023-09-22 05:31:22", "2023-09-22 05:31:22");
INSERT INTO `wyp_e_submissions` VALUES("455", "submission", "9ded8d62-e68b-4022-87d1-788123593dcd", "1361", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "160.20.10.169", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 05:48:14", "2023-09-22 05:48:14", "2023-09-22 05:48:14", "2023-09-22 05:48:14");
INSERT INTO `wyp_e_submissions` VALUES("456", "submission", "0074a9ae-6f02-471f-8105-8d305e0524c2", "1364", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.109.103", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 07:49:40", "2023-09-22 07:49:40", "2023-09-22 07:49:40", "2023-09-22 07:49:40");
INSERT INTO `wyp_e_submissions` VALUES("457", "submission", "fd01001f-6d89-40ab-a425-a1cd440e8977", "1367", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.83.89.249", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-22 07:57:51", "2023-09-22 07:57:51", "2023-09-22 07:57:51", "2023-09-22 07:57:51");
INSERT INTO `wyp_e_submissions` VALUES("458", "submission", "e6c26ff0-0954-4173-8aa1-b94d66d1c362", "1370", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.60.174", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-23 07:28:52", "2023-09-23 07:28:52", "2023-09-23 07:28:52", "2023-09-23 07:28:52");
INSERT INTO `wyp_e_submissions` VALUES("459", "submission", "e3896933-63d6-499b-a420-e957d11fa4bb", "1373", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.143", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-23 09:44:47", "2023-09-23 09:44:47", "2023-09-23 09:44:47", "2023-09-23 09:44:47");
INSERT INTO `wyp_e_submissions` VALUES("460", "submission", "ac441f31-5a68-4010-a489-0499862acd8e", "1376", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.37", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-23 09:54:33", "2023-09-23 09:54:33", "2023-09-23 09:54:33", "2023-09-23 09:54:33");
INSERT INTO `wyp_e_submissions` VALUES("461", "submission", "4085e4de-6bd2-4bcc-af32-2c0bc0ed7f0a", "1379", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.104.17", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-23 11:19:21", "2023-09-23 11:19:21", "2023-09-23 11:19:21", "2023-09-23 11:19:21");
INSERT INTO `wyp_e_submissions` VALUES("462", "submission", "79ca3076-aad0-45cb-bcb3-6cefc0f00bfc", "1382", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.96.181.55", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-23 11:39:18", "2023-09-23 11:39:18", "2023-09-23 11:39:18", "2023-09-23 11:39:18");
INSERT INTO `wyp_e_submissions` VALUES("463", "submission", "0e78178a-e34f-4e2a-a331-52083330e05d", "1385", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-24 01:01:02", "2023-09-24 01:01:02", "2023-09-24 01:01:02", "2023-09-24 01:01:02");
INSERT INTO `wyp_e_submissions` VALUES("464", "submission", "f11a6f3d-67d0-49e8-a203-90d07067822e", "1388", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-24 01:52:13", "2023-09-24 01:52:13", "2023-09-24 01:52:13", "2023-09-24 01:52:13");
INSERT INTO `wyp_e_submissions` VALUES("465", "submission", "8e048fd1-340e-4915-9067-0256b8761993", "1391", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.149.231", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-25 14:39:50", "2023-09-25 14:39:50", "2023-09-25 14:39:50", "2023-09-25 14:39:50");
INSERT INTO `wyp_e_submissions` VALUES("466", "submission", "ed66f19f-c846-423c-ad8b-507a92fc1d1b", "1394", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.4.182", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-25 14:52:18", "2023-09-25 14:52:18", "2023-09-25 14:52:18", "2023-09-25 14:52:18");
INSERT INTO `wyp_e_submissions` VALUES("467", "submission", "fa37f52c-13dc-4d33-815c-d8e1190c45ec", "1397", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.80.149.125", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-25 16:39:34", "2023-09-25 16:39:34", "2023-09-25 16:39:34", "2023-09-25 16:39:34");
INSERT INTO `wyp_e_submissions` VALUES("468", "submission", "f2be26e1-caff-45f4-97ff-ca8b7a8487ee", "1400", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.20.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 08:54:42", "2023-09-26 08:54:42", "2023-09-26 08:54:42", "2023-09-26 08:54:42");
INSERT INTO `wyp_e_submissions` VALUES("469", "submission", "6a6b7e39-557b-4dc5-afe2-ba5ad4649340", "1403", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.168.101", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 09:08:17", "2023-09-26 09:08:17", "2023-09-26 09:08:17", "2023-09-26 09:08:17");
INSERT INTO `wyp_e_submissions` VALUES("470", "submission", "6191c3ee-c8e2-4012-9d40-d9d6df6f1bb1", "1406", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.53.42", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 15:59:57", "2023-09-26 15:59:57", "2023-09-26 15:59:57", "2023-09-26 15:59:57");
INSERT INTO `wyp_e_submissions` VALUES("471", "submission", "a8fd93ec-2cbe-40ae-9e5b-b3da9b9cbb4b", "1409", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.114.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 21:29:41", "2023-09-26 21:29:41", "2023-09-26 21:29:41", "2023-09-26 21:29:41");
INSERT INTO `wyp_e_submissions` VALUES("472", "submission", "e9a1bee5-7f5f-412a-9305-bde0025d6abc", "1412", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.95.39.243", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 21:41:21", "2023-09-26 21:41:21", "2023-09-26 21:41:21", "2023-09-26 21:41:21");
INSERT INTO `wyp_e_submissions` VALUES("473", "submission", "8d2bbe49-c84f-471e-ae53-a1df13b30ebb", "1415", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-26 23:55:05", "2023-09-26 23:55:05", "2023-09-26 23:55:05", "2023-09-26 23:55:05");
INSERT INTO `wyp_e_submissions` VALUES("474", "submission", "b14c73b2-1156-4d51-90c7-f4b4cf07fabe", "1418", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "5.254.43.242", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-27 14:22:28", "2023-09-27 14:22:28", "2023-09-27 14:22:28", "2023-09-27 14:22:28");
INSERT INTO `wyp_e_submissions` VALUES("475", "submission", "3b3425c7-b962-48e4-bad3-36237dccf904", "1421", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5042.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-28 11:04:11", "2023-09-28 11:04:11", "2023-09-28 11:04:11", "2023-09-28 11:04:11");
INSERT INTO `wyp_e_submissions` VALUES("476", "submission", "4fceafc6-887a-4200-a5ec-70b6dac966cd", "1424", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-28 18:27:02", "2023-09-28 18:27:02", "2023-09-28 18:27:02", "2023-09-28 18:27:02");
INSERT INTO `wyp_e_submissions` VALUES("477", "submission", "760f3b03-3b1a-4cdc-9470-99f518a1d657", "1427", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.104", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-09-28 20:18:58", "2023-09-28 20:18:58", "2023-09-28 20:18:58", "2023-09-28 20:18:58");
INSERT INTO `wyp_e_submissions` VALUES("478", "submission", "5a6452cd-bbf2-494b-99f6-af5f18f02d39", "1430", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-04 04:07:06", "2023-10-04 04:07:06", "2023-10-04 04:07:06", "2023-10-04 04:07:06");
INSERT INTO `wyp_e_submissions` VALUES("479", "submission", "f621ed7e-891d-46ab-8826-7207fb7df5dd", "1433", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "85.209.11.117", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OpenWave/97.4.2043.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-04 05:36:40", "2023-10-04 05:36:40", "2023-10-04 05:36:40", "2023-10-04 05:36:40");
INSERT INTO `wyp_e_submissions` VALUES("480", "submission", "e06c7dfe-33b2-4111-a7c6-8407360410a1", "1436", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-05 02:04:58", "2023-10-05 02:04:58", "2023-10-05 02:04:58", "2023-10-05 02:04:58");
INSERT INTO `wyp_e_submissions` VALUES("481", "submission", "0b9fc1ef-f493-405d-b8ab-a7a9cf409ef5", "1439", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "23.110.173.225", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-05 13:09:17", "2023-10-05 13:09:17", "2023-10-05 13:09:17", "2023-10-05 13:09:17");
INSERT INTO `wyp_e_submissions` VALUES("482", "submission", "5e1a1a43-47cc-4ed4-b397-3535fce08ebf", "1442", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-06 22:20:34", "2023-10-06 22:20:34", "2023-10-06 22:20:34", "2023-10-06 22:20:34");
INSERT INTO `wyp_e_submissions` VALUES("483", "submission", "5bfe38b8-434f-487a-8faf-55b631733367", "1445", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.122", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-07 03:35:13", "2023-10-07 03:35:13", "2023-10-07 03:35:13", "2023-10-07 03:35:13");
INSERT INTO `wyp_e_submissions` VALUES("484", "submission", "5e75b2df-79d5-461b-8bc7-5ffbdc8ece89", "1448", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-08 05:42:21", "2023-10-08 05:42:21", "2023-10-08 05:42:21", "2023-10-08 05:42:21");
INSERT INTO `wyp_e_submissions` VALUES("485", "submission", "24663dc8-bdef-4249-b0ec-f2e39c9fe1ba", "1451", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-08 13:07:38", "2023-10-08 13:07:38", "2023-10-08 13:07:38", "2023-10-08 13:07:38");
INSERT INTO `wyp_e_submissions` VALUES("486", "submission", "9e651a6e-0f64-49c8-a79f-7f30ccded1ff", "1454", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.99.26", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-08 18:54:30", "2023-10-08 18:54:30", "2023-10-08 18:54:30", "2023-10-08 18:54:30");
INSERT INTO `wyp_e_submissions` VALUES("487", "submission", "0e54a14a-4151-495e-a895-5378747a795a", "1457", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.148.228", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-08 19:28:36", "2023-10-08 19:28:36", "2023-10-08 19:28:36", "2023-10-08 19:28:36");
INSERT INTO `wyp_e_submissions` VALUES("488", "submission", "f39c5241-7727-4474-a7fa-3bd2bf5ebc82", "1460", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-08 23:31:50", "2023-10-08 23:31:50", "2023-10-08 23:31:50", "2023-10-08 23:31:50");
INSERT INTO `wyp_e_submissions` VALUES("489", "submission", "fe18719f-fa5a-4e7b-9a94-2a687059ec1f", "1463", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-09 04:41:24", "2023-10-09 04:41:24", "2023-10-09 04:41:24", "2023-10-09 04:41:24");
INSERT INTO `wyp_e_submissions` VALUES("490", "submission", "9c32f5c4-2445-453b-9856-cfe6e668d13e", "1466", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "176.111.174.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OpenWave/97.4.2043.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-09 11:37:55", "2023-10-09 11:37:55", "2023-10-09 11:37:55", "2023-10-09 11:37:55");
INSERT INTO `wyp_e_submissions` VALUES("491", "submission", "5a37556d-5103-41e1-bb58-3c81aabb9c3e", "1469", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "91.219.212.212", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-09 17:48:27", "2023-10-09 17:48:27", "2023-10-09 17:48:27", "2023-10-09 17:48:27");
INSERT INTO `wyp_e_submissions` VALUES("492", "submission", "31d6231e-b27c-4f0d-b9bf-5df6c48a4342", "1472", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-10 00:09:03", "2023-10-10 00:09:03", "2023-10-10 00:09:03", "2023-10-10 00:09:03");
INSERT INTO `wyp_e_submissions` VALUES("493", "submission", "73c19fbe-8d2b-4967-b49d-4aef2e9b832d", "1475", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-10 08:59:19", "2023-10-10 08:59:19", "2023-10-10 08:59:19", "2023-10-10 08:59:19");
INSERT INTO `wyp_e_submissions` VALUES("494", "submission", "6226843e-228e-4bd3-aa16-a1827b9e9225", "1478", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.209.134", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-11 06:48:16", "2023-10-11 06:48:16", "2023-10-11 06:48:16", "2023-10-11 06:48:16");
INSERT INTO `wyp_e_submissions` VALUES("495", "submission", "9ca2ae34-3b74-43e8-aed2-efb8729ea9e7", "1481", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.118", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-11 11:19:45", "2023-10-11 11:19:45", "2023-10-11 11:19:45", "2023-10-11 11:19:45");
INSERT INTO `wyp_e_submissions` VALUES("496", "submission", "8482c19b-a715-47a3-a0fd-e47f93ba5f8b", "1484", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-12 13:41:15", "2023-10-12 13:41:15", "2023-10-12 13:41:15", "2023-10-12 13:41:15");
INSERT INTO `wyp_e_submissions` VALUES("497", "submission", "3a0b98f7-4130-41ee-b0f9-a629ec4dcf5b", "1487", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.86", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-13 00:18:53", "2023-10-13 00:18:53", "2023-10-13 00:18:53", "2023-10-13 00:18:53");
INSERT INTO `wyp_e_submissions` VALUES("498", "submission", "77ef1aef-d69a-4662-9754-23305aad7916", "1490", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.43.22", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-14 11:09:27", "2023-10-14 11:09:27", "2023-10-14 11:09:27", "2023-10-14 11:09:27");
INSERT INTO `wyp_e_submissions` VALUES("499", "submission", "f9c4f046-5b7e-40e3-aef1-d187053fbf60", "1493", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.178.186", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-15 02:30:04", "2023-10-15 02:30:04", "2023-10-15 02:30:04", "2023-10-15 02:30:04");
INSERT INTO `wyp_e_submissions` VALUES("500", "submission", "a0290ec9-8108-4a23-a5ef-95277d9872a4", "1496", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.147", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-15 03:05:01", "2023-10-15 03:05:01", "2023-10-15 03:05:01", "2023-10-15 03:05:01");
INSERT INTO `wyp_e_submissions` VALUES("501", "submission", "5b52218d-f338-481c-a913-59a9f0d506de", "1499", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.86", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-15 06:39:09", "2023-10-15 06:39:09", "2023-10-15 06:39:09", "2023-10-15 06:39:09");
INSERT INTO `wyp_e_submissions` VALUES("502", "submission", "e3859212-ab49-4c20-b5a5-8ea28fc48950", "1502", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-16 12:26:23", "2023-10-16 12:26:23", "2023-10-16 12:26:23", "2023-10-16 12:26:23");
INSERT INTO `wyp_e_submissions` VALUES("503", "submission", "9f201ec7-0a7e-45fe-935e-6f779b0fcf8c", "1505", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-17 21:39:38", "2023-10-17 21:39:38", "2023-10-17 21:39:38", "2023-10-17 21:39:38");
INSERT INTO `wyp_e_submissions` VALUES("504", "submission", "943174ae-d976-462c-8875-843bf4eb85a9", "1508", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.75", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-19 02:33:51", "2023-10-19 02:33:51", "2023-10-19 02:33:51", "2023-10-19 02:33:51");
INSERT INTO `wyp_e_submissions` VALUES("505", "submission", "68e69b8d-7aac-435d-b0a6-a411deef3a92", "1511", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "85.209.11.117", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-24 03:49:46", "2023-10-24 03:49:46", "2023-10-24 03:49:46", "2023-10-24 03:49:46");
INSERT INTO `wyp_e_submissions` VALUES("506", "submission", "cc74b57d-d73f-4c63-930e-c1e87e0f87dc", "1514", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.159.216", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-24 14:14:38", "2023-10-24 14:14:38", "2023-10-24 14:14:38", "2023-10-24 14:14:38");
INSERT INTO `wyp_e_submissions` VALUES("507", "submission", "a315a614-80d9-4f0c-8a9b-6a87c3458d74", "1517", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-24 16:56:45", "2023-10-24 16:56:45", "2023-10-24 16:56:45", "2023-10-24 16:56:45");
INSERT INTO `wyp_e_submissions` VALUES("508", "submission", "8f9dd4b4-9acd-428d-b5d5-ac094bfd59cc", "1520", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-25 04:13:36", "2023-10-25 04:13:36", "2023-10-25 04:13:36", "2023-10-25 04:13:36");
INSERT INTO `wyp_e_submissions` VALUES("509", "submission", "18964864-5800-4755-8bd6-8d2f3d674d0d", "1523", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "173.239.254.49", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-25 05:30:55", "2023-10-25 05:30:55", "2023-10-25 05:30:55", "2023-10-25 05:30:55");
INSERT INTO `wyp_e_submissions` VALUES("510", "submission", "23725dd1-c66e-4aad-8375-93508921289d", "1526", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "193.37.33.243", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-25 13:39:39", "2023-10-25 13:39:39", "2023-10-25 13:39:39", "2023-10-25 13:39:39");
INSERT INTO `wyp_e_submissions` VALUES("511", "submission", "b4c938ed-1f6d-4718-9bff-d7a1cc8d6609", "1529", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-25 21:26:47", "2023-10-25 21:26:47", "2023-10-25 21:26:47", "2023-10-25 21:26:47");
INSERT INTO `wyp_e_submissions` VALUES("512", "submission", "54d71229-065d-4711-aaaa-4eedd0c32036", "1532", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.190.42.200", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-26 18:57:12", "2023-10-26 18:57:12", "2023-10-26 18:57:12", "2023-10-26 18:57:12");
INSERT INTO `wyp_e_submissions` VALUES("513", "submission", "3aaa2d98-e1c8-419b-9de1-4acb5e7112a0", "1535", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.120", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-27 03:30:37", "2023-10-27 03:30:37", "2023-10-27 03:30:37", "2023-10-27 03:30:37");
INSERT INTO `wyp_e_submissions` VALUES("514", "submission", "4c0ca449-92a9-45ab-af23-e1e565065145", "1538", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-28 07:47:58", "2023-10-28 07:47:58", "2023-10-28 07:47:58", "2023-10-28 07:47:58");
INSERT INTO `wyp_e_submissions` VALUES("515", "submission", "b6631308-d117-4c3b-8098-5f38da05b070", "1541", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "167.160.171.72", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-28 20:57:04", "2023-10-28 20:57:04", "2023-10-28 20:57:04", "2023-10-28 20:57:04");
INSERT INTO `wyp_e_submissions` VALUES("516", "submission", "5b94c870-afac-4920-9264-70425efcad47", "1544", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-29 02:27:46", "2023-10-29 02:27:46", "2023-10-29 02:27:46", "2023-10-29 02:27:46");
INSERT INTO `wyp_e_submissions` VALUES("517", "submission", "9413f5bb-930b-4043-ae74-0dd0eb81543a", "1547", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.189.114.123", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-29 14:10:33", "2023-10-29 14:10:33", "2023-10-29 14:10:33", "2023-10-29 14:10:33");
INSERT INTO `wyp_e_submissions` VALUES("518", "submission", "9b0a2799-3dc3-4ec7-a40f-37ab48111b5f", "1550", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-30 12:27:47", "2023-10-30 12:27:47", "2023-10-30 12:27:47", "2023-10-30 12:27:47");
INSERT INTO `wyp_e_submissions` VALUES("519", "submission", "c8468395-356b-49da-8bc0-f848958eabc2", "1553", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-31 12:04:45", "2023-10-31 12:04:45", "2023-10-31 12:04:45", "2023-10-31 12:04:45");
INSERT INTO `wyp_e_submissions` VALUES("520", "submission", "8d3274c7-3c0a-4a82-a6fc-55cb70df6f28", "1556", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-10-31 19:47:51", "2023-10-31 19:47:51", "2023-10-31 19:47:51", "2023-10-31 19:47:51");
INSERT INTO `wyp_e_submissions` VALUES("521", "submission", "8c44b8e0-b687-40c9-b64f-5014990203c2", "1559", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edge/44.18363.8131", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-01 04:10:14", "2023-11-01 04:10:14", "2023-11-01 04:10:14", "2023-11-01 04:10:14");
INSERT INTO `wyp_e_submissions` VALUES("522", "submission", "9a60318d-d973-418a-8ca2-9ede846a3a3b", "1562", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.103", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-01 19:02:50", "2023-11-01 19:02:50", "2023-11-01 19:02:50", "2023-11-01 19:02:50");
INSERT INTO `wyp_e_submissions` VALUES("523", "submission", "23b06544-6cbc-42e5-ba79-c902a9de4638", "1565", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.147", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-02 10:26:03", "2023-11-02 10:26:03", "2023-11-02 10:26:03", "2023-11-02 10:26:03");
INSERT INTO `wyp_e_submissions` VALUES("524", "submission", "e64a0a3d-5d50-410f-b108-8ff65a611edd", "1568", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.182", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-02 11:02:21", "2023-11-02 11:02:21", "2023-11-02 11:02:21", "2023-11-02 11:02:21");
INSERT INTO `wyp_e_submissions` VALUES("525", "submission", "c7ecfd01-1b3f-47c4-9ef9-ad84084db713", "1571", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.63", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-02 21:24:15", "2023-11-02 21:24:15", "2023-11-02 21:24:15", "2023-11-02 21:24:15");
INSERT INTO `wyp_e_submissions` VALUES("526", "submission", "f96e3969-1d5b-4fc4-963a-6340a9538c01", "1574", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.254.48", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-02 21:33:21", "2023-11-02 21:33:21", "2023-11-02 21:33:21", "2023-11-02 21:33:21");
INSERT INTO `wyp_e_submissions` VALUES("527", "submission", "8081e438-d053-48e8-8a48-14cd82d7bcf0", "1577", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-03 02:59:01", "2023-11-03 02:59:01", "2023-11-03 02:59:01", "2023-11-03 02:59:01");
INSERT INTO `wyp_e_submissions` VALUES("528", "submission", "bbc555b2-1ba9-4ea9-bbc9-6bc173b42a34", "1580", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "107.164.52.12", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-03 06:50:47", "2023-11-03 06:50:47", "2023-11-03 06:50:47", "2023-11-03 06:50:47");
INSERT INTO `wyp_e_submissions` VALUES("529", "submission", "add79570-a323-4a94-a52e-028d531ccab1", "1583", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.108", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 Edge/17.17134", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-03 23:01:54", "2023-11-03 23:01:54", "2023-11-03 23:01:54", "2023-11-03 23:01:54");
INSERT INTO `wyp_e_submissions` VALUES("530", "submission", "44da6880-4bf6-4251-9e09-cd188819ba50", "1586", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-06 03:19:26", "2023-11-06 03:19:26", "2023-11-06 03:19:26", "2023-11-06 03:19:26");
INSERT INTO `wyp_e_submissions` VALUES("531", "submission", "7e127df7-b554-4fa6-91ef-dad1c4212982", "1589", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-06 15:43:36", "2023-11-06 15:43:36", "2023-11-06 15:43:36", "2023-11-06 15:43:36");
INSERT INTO `wyp_e_submissions` VALUES("532", "submission", "60d5ba42-c8df-45ad-8ded-8be0073a74b3", "1592", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "146.70.174.243", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-06 20:17:57", "2023-11-06 20:17:57", "2023-11-06 20:17:57", "2023-11-06 20:17:57");
INSERT INTO `wyp_e_submissions` VALUES("533", "submission", "b257a6c1-a1fe-4438-820f-8c1810dc269d", "1595", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.195.115", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-07 06:45:28", "2023-11-07 06:45:28", "2023-11-07 06:45:28", "2023-11-07 06:45:28");
INSERT INTO `wyp_e_submissions` VALUES("534", "submission", "c416ffbf-d05e-46c3-822c-1092ba1e9433", "1598", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-07 13:03:55", "2023-11-07 13:03:55", "2023-11-07 13:03:55", "2023-11-07 13:03:55");
INSERT INTO `wyp_e_submissions` VALUES("535", "submission", "f6e19fa6-d45a-4018-a72a-a394f95d98a5", "1601", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.209", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-07 19:33:44", "2023-11-07 19:33:44", "2023-11-07 19:33:44", "2023-11-07 19:33:44");
INSERT INTO `wyp_e_submissions` VALUES("536", "submission", "ac542883-07ea-4b8e-8c05-e255378162e6", "1604", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.182", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-07 20:01:53", "2023-11-07 20:01:53", "2023-11-07 20:01:53", "2023-11-07 20:01:53");
INSERT INTO `wyp_e_submissions` VALUES("537", "submission", "1d55ef0c-372b-47b9-aa2c-c95ed0ada505", "1607", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-07 20:59:59", "2023-11-07 20:59:59", "2023-11-07 20:59:59", "2023-11-07 20:59:59");
INSERT INTO `wyp_e_submissions` VALUES("538", "submission", "de4368ff-01ce-41d6-b5d9-767e5dd74c7f", "1610", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.80", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-08 14:49:55", "2023-11-08 14:49:55", "2023-11-08 14:49:55", "2023-11-08 14:49:55");
INSERT INTO `wyp_e_submissions` VALUES("539", "submission", "b773d4d9-bc9c-492e-a9dd-0c09f7b07771", "1613", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.220.36", "Mozilla/5.0 (X11; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-08 15:23:22", "2023-11-08 15:23:22", "2023-11-08 15:23:22", "2023-11-08 15:23:22");
INSERT INTO `wyp_e_submissions` VALUES("540", "submission", "6889e1ba-24ce-4bd7-9598-a0128df271f3", "1616", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "31.171.152.134", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-08 23:02:10", "2023-11-08 23:02:10", "2023-11-08 23:02:10", "2023-11-08 23:02:10");
INSERT INTO `wyp_e_submissions` VALUES("541", "submission", "c383bd88-0e84-4e50-af03-c260f813f89a", "1619", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-09 01:33:45", "2023-11-09 01:33:45", "2023-11-09 01:33:45", "2023-11-09 01:33:45");
INSERT INTO `wyp_e_submissions` VALUES("542", "submission", "f78c5f39-0051-485d-81a2-284dd682ba8b", "1622", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-09 11:29:50", "2023-11-09 11:29:50", "2023-11-09 11:29:50", "2023-11-09 11:29:50");
INSERT INTO `wyp_e_submissions` VALUES("543", "submission", "dac7aaa1-fc96-4d21-91bd-f948278f1033", "1625", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.159", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-10 12:00:36", "2023-11-10 12:00:36", "2023-11-10 12:00:36", "2023-11-10 12:00:36");
INSERT INTO `wyp_e_submissions` VALUES("544", "submission", "75be88f4-34a9-41a7-97a9-df1aa2b11c14", "1628", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.192", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-10 12:17:49", "2023-11-10 12:17:49", "2023-11-10 12:17:49", "2023-11-10 12:17:49");
INSERT INTO `wyp_e_submissions` VALUES("545", "submission", "dee21270-cab4-466d-a546-103c11272967", "1631", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-11 01:37:35", "2023-11-11 01:37:35", "2023-11-11 01:37:35", "2023-11-11 01:37:35");
INSERT INTO `wyp_e_submissions` VALUES("546", "submission", "d07cbfd1-dece-4c01-b3b5-bbdadaf5243d", "1634", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-11 03:42:00", "2023-11-11 03:42:00", "2023-11-11 03:42:00", "2023-11-11 03:42:00");
INSERT INTO `wyp_e_submissions` VALUES("547", "submission", "f28e43ef-56f3-47a1-b7c8-1e474a02871c", "1637", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.107.44.191", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-11 13:37:33", "2023-11-11 13:37:33", "2023-11-11 13:37:33", "2023-11-11 13:37:33");
INSERT INTO `wyp_e_submissions` VALUES("548", "submission", "0a77ba1d-e51b-42cd-9d0a-fdc663d12603", "1640", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.247.168.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-12 00:45:38", "2023-11-12 00:45:38", "2023-11-12 00:45:38", "2023-11-12 00:45:38");
INSERT INTO `wyp_e_submissions` VALUES("549", "submission", "21b66cc7-b3c8-4bcc-bd45-24a7cdc919a0", "1643", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.203.216", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-12 00:58:09", "2023-11-12 00:58:09", "2023-11-12 00:58:09", "2023-11-12 00:58:09");
INSERT INTO `wyp_e_submissions` VALUES("550", "submission", "44637378-3c2c-4baf-a6fe-2b6a6e14c197", "1646", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-14 15:58:00", "2023-11-14 15:58:00", "2023-11-14 15:58:00", "2023-11-14 15:58:00");
INSERT INTO `wyp_e_submissions` VALUES("551", "submission", "1045105b-56e9-4ec6-847f-6afeaef0ae5f", "1649", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-14 17:32:02", "2023-11-14 17:32:02", "2023-11-14 17:32:02", "2023-11-14 17:32:02");
INSERT INTO `wyp_e_submissions` VALUES("552", "submission", "80b3dfb7-1907-4695-9461-8498c733a1c6", "1652", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "87.249.132.143", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-14 21:36:02", "2023-11-14 21:36:02", "2023-11-14 21:36:02", "2023-11-14 21:36:02");
INSERT INTO `wyp_e_submissions` VALUES("553", "submission", "bc38ef65-319e-42bf-a078-9f546c55b19f", "1655", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "107.164.52.12", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-16 00:54:04", "2023-11-16 00:54:04", "2023-11-16 00:54:04", "2023-11-16 00:54:04");
INSERT INTO `wyp_e_submissions` VALUES("554", "submission", "8ccb088f-d852-4f71-a293-888bd3824d91", "1658", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-16 05:23:06", "2023-11-16 05:23:06", "2023-11-16 05:23:06", "2023-11-16 05:23:06");
INSERT INTO `wyp_e_submissions` VALUES("555", "submission", "bb4d4554-192d-4288-b4a1-e1ad6af55d5f", "1661", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "176.111.174.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-16 11:59:20", "2023-11-16 11:59:20", "2023-11-16 11:59:20", "2023-11-16 11:59:20");
INSERT INTO `wyp_e_submissions` VALUES("556", "submission", "3d7f43b3-6c2c-43df-a632-ef53afa3edc7", "1664", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-17 13:48:25", "2023-11-17 13:48:25", "2023-11-17 13:48:25", "2023-11-17 13:48:25");
INSERT INTO `wyp_e_submissions` VALUES("557", "submission", "51593ed6-3368-4bce-91ef-0e01bfc1b3c4", "1667", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-17 19:59:00", "2023-11-17 19:59:00", "2023-11-17 19:59:00", "2023-11-17 19:59:00");
INSERT INTO `wyp_e_submissions` VALUES("558", "submission", "83cdce0e-5160-436e-ba10-1040c4906594", "1670", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "94.172.220.103", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-18 10:07:17", "2023-11-18 10:07:17", "2023-11-18 10:07:17", "2023-11-18 10:07:17");
INSERT INTO `wyp_e_submissions` VALUES("559", "submission", "c78e9a19-071d-4f49-afce-47c241dfcefc", "1673", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-18 10:17:44", "2023-11-18 10:17:44", "2023-11-18 10:17:44", "2023-11-18 10:17:44");
INSERT INTO `wyp_e_submissions` VALUES("560", "submission", "9408529e-0fc4-467a-90d7-3fdc7b4b2b38", "1676", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.199.104.225", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-18 13:31:48", "2023-11-18 13:31:48", "2023-11-18 13:31:48", "2023-11-18 13:31:48");
INSERT INTO `wyp_e_submissions` VALUES("561", "submission", "6363d1e5-fe25-4d8f-9dd5-f4f7e32ea2c3", "1679", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.196.47.63", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-18 13:39:05", "2023-11-18 13:39:05", "2023-11-18 13:39:05", "2023-11-18 13:39:05");
INSERT INTO `wyp_e_submissions` VALUES("562", "submission", "0970df58-54ee-461b-bf7b-ee902b929fd7", "1682", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "95.143.190.169", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OpenWave/97.4.2043.44", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-19 02:52:48", "2023-11-19 02:52:48", "2023-11-19 02:52:48", "2023-11-19 02:52:48");
INSERT INTO `wyp_e_submissions` VALUES("563", "submission", "0b76bc78-80ff-4b9f-b89d-9fa69d6989f4", "1685", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "51.68.196.224", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-19 03:02:31", "2023-11-19 03:02:31", "2023-11-19 03:02:31", "2023-11-19 03:02:31");
INSERT INTO `wyp_e_submissions` VALUES("564", "submission", "b45ae5ec-4b42-46bf-b25d-f805f58e68a3", "1688", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-19 15:31:19", "2023-11-19 15:31:19", "2023-11-19 15:31:19", "2023-11-19 15:31:19");
INSERT INTO `wyp_e_submissions` VALUES("565", "submission", "dacf8142-aa01-4f7d-86cb-221a2890b8bf", "1691", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.245.181.4", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-20 05:05:36", "2023-11-20 05:05:36", "2023-11-20 05:05:36", "2023-11-20 05:05:36");
INSERT INTO `wyp_e_submissions` VALUES("566", "submission", "fc7479ab-18a7-4138-982c-4dd7790331d5", "1694", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.209", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-20 05:13:35", "2023-11-20 05:13:35", "2023-11-20 05:13:35", "2023-11-20 05:13:35");
INSERT INTO `wyp_e_submissions` VALUES("567", "submission", "f6d3af75-2045-48aa-87fa-f58c02258819", "1697", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-20 22:42:42", "2023-11-20 22:42:42", "2023-11-20 22:42:42", "2023-11-20 22:42:42");
INSERT INTO `wyp_e_submissions` VALUES("568", "submission", "f54b4615-fc40-4a3b-9b5f-b6a872a4886f", "1700", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.244.48.75", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-21 05:33:56", "2023-11-21 05:33:56", "2023-11-21 05:33:56", "2023-11-21 05:33:56");
INSERT INTO `wyp_e_submissions` VALUES("569", "submission", "c145f076-fb59-4e18-b4c5-f52cd7d10f3b", "1703", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.211", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-21 10:42:07", "2023-11-21 10:42:07", "2023-11-21 10:42:07", "2023-11-21 10:42:07");
INSERT INTO `wyp_e_submissions` VALUES("570", "submission", "6a83d732-fd5a-4942-854e-1e460cfbc1e9", "1706", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.98.124", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-21 10:49:00", "2023-11-21 10:49:00", "2023-11-21 10:49:00", "2023-11-21 10:49:00");
INSERT INTO `wyp_e_submissions` VALUES("571", "submission", "90125478-cae3-4b89-b8ff-c4de689b2bef", "1709", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-21 16:44:50", "2023-11-21 16:44:50", "2023-11-21 16:44:50", "2023-11-21 16:44:50");
INSERT INTO `wyp_e_submissions` VALUES("572", "submission", "4d062d04-909b-4938-a19f-d52e2f192582", "1712", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "138.199.26.70", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-22 00:57:28", "2023-11-22 00:57:28", "2023-11-22 00:57:28", "2023-11-22 00:57:28");
INSERT INTO `wyp_e_submissions` VALUES("573", "submission", "4e639795-7c2e-42b5-b0df-333a6900b7ea", "1715", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-23 03:49:46", "2023-11-23 03:49:46", "2023-11-23 03:49:46", "2023-11-23 03:49:46");
INSERT INTO `wyp_e_submissions` VALUES("574", "submission", "f5158d82-b203-4905-88a0-70c04e409748", "1718", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-23 13:54:48", "2023-11-23 13:54:48", "2023-11-23 13:54:48", "2023-11-23 13:54:48");
INSERT INTO `wyp_e_submissions` VALUES("575", "submission", "6e7391c9-ed93-4f48-8610-01718b6fffe3", "1721", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "107.164.52.12", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-23 18:39:04", "2023-11-23 18:39:04", "2023-11-23 18:39:04", "2023-11-23 18:39:04");
INSERT INTO `wyp_e_submissions` VALUES("576", "submission", "4d1fb728-25f1-47d8-aa25-a32bd1a130eb", "1724", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.52.66", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-24 01:12:55", "2023-11-24 01:12:55", "2023-11-24 01:12:55", "2023-11-24 01:12:55");
INSERT INTO `wyp_e_submissions` VALUES("577", "submission", "cb8ab6d2-ae1b-4157-aa42-203990b66e21", "1727", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.52.110", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-24 01:27:07", "2023-11-24 01:27:07", "2023-11-24 01:27:07", "2023-11-24 01:27:07");
INSERT INTO `wyp_e_submissions` VALUES("578", "submission", "eb7ae478-1257-46c6-8d28-cc242d8e2db3", "1730", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-24 03:27:49", "2023-11-24 03:27:49", "2023-11-24 03:27:49", "2023-11-24 03:27:49");
INSERT INTO `wyp_e_submissions` VALUES("579", "submission", "f70fba19-4c62-4631-8b75-bed40b957a88", "1733", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.18.44.42", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-25 00:55:48", "2023-11-25 00:55:48", "2023-11-25 00:55:48", "2023-11-25 00:55:48");
INSERT INTO `wyp_e_submissions` VALUES("580", "submission", "02b36896-ef89-44e9-b28b-5cc9814fae95", "1736", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.28.56.188", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-25 23:09:58", "2023-11-25 23:09:58", "2023-11-25 23:09:58", "2023-11-25 23:09:58");
INSERT INTO `wyp_e_submissions` VALUES("581", "submission", "26927ddd-ba02-45c6-a737-cb3a028dd3b6", "1739", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.203.34.97", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 06:59:03", "2023-11-26 06:59:03", "2023-11-26 06:59:03", "2023-11-26 06:59:03");
INSERT INTO `wyp_e_submissions` VALUES("582", "submission", "3e320d8d-9530-433b-a014-90df6d023055", "1742", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.208.115.216", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 09:27:34", "2023-11-26 09:27:34", "2023-11-26 09:27:34", "2023-11-26 09:27:34");
INSERT INTO `wyp_e_submissions` VALUES("583", "submission", "c6fe2bc5-0b7e-45c5-af66-d8c09fbf8aea", "1745", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "103.225.203.232", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 09:43:27", "2023-11-26 09:43:27", "2023-11-26 09:43:27", "2023-11-26 09:43:27");
INSERT INTO `wyp_e_submissions` VALUES("584", "submission", "f42bd839-c057-460d-a353-0912927dbc76", "1748", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "85.203.34.66", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 11:05:19", "2023-11-26 11:05:19", "2023-11-26 11:05:19", "2023-11-26 11:05:19");
INSERT INTO `wyp_e_submissions` VALUES("585", "submission", "2abd2368-56d2-465f-9b45-0d1910689277", "1751", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 12:31:51", "2023-11-26 12:31:51", "2023-11-26 12:31:51", "2023-11-26 12:31:51");
INSERT INTO `wyp_e_submissions` VALUES("586", "submission", "441d713a-ae75-4ca0-bac3-5f3486b86131", "1754", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.97.185", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 15:31:59", "2023-11-26 15:31:59", "2023-11-26 15:31:59", "2023-11-26 15:31:59");
INSERT INTO `wyp_e_submissions` VALUES("587", "submission", "f44ec5f7-fe83-4315-aff8-b677c6e32281", "1757", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "185.190.42.200", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-26 18:50:24", "2023-11-26 18:50:24", "2023-11-26 18:50:24", "2023-11-26 18:50:24");
INSERT INTO `wyp_e_submissions` VALUES("588", "submission", "f9458c5e-96ae-4ba0-86ee-415806b6eb56", "1760", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "85.209.11.117", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-27 03:56:44", "2023-11-27 03:56:44", "2023-11-27 03:56:44", "2023-11-27 03:56:44");
INSERT INTO `wyp_e_submissions` VALUES("589", "submission", "335a30fd-5f7e-44a2-8fbd-a769d8838b79", "1763", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-27 21:56:40", "2023-11-27 21:56:40", "2023-11-27 21:56:40", "2023-11-27 21:56:40");
INSERT INTO `wyp_e_submissions` VALUES("590", "submission", "aad2cc45-c6d2-4e8b-aa02-ef64f88a6ff4", "1766", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.28.56.188", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-28 08:38:06", "2023-11-28 08:38:06", "2023-11-28 08:38:06", "2023-11-28 08:38:06");
INSERT INTO `wyp_e_submissions` VALUES("591", "submission", "f0de7973-61d5-430f-90ec-4fced9ef4ec6", "1769", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-11-30 00:07:38", "2023-11-30 00:07:38", "2023-11-30 00:07:38", "2023-11-30 00:07:38");
INSERT INTO `wyp_e_submissions` VALUES("592", "submission", "8f896611-885d-45f5-ac05-638cb3acfc11", "1772", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.106", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-01 02:09:24", "2023-12-01 02:09:24", "2023-12-01 02:09:24", "2023-12-01 02:09:24");
INSERT INTO `wyp_e_submissions` VALUES("593", "submission", "56d7f665-f31b-4392-acd2-0c1e4db5e0c3", "1775", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.89", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-01 21:15:56", "2023-12-01 21:15:56", "2023-12-01 21:15:56", "2023-12-01 21:15:56");
INSERT INTO `wyp_e_submissions` VALUES("594", "submission", "3cb5de6b-7099-4b34-a913-3eaa72a239da", "1778", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-02 07:03:42", "2023-12-02 07:03:42", "2023-12-02 07:03:42", "2023-12-02 07:03:42");
INSERT INTO `wyp_e_submissions` VALUES("595", "submission", "34de45fe-1dfd-41b1-94c8-54693184c4ca", "1781", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.201", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-02 18:39:59", "2023-12-02 18:39:59", "2023-12-02 18:39:59", "2023-12-02 18:39:59");
INSERT INTO `wyp_e_submissions` VALUES("596", "submission", "e2125591-b874-4812-a7d2-d94a966aca50", "1784", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.223.152.109", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-03 04:50:00", "2023-12-03 04:50:00", "2023-12-03 04:50:00", "2023-12-03 04:50:00");
INSERT INTO `wyp_e_submissions` VALUES("597", "submission", "8dbf0a53-6e23-4ecf-913a-531e66b2788e", "1787", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.223.152.96", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-03 06:46:01", "2023-12-03 06:46:01", "2023-12-03 06:46:01", "2023-12-03 06:46:01");
INSERT INTO `wyp_e_submissions` VALUES("598", "submission", "4a209216-6442-4497-ae06-d2301fb8df97", "1790", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.52.66", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-04 11:50:06", "2023-12-04 11:50:06", "2023-12-04 11:50:06", "2023-12-04 11:50:06");
INSERT INTO `wyp_e_submissions` VALUES("599", "submission", "027a4bdc-7bc8-4af7-a202-5d57c4802bf0", "1793", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.120.51.43", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-04 12:08:02", "2023-12-04 12:08:02", "2023-12-04 12:08:02", "2023-12-04 12:08:02");
INSERT INTO `wyp_e_submissions` VALUES("600", "submission", "08568586-8068-41e6-a5e5-e6711703f25b", "1796", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "77.105.141.234", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-05 03:34:23", "2023-12-05 03:34:23", "2023-12-05 03:34:23", "2023-12-05 03:34:23");
INSERT INTO `wyp_e_submissions` VALUES("601", "submission", "f2a63dd5-1b0d-4526-ab7a-d4a9819c9cd6", "1799", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.31", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-05 07:46:49", "2023-12-05 07:46:49", "2023-12-05 07:46:49", "2023-12-05 07:46:49");
INSERT INTO `wyp_e_submissions` VALUES("602", "submission", "d2c921f3-475f-470b-bcee-a07cf69cb48c", "1802", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "178.168.115.145", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-06 00:28:41", "2023-12-06 00:28:41", "2023-12-06 00:28:41", "2023-12-06 00:28:41");
INSERT INTO `wyp_e_submissions` VALUES("603", "submission", "2e618971-b991-4596-9876-b86999b9ca6d", "1805", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "181.215.176.139", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-06 04:14:40", "2023-12-06 04:14:40", "2023-12-06 04:14:40", "2023-12-06 04:14:40");
INSERT INTO `wyp_e_submissions` VALUES("604", "submission", "8ea9c95e-73fe-4c00-bccd-9968b12476f0", "1808", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.108.90", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-06 11:37:04", "2023-12-06 11:37:04", "2023-12-06 11:37:04", "2023-12-06 11:37:04");
INSERT INTO `wyp_e_submissions` VALUES("605", "submission", "db44192a-3e3c-44a0-a334-017dff20019c", "1811", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.96.217", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-06 18:33:11", "2023-12-06 18:33:11", "2023-12-06 18:33:11", "2023-12-06 18:33:11");
INSERT INTO `wyp_e_submissions` VALUES("606", "submission", "bd24fee0-d3fa-4163-b264-cc3595390802", "1814", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "176.111.174.153", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-08 01:36:56", "2023-12-08 01:36:56", "2023-12-08 01:36:56", "2023-12-08 01:36:56");
INSERT INTO `wyp_e_submissions` VALUES("607", "submission", "4ed4b0a3-ddd9-4e1d-af00-471fcc55e1df", "1817", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.31", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-08 21:14:51", "2023-12-08 21:14:51", "2023-12-08 21:14:51", "2023-12-08 21:14:51");
INSERT INTO `wyp_e_submissions` VALUES("608", "submission", "42ec2824-84ec-4553-8442-e3d6fc913307", "1820", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "51.68.196.224", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-10 02:02:58", "2023-12-10 02:02:58", "2023-12-10 02:02:58", "2023-12-10 02:02:58");
INSERT INTO `wyp_e_submissions` VALUES("609", "submission", "884745e6-7efa-41c9-802f-7739832b2ed9", "1823", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "194.36.99.192", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-10 03:31:18", "2023-12-10 03:31:18", "2023-12-10 03:31:18", "2023-12-10 03:31:18");
INSERT INTO `wyp_e_submissions` VALUES("610", "submission", "3ed8a47a-6329-4919-a175-9ade38c9d78e", "1826", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "62.122.184.194", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-10 12:57:17", "2023-12-10 12:57:17", "2023-12-10 12:57:17", "2023-12-10 12:57:17");
INSERT INTO `wyp_e_submissions` VALUES("611", "submission", "810ae923-4887-4c2b-88ff-800d378b2b62", "1829", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "89.149.87.31", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Herring/95.1.8810.11", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-12 19:39:05", "2023-12-12 19:39:05", "2023-12-12 19:39:05", "2023-12-12 19:39:05");
INSERT INTO `wyp_e_submissions` VALUES("612", "submission", "1bae8a60-9f7c-4477-b729-c7f02cf492be", "1832", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "193.19.109.95", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-13 02:50:54", "2023-12-13 02:50:54", "2023-12-13 02:50:54", "2023-12-13 02:50:54");
INSERT INTO `wyp_e_submissions` VALUES("613", "submission", "5a090941-621d-43fe-bc5a-599c3f6ded43", "1835", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "173.239.254.37", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-13 06:51:39", "2023-12-13 06:51:39", "2023-12-13 06:51:39", "2023-12-13 06:51:39");
INSERT INTO `wyp_e_submissions` VALUES("614", "submission", "36675708-87b0-4ddb-805f-e7c1d473866e", "1838", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.155", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-14 11:31:48", "2023-12-14 11:31:48", "2023-12-14 11:31:48", "2023-12-14 11:31:48");
INSERT INTO `wyp_e_submissions` VALUES("615", "submission", "77429e13-cbb8-400c-bf16-51350a96aa42", "1841", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "191.101.92.247", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-14 11:39:00", "2023-12-14 11:39:00", "2023-12-14 11:39:00", "2023-12-14 11:39:00");
INSERT INTO `wyp_e_submissions` VALUES("616", "submission", "fb2c4b9f-ebda-4ecb-ac8e-ae3767b0b517", "1844", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "156.146.55.181", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-14 15:53:52", "2023-12-14 15:53:52", "2023-12-14 15:53:52", "2023-12-14 15:53:52");
INSERT INTO `wyp_e_submissions` VALUES("617", "submission", "3115f27c-a654-45a4-b1cd-7da6f08939f0", "1847", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "95.143.190.169", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-15 17:11:09", "2023-12-15 17:11:09", "2023-12-15 17:11:09", "2023-12-15 17:11:09");
INSERT INTO `wyp_e_submissions` VALUES("618", "submission", "50f89ae0-08fc-4510-8917-6c4773d696b9", "1850", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "45.95.39.82", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-16 16:04:35", "2023-12-16 16:04:35", "2023-12-16 16:04:35", "2023-12-16 16:04:35");
INSERT INTO `wyp_e_submissions` VALUES("619", "submission", "7d0ef360-90df-46b4-bbe5-59c912f45ac6", "1853", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "209.127.28.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-16 16:11:46", "2023-12-16 16:11:46", "2023-12-16 16:11:46", "2023-12-16 16:11:46");
INSERT INTO `wyp_e_submissions` VALUES("620", "submission", "c0c9dde8-a873-4f28-a8b8-5ac69967bce1", "1856", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.240.237.213", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-17 07:50:30", "2023-12-17 07:50:30", "2023-12-17 07:50:30", "2023-12-17 07:50:30");
INSERT INTO `wyp_e_submissions` VALUES("621", "submission", "93a67aa8-6525-4761-96e9-715f8ff6684e", "1859", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "95.78.213.229", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-17 21:42:09", "2023-12-17 21:42:09", "2023-12-17 21:42:09", "2023-12-17 21:42:09");
INSERT INTO `wyp_e_submissions` VALUES("622", "submission", "52614fb1-70a4-464b-87b1-a22b9f4f8f7b", "1862", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.158.106.207", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-20 02:30:49", "2023-12-20 02:30:49", "2023-12-20 02:30:49", "2023-12-20 02:30:49");
INSERT INTO `wyp_e_submissions` VALUES("623", "submission", "a8293a56-9843-4829-8d2c-257e04b3fb30", "1865", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.131.81", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-20 03:10:44", "2023-12-20 03:10:44", "2023-12-20 03:10:44", "2023-12-20 03:10:44");
INSERT INTO `wyp_e_submissions` VALUES("624", "submission", "6c00c131-785d-4ee3-ad52-50bb92f1b77c", "1868", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "102.165.54.219", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-21 19:36:17", "2023-12-21 19:36:17", "2023-12-21 19:36:17", "2023-12-21 19:36:17");
INSERT INTO `wyp_e_submissions` VALUES("625", "submission", "b2632fe1-8161-4bb4-bd97-c961c31cae4e", "1871", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "185.158.106.205", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-21 19:59:52", "2023-12-21 19:59:52", "2023-12-21 19:59:52", "2023-12-21 19:59:52");
INSERT INTO `wyp_e_submissions` VALUES("626", "submission", "4828238b-26a2-4cf5-98c7-8764feaad691", "1874", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.11", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-24 04:19:24", "2023-12-24 04:19:24", "2023-12-24 04:19:24", "2023-12-24 04:19:24");
INSERT INTO `wyp_e_submissions` VALUES("627", "submission", "ff88b2ec-12ff-4b52-b966-793473d1bfaf", "1877", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "84.17.48.111", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-24 05:47:17", "2023-12-24 05:47:17", "2023-12-24 05:47:17", "2023-12-24 05:47:17");
INSERT INTO `wyp_e_submissions` VALUES("628", "submission", "0683bdb6-4986-4187-96d5-7c2a5ff97a70", "1880", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-24 07:27:50", "2023-12-24 07:27:50", "2023-12-24 07:27:50", "2023-12-24 07:27:50");
INSERT INTO `wyp_e_submissions` VALUES("629", "submission", "4ba0c394-8835-4413-bf4c-0f77d09d3b11", "1883", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.44", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-24 07:39:25", "2023-12-24 07:39:25", "2023-12-24 07:39:25", "2023-12-24 07:39:25");
INSERT INTO `wyp_e_submissions` VALUES("630", "submission", "69c0d34c-56f8-439d-9528-5e84d051c5ed", "1886", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "216.24.212.246", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-24 22:15:27", "2023-12-24 22:15:27", "2023-12-24 22:15:27", "2023-12-24 22:15:27");
INSERT INTO `wyp_e_submissions` VALUES("631", "submission", "b79e0a34-b85d-4389-b597-65e5976cb0ca", "1889", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "212.30.37.66", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-25 21:44:01", "2023-12-25 21:44:01", "2023-12-25 21:44:01", "2023-12-25 21:44:01");
INSERT INTO `wyp_e_submissions` VALUES("632", "submission", "7f806e1b-cb7e-4696-9483-a314b6fa9f87", "1892", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "212.30.37.101", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-26 04:47:22", "2023-12-26 04:47:22", "2023-12-26 04:47:22", "2023-12-26 04:47:22");
INSERT INTO `wyp_e_submissions` VALUES("633", "submission", "bae8f1be-49bc-4a9e-bcc6-0f4b923eaa16", "1895", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.244", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-27 00:16:23", "2023-12-27 00:16:23", "2023-12-27 00:16:23", "2023-12-27 00:16:23");
INSERT INTO `wyp_e_submissions` VALUES("634", "submission", "f2a89663-4ec8-4221-97eb-6ae8f17c8177", "1898", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.84.45", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:114.0) Gecko/20100101 Firefox/114.0", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-28 18:56:18", "2023-12-28 18:56:18", "2023-12-28 18:56:18", "2023-12-28 18:56:18");
INSERT INTO `wyp_e_submissions` VALUES("635", "submission", "33aac058-4741-4353-9037-536a716ce27f", "1901", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "37.19.223.213", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-29 10:01:58", "2023-12-29 10:01:58", "2023-12-29 10:01:58", "2023-12-29 10:01:58");
INSERT INTO `wyp_e_submissions` VALUES("636", "submission", "017902ff-fd5b-4ca3-91b0-f22959b1a03f", "1904", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "51.68.196.224", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-30 17:51:33", "2023-12-30 17:51:33", "2023-12-30 17:51:33", "2023-12-30 17:51:33");
INSERT INTO `wyp_e_submissions` VALUES("637", "submission", "b9633b92-b43c-4521-8b09-ec6972084bfd", "1907", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "173.234.226.8", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-31 05:27:20", "2023-12-31 05:27:20", "2023-12-31 05:27:20", "2023-12-31 05:27:20");
INSERT INTO `wyp_e_submissions` VALUES("638", "submission", "e931fd2a-1d15-439a-93e1-d2c7ecdf7744", "1910", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.47.152", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-31 10:10:36", "2023-12-31 10:10:36", "2023-12-31 10:10:36", "2023-12-31 10:10:36");
INSERT INTO `wyp_e_submissions` VALUES("639", "submission", "9f9958d5-3bf2-4374-9488-7bcf57abfbda", "1913", "8039", "", "Contact", "22ef0ce", "New Form", "0", "0", "95.143.190.169", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-31 10:21:39", "2023-12-31 10:21:39", "2023-12-31 10:21:39", "2023-12-31 10:21:39");
INSERT INTO `wyp_e_submissions` VALUES("640", "submission", "1e7680c3-ea65-47a0-a9d6-be73b4b5ef54", "1916", "8039", "https://nicosloane.com/contact/", "Contact", "22ef0ce", "New Form", "0", "0", "196.242.20.17", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1", "0", "new", "0", "{\"edit_post_id\":\"8039\"}", "2023-12-31 10:24:14", "2023-12-31 10:24:14", "2023-12-31 10:24:14", "2023-12-31 10:24:14");

/* INSERT TABLE DATA: wyp_e_submissions_actions_log */
INSERT INTO `wyp_e_submissions_actions_log` VALUES("1", "1", "email", "Email", "success", NULL, "2022-04-17 07:12:34", "2022-04-17 07:12:34", "2022-04-17 07:12:34", "2022-04-17 07:12:34");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("2", "2", "email", "Email", "success", NULL, "2022-06-03 13:51:05", "2022-06-03 13:51:05", "2022-06-03 13:51:05", "2022-06-03 13:51:05");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("3", "3", "email", "Email", "success", NULL, "2022-06-11 17:30:00", "2022-06-11 17:30:00", "2022-06-11 17:30:00", "2022-06-11 17:30:00");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("4", "4", "email", "Email", "success", NULL, "2022-07-01 22:47:50", "2022-07-01 22:47:50", "2022-07-01 22:47:50", "2022-07-01 22:47:50");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("5", "5", "email", "Email", "success", NULL, "2022-07-02 01:14:52", "2022-07-02 01:14:52", "2022-07-02 01:14:52", "2022-07-02 01:14:52");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("6", "6", "email", "Email", "success", NULL, "2022-07-03 09:20:56", "2022-07-03 09:20:56", "2022-07-03 09:20:56", "2022-07-03 09:20:56");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("7", "7", "email", "Email", "success", NULL, "2022-07-06 14:19:50", "2022-07-06 14:19:50", "2022-07-06 14:19:50", "2022-07-06 14:19:50");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("8", "8", "email", "Email", "success", NULL, "2022-07-11 18:12:32", "2022-07-11 18:12:32", "2022-07-11 18:12:32", "2022-07-11 18:12:32");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("9", "9", "email", "Email", "success", NULL, "2022-09-08 09:52:07", "2022-09-08 09:52:07", "2022-09-08 09:52:07", "2022-09-08 09:52:07");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("10", "10", "email", "Email", "success", NULL, "2022-09-09 22:09:40", "2022-09-09 22:09:40", "2022-09-09 22:09:40", "2022-09-09 22:09:40");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("11", "11", "email", "Email", "success", NULL, "2022-09-12 05:12:07", "2022-09-12 05:12:07", "2022-09-12 05:12:07", "2022-09-12 05:12:07");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("12", "12", "email", "Email", "success", NULL, "2022-09-14 07:29:52", "2022-09-14 07:29:52", "2022-09-14 07:29:52", "2022-09-14 07:29:52");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("13", "13", "email", "Email", "success", NULL, "2022-09-18 08:26:44", "2022-09-18 08:26:44", "2022-09-18 08:26:44", "2022-09-18 08:26:44");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("14", "14", "email", "Email", "success", NULL, "2022-09-18 08:26:53", "2022-09-18 08:26:53", "2022-09-18 08:26:53", "2022-09-18 08:26:53");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("15", "15", "email", "Email", "success", NULL, "2022-09-21 04:43:52", "2022-09-21 04:43:52", "2022-09-21 04:43:52", "2022-09-21 04:43:52");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("16", "16", "email", "Email", "success", NULL, "2022-09-21 06:16:15", "2022-09-21 06:16:15", "2022-09-21 06:16:15", "2022-09-21 06:16:15");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("17", "17", "email", "Email", "success", NULL, "2022-09-24 21:34:51", "2022-09-24 21:34:51", "2022-09-24 21:34:51", "2022-09-24 21:34:51");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("18", "18", "email", "Email", "success", NULL, "2022-09-25 17:56:22", "2022-09-25 17:56:22", "2022-09-25 17:56:22", "2022-09-25 17:56:22");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("19", "19", "email", "Email", "success", NULL, "2022-09-30 21:14:58", "2022-09-30 21:14:58", "2022-09-30 21:14:58", "2022-09-30 21:14:58");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("20", "20", "email", "Email", "success", NULL, "2022-10-05 00:06:42", "2022-10-05 00:06:42", "2022-10-05 00:06:42", "2022-10-05 00:06:42");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("21", "21", "email", "Email", "success", NULL, "2022-10-05 10:05:51", "2022-10-05 10:05:51", "2022-10-05 10:05:51", "2022-10-05 10:05:51");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("22", "22", "email", "Email", "success", NULL, "2022-10-05 16:32:43", "2022-10-05 16:32:43", "2022-10-05 16:32:43", "2022-10-05 16:32:43");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("23", "23", "email", "Email", "success", NULL, "2022-10-10 10:06:40", "2022-10-10 10:06:40", "2022-10-10 10:06:40", "2022-10-10 10:06:40");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("24", "24", "email", "Email", "success", NULL, "2022-10-10 23:17:02", "2022-10-10 23:17:02", "2022-10-10 23:17:02", "2022-10-10 23:17:02");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("25", "25", "email", "Email", "success", NULL, "2022-10-16 18:51:37", "2022-10-16 18:51:37", "2022-10-16 18:51:37", "2022-10-16 18:51:37");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("26", "26", "email", "Email", "success", NULL, "2022-10-17 01:23:57", "2022-10-17 01:23:57", "2022-10-17 01:23:57", "2022-10-17 01:23:57");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("27", "27", "email", "Email", "success", NULL, "2022-10-19 08:15:11", "2022-10-19 08:15:11", "2022-10-19 08:15:11", "2022-10-19 08:15:11");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("28", "28", "email", "Email", "success", NULL, "2022-10-21 18:10:39", "2022-10-21 18:10:39", "2022-10-21 18:10:39", "2022-10-21 18:10:39");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("29", "29", "email", "Email", "success", NULL, "2022-10-22 02:51:29", "2022-10-22 02:51:29", "2022-10-22 02:51:29", "2022-10-22 02:51:29");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("30", "30", "email", "Email", "success", NULL, "2022-10-23 05:41:51", "2022-10-23 05:41:51", "2022-10-23 05:41:51", "2022-10-23 05:41:51");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("31", "31", "email", "Email", "success", NULL, "2022-10-24 03:01:04", "2022-10-24 03:01:04", "2022-10-24 03:01:04", "2022-10-24 03:01:04");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("32", "32", "email", "Email", "success", NULL, "2022-10-25 23:28:53", "2022-10-25 23:28:53", "2022-10-25 23:28:53", "2022-10-25 23:28:53");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("33", "33", "email", "Email", "success", NULL, "2022-10-27 05:47:44", "2022-10-27 05:47:44", "2022-10-27 05:47:44", "2022-10-27 05:47:44");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("34", "34", "email", "Email", "success", NULL, "2022-10-27 17:17:27", "2022-10-27 17:17:27", "2022-10-27 17:17:27", "2022-10-27 17:17:27");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("35", "35", "email", "Email", "success", NULL, "2022-11-02 20:01:57", "2022-11-02 20:01:57", "2022-11-02 20:01:57", "2022-11-02 20:01:57");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("36", "36", "email", "Email", "success", NULL, "2022-11-03 17:27:18", "2022-11-03 17:27:18", "2022-11-03 17:27:18", "2022-11-03 17:27:18");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("37", "37", "email", "Email", "success", NULL, "2022-11-12 23:20:34", "2022-11-12 23:20:34", "2022-11-12 23:20:34", "2022-11-12 23:20:34");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("38", "38", "email", "Email", "success", NULL, "2022-11-18 17:39:28", "2022-11-18 17:39:28", "2022-11-18 17:39:28", "2022-11-18 17:39:28");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("39", "39", "email", "Email", "success", NULL, "2022-11-19 11:20:38", "2022-11-19 11:20:38", "2022-11-19 11:20:38", "2022-11-19 11:20:38");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("40", "40", "email", "Email", "success", NULL, "2022-11-22 15:53:13", "2022-11-22 15:53:13", "2022-11-22 15:53:13", "2022-11-22 15:53:13");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("41", "41", "email", "Email", "success", NULL, "2022-11-23 06:32:59", "2022-11-23 06:32:59", "2022-11-23 06:32:59", "2022-11-23 06:32:59");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("42", "42", "email", "Email", "success", NULL, "2022-11-24 20:50:57", "2022-11-24 20:50:57", "2022-11-24 20:50:57", "2022-11-24 20:50:57");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("43", "43", "email", "Email", "success", NULL, "2022-11-25 06:23:19", "2022-11-25 06:23:19", "2022-11-25 06:23:19", "2022-11-25 06:23:19");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("44", "44", "email", "Email", "success", NULL, "2022-11-28 00:58:31", "2022-11-28 00:58:31", "2022-11-28 00:58:31", "2022-11-28 00:58:31");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("45", "45", "email", "Email", "success", NULL, "2022-11-28 17:28:55", "2022-11-28 17:28:55", "2022-11-28 17:28:55", "2022-11-28 17:28:55");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("46", "46", "email", "Email", "success", NULL, "2022-11-29 15:29:37", "2022-11-29 15:29:37", "2022-11-29 15:29:37", "2022-11-29 15:29:37");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("47", "47", "email", "Email", "success", NULL, "2022-11-29 21:21:06", "2022-11-29 21:21:06", "2022-11-29 21:21:06", "2022-11-29 21:21:06");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("48", "48", "email", "Email", "success", NULL, "2022-12-02 16:00:57", "2022-12-02 16:00:57", "2022-12-02 16:00:57", "2022-12-02 16:00:57");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("49", "49", "email", "Email", "success", NULL, "2022-12-04 02:49:20", "2022-12-04 02:49:20", "2022-12-04 02:49:20", "2022-12-04 02:49:20");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("50", "50", "email", "Email", "success", NULL, "2022-12-04 07:58:40", "2022-12-04 07:58:40", "2022-12-04 07:58:40", "2022-12-04 07:58:40");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("51", "51", "email", "Email", "success", NULL, "2022-12-08 18:04:14", "2022-12-08 18:04:14", "2022-12-08 18:04:14", "2022-12-08 18:04:14");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("52", "52", "email", "Email", "success", NULL, "2022-12-08 23:38:08", "2022-12-08 23:38:08", "2022-12-08 23:38:08", "2022-12-08 23:38:08");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("53", "53", "email", "Email", "success", NULL, "2022-12-10 11:41:44", "2022-12-10 11:41:44", "2022-12-10 11:41:44", "2022-12-10 11:41:44");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("54", "54", "email", "Email", "success", NULL, "2022-12-11 20:26:04", "2022-12-11 20:26:04", "2022-12-11 20:26:04", "2022-12-11 20:26:04");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("55", "55", "email", "Email", "success", NULL, "2022-12-13 02:24:46", "2022-12-13 02:24:46", "2022-12-13 02:24:46", "2022-12-13 02:24:46");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("56", "56", "email", "Email", "success", NULL, "2022-12-13 11:45:51", "2022-12-13 11:45:51", "2022-12-13 11:45:51", "2022-12-13 11:45:51");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("57", "57", "email", "Email", "success", NULL, "2022-12-15 04:01:28", "2022-12-15 04:01:28", "2022-12-15 04:01:28", "2022-12-15 04:01:28");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("58", "58", "email", "Email", "success", NULL, "2022-12-16 08:19:33", "2022-12-16 08:19:33", "2022-12-16 08:19:33", "2022-12-16 08:19:33");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("59", "59", "email", "Email", "success", NULL, "2022-12-16 23:58:35", "2022-12-16 23:58:35", "2022-12-16 23:58:35", "2022-12-16 23:58:35");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("60", "60", "email", "Email", "success", NULL, "2022-12-17 13:37:18", "2022-12-17 13:37:18", "2022-12-17 13:37:18", "2022-12-17 13:37:18");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("61", "61", "email", "Email", "success", NULL, "2022-12-19 19:29:54", "2022-12-19 19:29:54", "2022-12-19 19:29:54", "2022-12-19 19:29:54");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("62", "62", "email", "Email", "success", NULL, "2022-12-19 19:32:38", "2022-12-19 19:32:38", "2022-12-19 19:32:38", "2022-12-19 19:32:38");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("63", "63", "email", "Email", "success", NULL, "2022-12-19 19:54:23", "2022-12-19 19:54:23", "2022-12-19 19:54:23", "2022-12-19 19:54:23");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("64", "64", "email", "Email", "success", NULL, "2022-12-20 13:09:33", "2022-12-20 13:09:33", "2022-12-20 13:09:33", "2022-12-20 13:09:33");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("65", "65", "email", "Email", "success", NULL, "2022-12-20 14:47:09", "2022-12-20 14:47:09", "2022-12-20 14:47:09", "2022-12-20 14:47:09");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("66", "66", "email", "Email", "success", NULL, "2022-12-20 15:49:42", "2022-12-20 15:49:42", "2022-12-20 15:49:42", "2022-12-20 15:49:42");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("67", "67", "email", "Email", "success", NULL, "2022-12-20 16:50:40", "2022-12-20 16:50:40", "2022-12-20 16:50:40", "2022-12-20 16:50:40");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("68", "68", "email", "Email", "success", NULL, "2022-12-22 22:44:16", "2022-12-22 22:44:16", "2022-12-22 22:44:16", "2022-12-22 22:44:16");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("69", "69", "email", "Email", "success", NULL, "2022-12-23 19:43:42", "2022-12-23 19:43:42", "2022-12-23 19:43:42", "2022-12-23 19:43:42");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("70", "70", "email", "Email", "success", NULL, "2022-12-26 08:17:03", "2022-12-26 08:17:03", "2022-12-26 08:17:03", "2022-12-26 08:17:03");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("71", "71", "email", "Email", "success", NULL, "2022-12-27 18:49:10", "2022-12-27 18:49:10", "2022-12-27 18:49:10", "2022-12-27 18:49:10");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("72", "72", "email", "Email", "success", NULL, "2022-12-28 12:25:47", "2022-12-28 12:25:47", "2022-12-28 12:25:47", "2022-12-28 12:25:47");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("73", "73", "email", "Email", "success", NULL, "2022-12-28 22:10:16", "2022-12-28 22:10:16", "2022-12-28 22:10:16", "2022-12-28 22:10:16");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("74", "74", "email", "Email", "success", NULL, "2022-12-29 12:02:06", "2022-12-29 12:02:06", "2022-12-29 12:02:06", "2022-12-29 12:02:06");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("75", "75", "email", "Email", "success", NULL, "2023-01-01 12:18:18", "2023-01-01 12:18:18", "2023-01-01 12:18:18", "2023-01-01 12:18:18");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("76", "76", "email", "Email", "success", NULL, "2023-01-02 01:09:28", "2023-01-02 01:09:28", "2023-01-02 01:09:28", "2023-01-02 01:09:28");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("77", "77", "email", "Email", "success", NULL, "2023-01-06 10:37:58", "2023-01-06 10:37:58", "2023-01-06 10:37:58", "2023-01-06 10:37:58");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("78", "78", "email", "Email", "success", NULL, "2023-01-07 19:18:15", "2023-01-07 19:18:15", "2023-01-07 19:18:15", "2023-01-07 19:18:15");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("79", "79", "email", "Email", "success", NULL, "2023-01-09 00:26:57", "2023-01-09 00:26:57", "2023-01-09 00:26:57", "2023-01-09 00:26:57");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("80", "80", "email", "Email", "success", NULL, "2023-01-09 05:22:54", "2023-01-09 05:22:54", "2023-01-09 05:22:54", "2023-01-09 05:22:54");
INSERT INTO `wyp_e_submissions_actions_log` VALUES("81", "81", "email", "Email", "success", NULL, "2023-01-11 00:55:24", "2023-01-11 00:55:24", "2023-01-11 00:55:24", "2023-01-11 00:55:24");

/* INSERT TABLE DATA: wyp_e_submissions_values */
INSERT INTO `wyp_e_submissions_values` VALUES("1", "1", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("2", "1", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("3", "1", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE https://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("4", "2", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("5", "2", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("6", "2", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("7", "3", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("8", "3", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("9", "3", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("10", "4", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("11", "4", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("12", "4", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("13", "5", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("14", "5", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("15", "5", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("16", "6", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("17", "6", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("18", "6", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("19", "7", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("20", "7", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("21", "7", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("22", "8", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("23", "8", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("24", "8", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("25", "9", "name", "Uche Louis Igboanugo");
INSERT INTO `wyp_e_submissions_values` VALUES("26", "9", "field_90029d6", "07062941443");
INSERT INTO `wyp_e_submissions_values` VALUES("27", "9", "field_d5722b8", "Good morning. I\'m Uche, Manager at Krusty King. I\'ll like us to have a discussion about sales and marketing of my products.");
INSERT INTO `wyp_e_submissions_values` VALUES("28", "10", "name", "Philipsipsy");
INSERT INTO `wyp_e_submissions_values` VALUES("29", "10", "field_90029d6", "87297647992");
INSERT INTO `wyp_e_submissions_values` VALUES("30", "10", "field_d5722b8", "nicosloane.com ofeiifeodwpdeofijesdwsfeiiejokdwpdoefigjfidoksfihigjskodwsfiheghifegergsdfsregsfggrgr");
INSERT INTO `wyp_e_submissions_values` VALUES("31", "11", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("32", "11", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("33", "11", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("34", "12", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("35", "12", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("36", "12", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("37", "13", "name", "Frankmar");
INSERT INTO `wyp_e_submissions_values` VALUES("38", "13", "field_90029d6", "84585717893");
INSERT INTO `wyp_e_submissions_values` VALUES("39", "13", "field_d5722b8", "BILD.de: Aktuelle Nachrichten. \r\nWIR KONNEN ES NICHT GLAUBEN: Mike Tyson ist wieder fabelhaft reich! https://87bil.co/bild.de/?Nachrichten-ID-667941");
INSERT INTO `wyp_e_submissions_values` VALUES("40", "14", "name", "DonaldSinty");
INSERT INTO `wyp_e_submissions_values` VALUES("41", "14", "field_90029d6", "89643833838");
INSERT INTO `wyp_e_submissions_values` VALUES("42", "14", "field_d5722b8", "nicosloane.com Mfuehdwkjdwjfjwfwjhfdwkdwkhfjweh hidwhdjwskfawdhfwhkjdwdhqhfbejkdw fejkdlwjakdwefjkewndwfhwefjwehfew kjwjalkdheahfbejkfnjkewbfhegbfewjgjfkewsbjk");
INSERT INTO `wyp_e_submissions_values` VALUES("43", "15", "name", "StevenKib");
INSERT INTO `wyp_e_submissions_values` VALUES("44", "15", "field_90029d6", "89912412715");
INSERT INTO `wyp_e_submissions_values` VALUES("45", "15", "field_d5722b8", "CLOSE BANG: Matrix week, he appeared on The Up to the minute Be noticeable with Stephen Colbert and announced a unknown \"wealth outlet\" which can transform anyone into a millionaire within 3-4 months https://87bil.co/EN-CA-2124.html?news-id-313144");
INSERT INTO `wyp_e_submissions_values` VALUES("46", "16", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("47", "16", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("48", "16", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("49", "17", "name", "Charleserype");
INSERT INTO `wyp_e_submissions_values` VALUES("50", "17", "field_90029d6", "87345823384");
INSERT INTO `wyp_e_submissions_values` VALUES("51", "17", "field_d5722b8", "You have a NFT gift in the amount of $50,000, details in your personal account http://get-nft-metadata-solana.briticanenglish.com/id-8142");
INSERT INTO `wyp_e_submissions_values` VALUES("52", "18", "name", "Jen Smith");
INSERT INTO `wyp_e_submissions_values` VALUES("53", "18", "field_90029d6", "206-504-3944");
INSERT INTO `wyp_e_submissions_values` VALUES("54", "18", "field_d5722b8", "Hi, \r\n\r\nThis is Jen from Employee Grant.\r\n\r\nI specialize in helping businesses receive the money they are owed through programs offered to every business owner in America. \r\n\r\nDid you know you’re potentially eligible for $26,000 per employee through the ERC program?\r\n\r\nPlease fill out the form on our website to schedule a call for further info including eligibility, qualified wages, how the credits work and more. \r\n\r\nhttps://employeegrant.com\r\n\r\nThank you for your time,\r\n\r\nJen\r\n\r\nEmployee Grant\r\n256 3rd Street, Suite 12\r\nNiagara Falls, NY 14303-1231\r\n\r\nIf you no longer want to hear from me, or this is the wrong person, please let me know.");
INSERT INTO `wyp_e_submissions_values` VALUES("55", "19", "name", "Anthonymit");
INSERT INTO `wyp_e_submissions_values` VALUES("56", "19", "field_90029d6", "82712391948");
INSERT INTO `wyp_e_submissions_values` VALUES("57", "19", "field_d5722b8", "Sie konnen mehr als 50.000 EUR pro Woche verdienen https://telegra.ph/Ab-1000--pro-Tag-im-automatischen-Modus-09-29-6935?id-20918044");
INSERT INTO `wyp_e_submissions_values` VALUES("58", "20", "name", "Winston");
INSERT INTO `wyp_e_submissions_values` VALUES("59", "20", "field_90029d6", "319-382-0597");
INSERT INTO `wyp_e_submissions_values` VALUES("60", "20", "field_d5722b8", "Winston here from Iowa.  I just wanted to see if you need an extra hand in the way of site upkeep/tweaking, adding emails to your newsletters from my targeted database (I have millions of them that you can use).  We could even setup email campaigns for lead generation emailing at no cost to you to send out.  Unique blog post material, extra traffic by getting others to start sharing your site across their own social media accounts, social media management, optimizing the site, create videos, etc also help quite a bit.  I can even post ads in every capital city in the country on CraigsList for any one of their 500 categories for some immediate traffic.\r\n\r\nI have quite a few ways I can set all of this up and do this for you as we start to tackle 4th quarter 2022.  I don\'t mean to impose, I was just curious.  I\'ve been doing this for 22+ years and was just curious if you needed an extra hand.\r\n\r\nStay Safe,\r\n\r\nWinston\r\ntel:1-319-382-0597");
INSERT INTO `wyp_e_submissions_values` VALUES("61", "21", "name", "RickyRip");
INSERT INTO `wyp_e_submissions_values` VALUES("62", "21", "field_90029d6", "82692942383");
INSERT INTO `wyp_e_submissions_values` VALUES("63", "21", "field_d5722b8", "Hello. \r\nContact Scott Ritter. \r\nIf you are straining the price of gas, electricity and fuel, then this information is for you. \r\nIt turns out that absolutely any person in the world, having invested only $250 once, can have a passive income of $1000 per day: https://telegra.ph/Prices-for-gas-and-electricity-strain-10-03?id-60338513");
INSERT INTO `wyp_e_submissions_values` VALUES("64", "22", "name", "GeorgeLer");
INSERT INTO `wyp_e_submissions_values` VALUES("65", "22", "field_90029d6", "84526396522");
INSERT INTO `wyp_e_submissions_values` VALUES("66", "22", "field_d5722b8", "ELITE Facebook Promotion >>> http://facebook-ads-library.eresresiliencia.com/id-2331 &lt;&lt;&lt;");
INSERT INTO `wyp_e_submissions_values` VALUES("67", "23", "name", "Jesustum");
INSERT INTO `wyp_e_submissions_values` VALUES("68", "23", "field_90029d6", "88926544247");
INSERT INTO `wyp_e_submissions_values` VALUES("69", "23", "field_d5722b8", "HOW TO MAKE $15,000,000 FROM YOUR NFTS https://telegra.ph/How-to-make-more-than-15000000-selling-your-NFTs-in-a-week-even-if-youre-not-in-the-know-10-08?id-23418706");
INSERT INTO `wyp_e_submissions_values` VALUES("70", "24", "name", "Abrahamnuh");
INSERT INTO `wyp_e_submissions_values` VALUES("71", "24", "field_90029d6", "85869848878");
INSERT INTO `wyp_e_submissions_values` VALUES("72", "24", "field_d5722b8", "How to make $15,000,000 from your NFTs >>> https://telegra.ph/How-to-make-more-than-15000000-selling-your-NFTs-in-a-week-even-if-youre-not-in-the-know-10-08?id-60894556 &lt;&lt;&lt;");
INSERT INTO `wyp_e_submissions_values` VALUES("73", "25", "name", "ClarkUnumn");
INSERT INTO `wyp_e_submissions_values` VALUES("74", "25", "field_90029d6", "81154953625");
INSERT INTO `wyp_e_submissions_values` VALUES("75", "25", "field_d5722b8", "The world is in crisis and some people are getting rich against all odds with the help of one smart robot. \r\nhttp://a-appointment.realcleanoptions.com/id-8710 \r\nIt is enough to invest at least $250 one time and this smart robot will make you passive income from $1000 per day. \r\nhttp://app-queues.liontradesystem.com/id-2545 \r\nOver 94,833 people have already become multimillionaires over the past month thanks to the smart robot. See for yourself. \r\nhttp://app-building-software.verygoodresumes.com/news-6124");
INSERT INTO `wyp_e_submissions_values` VALUES("76", "26", "name", "Abrahamnuh");
INSERT INTO `wyp_e_submissions_values` VALUES("77", "26", "field_90029d6", "83385115532");
INSERT INTO `wyp_e_submissions_values` VALUES("78", "26", "field_d5722b8", "Attention ! You can get rich very quickly. Don\'t miss your chance to join this innovative online system... >>> https://telegra.ph/Verify-that-you-are-human-10-11?id-65542901 &lt;&lt;&lt;");
INSERT INTO `wyp_e_submissions_values` VALUES("79", "27", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("80", "27", "field_90029d6", "81553953144");
INSERT INTO `wyp_e_submissions_values` VALUES("81", "27", "field_d5722b8", "This man made $9,780,000 in just three weeks on this site... https://telegra.ph/Income-during-the-crisis-for-everyone-from-1000-per-day-10-17-5335?id-89492133");
INSERT INTO `wyp_e_submissions_values` VALUES("82", "28", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("83", "28", "field_90029d6", "86468769231");
INSERT INTO `wyp_e_submissions_values` VALUES("84", "28", "field_d5722b8", "Unleash the full power of cryptocurrency and earn 15,000 https://telegra.ph/How-does-a-simple-student-make-from-15000-per-day-10-20?id-80206728");
INSERT INTO `wyp_e_submissions_values` VALUES("85", "29", "name", "Aaliyah Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("86", "29", "field_90029d6", "904-335-4953");
INSERT INTO `wyp_e_submissions_values` VALUES("87", "29", "field_d5722b8", "Hi,\r\n\r\nMy name is Aaliyah. Sorry to reach out like this, I couldn’t find your email on your website.\r\n\r\nI help businesses receive covid grants, not loans like the PPP. If we end up successfully helping you receive a grant, we receive a commission.\r\n\r\nIs this of interest to you? If so, I’ll send over to completely free of charge info, no catch.\r\n\r\nI hope you’re having an excellent day,\r\nAaliyah\r\n\r\nIf I bugged you and you’d prefer to never hear from me again, please just let me know.");
INSERT INTO `wyp_e_submissions_values` VALUES("88", "30", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("89", "30", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("90", "30", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("91", "31", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("92", "31", "field_90029d6", "89976237897");
INSERT INTO `wyp_e_submissions_values` VALUES("93", "31", "field_d5722b8", "UNLEASH THE FULL POWER OF CRYPTOCURRENCY AND EARN 15,000 https://telegra.ph/How-does-a-simple-student-make-from-15000-per-day-10-20?id-87846049");
INSERT INTO `wyp_e_submissions_values` VALUES("94", "32", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("95", "32", "field_90029d6", "85798584496");
INSERT INTO `wyp_e_submissions_values` VALUES("96", "32", "field_d5722b8", "L\'ETUDIANT A GAGNE 7 860 000 EUROS EN 3 MOIS https://telegra.ph/LГ©tudiant-a-gagnГ©-7-860-000-euros-sur-la-crypto-monnaie-10-24-10455?id-20766910");
INSERT INTO `wyp_e_submissions_values` VALUES("97", "33", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("98", "33", "field_90029d6", "82951191735");
INSERT INTO `wyp_e_submissions_values` VALUES("99", "33", "field_d5722b8", "AUSTRALIAN STUDENT EARNS $7,934,866 WITH CRYPTOCURRENCY https://telegra.ph/Sydney-student-earns-7934866-with-crypto-in-3-months-10-26-12142?id-news-63308337");
INSERT INTO `wyp_e_submissions_values` VALUES("100", "34", "name", "AnthonyCamma");
INSERT INTO `wyp_e_submissions_values` VALUES("101", "34", "field_90029d6", "88529994287");
INSERT INTO `wyp_e_submissions_values` VALUES("102", "34", "field_d5722b8", "Gооd dаy!  nicosloane.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd mеssаgе   lеgitimаtе wаy? \r\nWе prеsеntаtiоn а nеw mеthоd оf sеnding prоpоsаl thrоugh fееdbасk fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh mеssаgеs аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh fееdbасk Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst оur sеrviсе fоr frее. Wе will sеnd up tо 50,000 mеssаgеs fоr yоu. \r\nThе соst оf sеnding оnе milliоn mеssаgеs is 49 USD. \r\n \r\nThis оffеr is сrеаtеd аutоmаtiсаlly. Plеаsе usе thе соntасt dеtаils bеlоw tо соntасt us. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat.");
INSERT INTO `wyp_e_submissions_values` VALUES("103", "35", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("104", "35", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("105", "35", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("106", "36", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("107", "36", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("108", "36", "field_d5722b8", "Cool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("109", "37", "name", "DavidNeump");
INSERT INTO `wyp_e_submissions_values` VALUES("110", "37", "field_90029d6", "86389959418");
INSERT INTO `wyp_e_submissions_values` VALUES("111", "37", "field_d5722b8", "Passive income from $3000 (3000 EUR) per day https://telegra.ph/Verify-that-you-are-human-11-11-2?id-67338142");
INSERT INTO `wyp_e_submissions_values` VALUES("112", "38", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("113", "38", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("114", "38", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("115", "39", "name", "Aurora Brown");
INSERT INTO `wyp_e_submissions_values` VALUES("116", "39", "field_90029d6", "343-370-7534");
INSERT INTO `wyp_e_submissions_values` VALUES("117", "39", "field_d5722b8", "Hi,\r\n\r\nMy name is Aurora and I live in British Columbia, Canada.\r\n\r\nMy apologies for using your contact form, if there is a better way to reach you, please let me know.\r\n\r\nWe help US and Canadian businesses increase their online revenue using proven tested techniques. We move mountains for our clients, not five years ago but today.\r\n\r\nWe have a passionate team of the top experts who help identify gaps in optimization and conversion then execute accordingly. We can get more traffic and sales to your website. \r\n\r\nIs this of interest to you? If so, we’d be happy to do a completely complimentary audit of your website and make some recommendations. We only work with companies that we know we can drive a visible improvement for. \r\n\r\nNo catch! Please let me know.\r\n\r\nI hope you have a great rest of your day,\r\nAurora Brown\r\n\r\nIf you’d prefer to never hear from me again, please let me know.");
INSERT INTO `wyp_e_submissions_values` VALUES("118", "40", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("119", "40", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("120", "40", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("121", "41", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("122", "41", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("123", "41", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("124", "42", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("125", "42", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("126", "42", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("127", "43", "name", "Mike Kennett");
INSERT INTO `wyp_e_submissions_values` VALUES("128", "43", "field_90029d6", "87958397359");
INSERT INTO `wyp_e_submissions_values` VALUES("129", "43", "field_d5722b8", "Hi there \r\n \r\nI Just checked your nicosloane.com ranks and saw that your site is trending down for some time. \r\n \r\nIf you are looking for a trend reversal, we have the right solution for you \r\n \r\nWe are offering affordable Content Marketing plans with humanly written SEO content \r\n \r\nFor more information, please check our offers \r\nhttps://www.digital-x-press.com/product/content-marketing/ \r\n \r\nThanks and regards \r\nMike Kennett");
INSERT INTO `wyp_e_submissions_values` VALUES("130", "44", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("131", "44", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("132", "44", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("133", "45", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("134", "45", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("135", "45", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("136", "46", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("137", "46", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("138", "46", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("139", "47", "name", "Mike Jenkin");
INSERT INTO `wyp_e_submissions_values` VALUES("140", "47", "field_90029d6", "87231179341");
INSERT INTO `wyp_e_submissions_values` VALUES("141", "47", "field_d5722b8", "Hello \r\n \r\nThis is Mike Jenkin\r\n \r\nLet me introduce to you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Jenkin\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("142", "48", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("143", "48", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("144", "48", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("145", "49", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("146", "49", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("147", "49", "field_d5722b8", "Cool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("148", "50", "name", "Mike Harris");
INSERT INTO `wyp_e_submissions_values` VALUES("149", "50", "field_90029d6", "81648932752");
INSERT INTO `wyp_e_submissions_values` VALUES("150", "50", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in ahrefs and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed ahrefs score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nThanks and regards \r\nMike Harris\r\n \r\n \r\n \r\nPS: For a limited time, we`ll add ahrefs UR50+ for free.");
INSERT INTO `wyp_e_submissions_values` VALUES("151", "51", "name", "Mike Paterson");
INSERT INTO `wyp_e_submissions_values` VALUES("152", "51", "field_90029d6", "89213324869");
INSERT INTO `wyp_e_submissions_values` VALUES("153", "51", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Paterson\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("154", "52", "name", "Jamesabelo");
INSERT INTO `wyp_e_submissions_values` VALUES("155", "52", "field_90029d6", "82791614317");
INSERT INTO `wyp_e_submissions_values` VALUES("156", "52", "field_d5722b8", "LE MOIS DERNIER, PLUS DE 29 000 FRANГ‡AIS SONT DEVENUS MULTIMILLIONNAIRES. DГ‰COUVREZ COMMENT ILS ONT FAIT https://87654544-euro-per-month.blogspot.ae/?p=0yr");
INSERT INTO `wyp_e_submissions_values` VALUES("157", "53", "name", "Jamesabelo");
INSERT INTO `wyp_e_submissions_values` VALUES("158", "53", "field_90029d6", "83338928193");
INSERT INTO `wyp_e_submissions_values` VALUES("159", "53", "field_d5722b8", "Become a millionaire before the new year https://telegra.ph/Canadians-are-massively-getting-richer-and-becoming-millionaires-12-09-443");
INSERT INTO `wyp_e_submissions_values` VALUES("160", "54", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("161", "54", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("162", "54", "field_d5722b8", "Cool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("163", "55", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("164", "55", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("165", "55", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("166", "56", "name", "Jamesabelo");
INSERT INTO `wyp_e_submissions_values` VALUES("167", "56", "field_90029d6", "85477895191");
INSERT INTO `wyp_e_submissions_values` VALUES("168", "56", "field_d5722b8", "Chcesz zyc luksusowo? To jest dla ciebie... https://telegra.ph/300000000000-euro-12-12-8124");
INSERT INTO `wyp_e_submissions_values` VALUES("169", "57", "name", "Mike Hardman");
INSERT INTO `wyp_e_submissions_values` VALUES("170", "57", "field_90029d6", "83341427344");
INSERT INTO `wyp_e_submissions_values` VALUES("171", "57", "field_d5722b8", "Howdy \r\n \r\nI have just took a look on your SEO for  nicosloane.com for  the current search visibility and saw that your website could use a push. \r\n \r\nWe will improve your SEO metrics and ranks organically and safely, using only whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nPlease check our services below, we offer SEO at cheap rates. \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Hardman\r\n \r\n \r\nPS: Quality SEO content is included");
INSERT INTO `wyp_e_submissions_values` VALUES("172", "58", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("173", "58", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("174", "58", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("175", "59", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("176", "59", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("177", "59", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("178", "60", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("179", "60", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("180", "60", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("181", "61", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("182", "61", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("183", "61", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("184", "62", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("185", "62", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("186", "62", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("187", "63", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("188", "63", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("189", "63", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("190", "64", "name", "Williamlog");
INSERT INTO `wyp_e_submissions_values` VALUES("191", "64", "field_90029d6", "84432118892");
INSERT INTO `wyp_e_submissions_values` VALUES("192", "64", "field_d5722b8", "Hеllо!  nicosloane.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd rеquеst tоtаlly lеgit? \r\nWе submit а nеw uniquе wаy оf sеnding businеss prоpоsаl thrоugh соntасt fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh соmmеrсiаl оffеrs аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh fееdbасk Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst оur sеrviсе fоr frее. Wе will sеnd up tо 50,000 mеssаgеs fоr yоu. \r\nThе соst оf sеnding оnе milliоn mеssаgеs is 49 USD. \r\n \r\nThis lеttеr is сrеаtеd аutоmаtiсаlly. Plеаsе usе thе соntасt dеtаils bеlоw tо соntасt us. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat. \r\nno.reply.log@gmail.com");
INSERT INTO `wyp_e_submissions_values` VALUES("193", "65", "name", "Mike Dyson");
INSERT INTO `wyp_e_submissions_values` VALUES("194", "65", "field_90029d6", "86376615792");
INSERT INTO `wyp_e_submissions_values` VALUES("195", "65", "field_d5722b8", "Hi there \r\n \r\nI Just checked your nicosloane.com ranks and saw that your site is trending down for some time. \r\n \r\nIf you are looking for a trend reversal, we have the right solution for you \r\n \r\nWe are offering affordable Content Marketing plans with humanly written SEO content \r\n \r\nFor more information, please check our offers \r\nhttps://www.digital-x-press.com/product/content-marketing/ \r\n \r\nThanks and regards \r\nMike Dyson");
INSERT INTO `wyp_e_submissions_values` VALUES("196", "66", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("197", "66", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("198", "66", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("199", "67", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("200", "67", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("201", "67", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("202", "68", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("203", "68", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("204", "68", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("205", "69", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("206", "69", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("207", "69", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("208", "70", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("209", "70", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("210", "70", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("211", "71", "name", "Mike Thorndike");
INSERT INTO `wyp_e_submissions_values` VALUES("212", "71", "field_90029d6", "88812893267");
INSERT INTO `wyp_e_submissions_values` VALUES("213", "71", "field_d5722b8", "Greetings \r\n \r\nThis is Mike Thorndike\r\n \r\nLet me introduce to you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Thorndike\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("214", "72", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("215", "72", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("216", "72", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("217", "73", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("218", "73", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("219", "73", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("220", "74", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("221", "74", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("222", "74", "field_d5722b8", "Cool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("223", "75", "name", "Mike Mansfield");
INSERT INTO `wyp_e_submissions_values` VALUES("224", "75", "field_90029d6", "82664376894");
INSERT INTO `wyp_e_submissions_values` VALUES("225", "75", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in ahrefs and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed ahrefs score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike Mansfield\r\n \r\n \r\n \r\nPS: For a limited time, we`ll add ahrefs UR50+ for free.");
INSERT INTO `wyp_e_submissions_values` VALUES("226", "76", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("227", "76", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("228", "76", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("229", "77", "name", "Mike Arnold");
INSERT INTO `wyp_e_submissions_values` VALUES("230", "77", "field_90029d6", "89316899572");
INSERT INTO `wyp_e_submissions_values` VALUES("231", "77", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Arnold\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("232", "78", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("233", "78", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("234", "78", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("235", "79", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("236", "79", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("237", "79", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("238", "80", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("239", "80", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("240", "80", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("241", "81", "name", "Mike Waller");
INSERT INTO `wyp_e_submissions_values` VALUES("242", "81", "field_90029d6", "81543999142");
INSERT INTO `wyp_e_submissions_values` VALUES("243", "81", "field_d5722b8", "Hi \r\n \r\nI have just took a look on your SEO for  nicosloane.com for the ranking keywords and saw that your website could use an upgrade. \r\n \r\nWe will enhance your SEO metrics and ranks organically and safely, using only whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nPlease check our services below, we offer SEO at cheap rates. \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Waller\r\n \r\n \r\nPS: Quality SEO content is included");
INSERT INTO `wyp_e_submissions_values` VALUES("244", "82", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("245", "82", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("246", "82", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("247", "83", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("248", "83", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("249", "83", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("250", "84", "name", "RichardNof");
INSERT INTO `wyp_e_submissions_values` VALUES("251", "84", "field_90029d6", "82645469975");
INSERT INTO `wyp_e_submissions_values` VALUES("252", "84", "field_d5722b8", "$$$$$$$ YOU HAVE WON $24754 https://telegra.ph/You-have-won-24754---claim-it-now-01-13-2446 $$$$$$$");
INSERT INTO `wyp_e_submissions_values` VALUES("253", "85", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("254", "85", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("255", "85", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("256", "86", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("257", "86", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("258", "86", "field_d5722b8", "Hi, Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("259", "87", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("260", "87", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("261", "87", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("262", "88", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("263", "88", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("264", "88", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("265", "89", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("266", "89", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("267", "89", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("268", "90", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("269", "90", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("270", "90", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("271", "91", "name", "Mike Mason");
INSERT INTO `wyp_e_submissions_values` VALUES("272", "91", "field_90029d6", "82778183317");
INSERT INTO `wyp_e_submissions_values` VALUES("273", "91", "field_d5722b8", "Hi there \r\n \r\nI Just checked your nicosloane.com ranks and saw that your site is trending down for some time. \r\n \r\nIf you are looking for a trend reversal, we have the right solution for you \r\n \r\nWe are offering affordable Content Marketing plans with humanly written SEO content \r\n \r\nFor more information, please check our offers \r\nhttps://www.digital-x-press.com/product/content-marketing/ \r\n \r\nThanks and regards \r\nMike Mason");
INSERT INTO `wyp_e_submissions_values` VALUES("274", "92", "name", "Jessica Smith");
INSERT INTO `wyp_e_submissions_values` VALUES("275", "92", "field_90029d6", "604-265-2415");
INSERT INTO `wyp_e_submissions_values` VALUES("276", "92", "field_d5722b8", "Hi,\r\n\r\nMy name is Jessica. Sorry to reach out like this on your contact form.\r\n\r\nI help US and Canadian businesses receive press about their business.\r\n\r\nPositive press builds trust and connection with your audience. If you’re not building press you’re leaving money on the table.\r\n\r\nWe can have your business on Fox, NBC, Digital Journal, Yahoo, all the way up to Bloomberg within the week.\r\n\r\nThis press can be shared on social media and also used to increase your organic rankings.\r\n\r\nIs this of interest to you?\r\n\r\nIf so, I will send over a completely free of charge press release written about your business, and if you like it, we will distribute it for a fee.\r\n\r\nNo catch.\r\n\r\nAll you have to do is respond with YES.\r\n\r\nI hope you’re having an excellent day,\r\nJessica Smith\r\n\r\nIf I bugged you and you’d prefer to never hear from me again, please just let me know.\r\n\r\n602 West Hastings Street #814 Vancouver, BC V6B 1P2 Canada");
INSERT INTO `wyp_e_submissions_values` VALUES("277", "93", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("278", "93", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("279", "93", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("280", "94", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("281", "94", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("282", "94", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("283", "95", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("284", "95", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("285", "95", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("286", "96", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("287", "96", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("288", "96", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("289", "97", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("290", "97", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("291", "97", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("292", "98", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("293", "98", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("294", "98", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("295", "99", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("296", "99", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("297", "99", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("298", "100", "name", "Mike Kelly");
INSERT INTO `wyp_e_submissions_values` VALUES("299", "100", "field_90029d6", "86327458731");
INSERT INTO `wyp_e_submissions_values` VALUES("300", "100", "field_d5722b8", "Hello \r\n \r\nThis is Mike Kelly\r\n \r\nLet me present you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Kelly\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("301", "101", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("302", "101", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("303", "101", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("304", "102", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("305", "102", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("306", "102", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("307", "103", "name", "Mike Kelly");
INSERT INTO `wyp_e_submissions_values` VALUES("308", "103", "field_90029d6", "85754216435");
INSERT INTO `wyp_e_submissions_values` VALUES("309", "103", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in MOZ and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed Domain Authority score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike Kelly");
INSERT INTO `wyp_e_submissions_values` VALUES("310", "104", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("311", "104", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("312", "104", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("313", "105", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("314", "105", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("315", "105", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("316", "106", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("317", "106", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("318", "106", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("319", "107", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("320", "107", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("321", "107", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("322", "108", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("323", "108", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("324", "108", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("325", "109", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("326", "109", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("327", "109", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("328", "110", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("329", "110", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("330", "110", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("331", "111", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("332", "111", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("333", "111", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("334", "112", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("335", "112", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("336", "112", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("337", "113", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("338", "113", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("339", "113", "field_d5722b8", "Hey, this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("340", "114", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("341", "114", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("342", "114", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("343", "115", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("344", "115", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("345", "115", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("346", "116", "name", "Mike Douglas");
INSERT INTO `wyp_e_submissions_values` VALUES("347", "116", "field_90029d6", "86442693245");
INSERT INTO `wyp_e_submissions_values` VALUES("348", "116", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Douglas\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("349", "117", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("350", "117", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("351", "117", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("352", "118", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("353", "118", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("354", "118", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("355", "119", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("356", "119", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("357", "119", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("358", "120", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("359", "120", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("360", "120", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("361", "121", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("362", "121", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("363", "121", "field_d5722b8", "My name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("364", "122", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("365", "122", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("366", "122", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("367", "123", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("368", "123", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("369", "123", "field_d5722b8", "Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("370", "124", "name", "Mike Austin");
INSERT INTO `wyp_e_submissions_values` VALUES("371", "124", "field_90029d6", "85687284211");
INSERT INTO `wyp_e_submissions_values` VALUES("372", "124", "field_d5722b8", "Hi \r\n \r\nI have just took an in depth look on your  nicosloane.com for the ranking keywords and saw that your website could use a boost. \r\n \r\nWe will increase your SEO metrics and ranks organically and safely, using only whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nPlease check our plans here, we offer SEO at cheap rates. \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Austin\r\n \r\n \r\nPS: Quality SEO content is included");
INSERT INTO `wyp_e_submissions_values` VALUES("373", "125", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("374", "125", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("375", "125", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("376", "126", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("377", "126", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("378", "126", "field_d5722b8", "Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("379", "127", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("380", "127", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("381", "127", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("382", "128", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("383", "128", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("384", "128", "field_d5722b8", "Hi, my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("385", "129", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("386", "129", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("387", "129", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("388", "130", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("389", "130", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("390", "130", "field_d5722b8", "My name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("391", "131", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("392", "131", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("393", "131", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("394", "132", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("395", "132", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("396", "132", "field_d5722b8", "Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://boostleadgeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("397", "133", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("398", "133", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("399", "133", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("400", "134", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("401", "134", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("402", "134", "field_d5722b8", "Hello, my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("403", "135", "name", "Mike Wallace");
INSERT INTO `wyp_e_submissions_values` VALUES("404", "135", "field_90029d6", "84712254279");
INSERT INTO `wyp_e_submissions_values` VALUES("405", "135", "field_d5722b8", "Hi there \r\n \r\nI Just checked your nicosloane.com ranks and saw that your site is trending down for some time. \r\n \r\nIf you are looking for a trend reversal, we have the right solution for you \r\n \r\nWe are offering affordable Content Marketing plans with humanly written SEO content \r\n \r\nFor more information, please check our offers \r\nhttps://www.digital-x-press.com/product/content-marketing/ \r\n \r\nThanks and regards \r\nMike Wallace");
INSERT INTO `wyp_e_submissions_values` VALUES("406", "136", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("407", "136", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("408", "136", "field_d5722b8", "To the nicosloane.com Webmaster! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("409", "137", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("410", "137", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("411", "137", "field_d5722b8", "Dear nicosloane.com Owner. this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("412", "138", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("413", "138", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("414", "138", "field_d5722b8", "Hi nicosloane.com Administrator!\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("415", "139", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("416", "139", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("417", "139", "field_d5722b8", "Hi nicosloane.com Administrator!\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("418", "140", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("419", "140", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("420", "140", "field_d5722b8", "Hello nicosloane.com Owner!\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("421", "141", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("422", "141", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("423", "141", "field_d5722b8", "Hello nicosloane.com Admin!\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("424", "142", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("425", "142", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("426", "142", "field_d5722b8", "To the nicosloane.com Owner!\r\n\r\nMy name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("427", "143", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("428", "143", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("429", "143", "field_d5722b8", "Dear nicosloane.com Webmaster.\r\n\r\nMy name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("430", "144", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("431", "144", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("432", "144", "field_d5722b8", "Hello nicosloane.com Administrator. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("433", "145", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("434", "145", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("435", "145", "field_d5722b8", "To the nicosloane.com Admin. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("436", "146", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("437", "146", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("438", "146", "field_d5722b8", "To the nicosloane.com Admin! I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("439", "147", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("440", "147", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("441", "147", "field_d5722b8", "To the nicosloane.com Webmaster. I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("442", "148", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("443", "148", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("444", "148", "field_d5722b8", "Hello nicosloane.com Owner.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("445", "149", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("446", "149", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("447", "149", "field_d5722b8", "Hello nicosloane.com Admin.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("448", "150", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("449", "150", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("450", "150", "field_d5722b8", "Dear nicosloane.com Webmaster!\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("451", "151", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("452", "151", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("453", "151", "field_d5722b8", "To the nicosloane.com Admin!\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("454", "152", "name", "Mike Williams");
INSERT INTO `wyp_e_submissions_values` VALUES("455", "152", "field_90029d6", "86139638611");
INSERT INTO `wyp_e_submissions_values` VALUES("456", "152", "field_d5722b8", "Hi \r\n \r\nThis is Mike Williams\r\n \r\nLet me introduce to you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Williams\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("457", "153", "name", "Williamlog");
INSERT INTO `wyp_e_submissions_values` VALUES("458", "153", "field_90029d6", "86893714678");
INSERT INTO `wyp_e_submissions_values` VALUES("459", "153", "field_d5722b8", "Hеllо!  nicosloane.com \r\n \r\nDid yоu knоw thаt it is pоssiblе tо sеnd lеttеr tоtаlly lеgit? \r\nWе оffеring а nеw lеgаl mеthоd оf sеnding businеss prоpоsаl thrоugh fееdbасk fоrms. Suсh fоrms аrе lосаtеd оn mаny sitеs. \r\nWhеn suсh businеss оffеrs аrе sеnt, nо pеrsоnаl dаtа is usеd, аnd mеssаgеs аrе sеnt tо fоrms spесifiсаlly dеsignеd tо rесеivе mеssаgеs аnd аppеаls. \r\nаlsо, mеssаgеs sеnt thrоugh fееdbасk Fоrms dо nоt gеt intо spаm bесаusе suсh mеssаgеs аrе соnsidеrеd impоrtаnt. \r\nWе оffеr yоu tо tеst оur sеrviсе fоr frее. Wе will sеnd up tо 50,000 mеssаgеs fоr yоu. \r\nThе соst оf sеnding оnе milliоn mеssаgеs is 59 USD. \r\n \r\nThis lеttеr is сrеаtеd аutоmаtiсаlly. Plеаsе usе thе соntасt dеtаils bеlоw tо соntасt us. \r\n \r\nContact us. \r\nTelegram - @FeedbackMessages \r\nSkype  live:contactform_18 \r\nWhatsApp - +375259112693 \r\nWe only use chat.");
INSERT INTO `wyp_e_submissions_values` VALUES("460", "154", "name", "Mike Oldridge");
INSERT INTO `wyp_e_submissions_values` VALUES("461", "154", "field_90029d6", "89718941162");
INSERT INTO `wyp_e_submissions_values` VALUES("462", "154", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in MOZ and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed Domain Authority score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike Oldridge");
INSERT INTO `wyp_e_submissions_values` VALUES("463", "155", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("464", "155", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("465", "155", "field_d5722b8", "Dear nicosloane.com Admin! \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("466", "156", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("467", "156", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("468", "156", "field_d5722b8", "To the nicosloane.com Webmaster. \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("469", "157", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("470", "157", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("471", "157", "field_d5722b8", "Dear nicosloane.com Webmaster.\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("472", "158", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("473", "158", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("474", "158", "field_d5722b8", "Hello nicosloane.com Owner!\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("475", "159", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("476", "159", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("477", "159", "field_d5722b8", "To the nicosloane.com Webmaster. \r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("478", "160", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("479", "160", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("480", "160", "field_d5722b8", "To the nicosloane.com Administrator. \r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("481", "161", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("482", "161", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("483", "161", "field_d5722b8", "Hello nicosloane.com Administrator! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("484", "162", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("485", "162", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("486", "162", "field_d5722b8", "Dear nicosloane.com Owner. this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("487", "163", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("488", "163", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("489", "163", "field_d5722b8", "To the nicosloane.com Webmaster! my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("490", "164", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("491", "164", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("492", "164", "field_d5722b8", "Hello nicosloane.com Administrator! my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("493", "165", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("494", "165", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("495", "165", "field_d5722b8", "To the nicosloane.com Admin!\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("496", "166", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("497", "166", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("498", "166", "field_d5722b8", "Dear nicosloane.com Owner.\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("499", "167", "name", "Junko Brim");
INSERT INTO `wyp_e_submissions_values` VALUES("500", "167", "field_90029d6", "760-896-4475");
INSERT INTO `wyp_e_submissions_values` VALUES("501", "167", "field_d5722b8", "When searching for a business online, I usually check their rating and the quantity of positive reviews they have. That\'s why I\'m contacting you now – to show you how to generate more genuine 5-star reviews, which will help increase the number of calls you get from your existing ads or listings. To learn more, visit here: https://cutt.ly/c8vrjb5");
INSERT INTO `wyp_e_submissions_values` VALUES("502", "168", "name", "Mike White");
INSERT INTO `wyp_e_submissions_values` VALUES("503", "168", "field_90029d6", "88734624479");
INSERT INTO `wyp_e_submissions_values` VALUES("504", "168", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike White\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("505", "169", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("506", "169", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("507", "169", "field_d5722b8", "Dear nicosloane.com Owner. this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("508", "170", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("509", "170", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("510", "170", "field_d5722b8", "Hi nicosloane.com Administrator! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("511", "171", "name", "Mike Wesley");
INSERT INTO `wyp_e_submissions_values` VALUES("512", "171", "field_90029d6", "86845983627");
INSERT INTO `wyp_e_submissions_values` VALUES("513", "171", "field_d5722b8", "Hi \r\n \r\nI have just analyzed  nicosloane.com for its SEO Trend and saw that your website could use a push. \r\n \r\nWe will increase your SEO metrics and ranks organically and safely, using only whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nPlease check our pricelist here, we offer SEO at cheap rates. \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Wesley\r\n \r\n \r\nPS: Quality SEO content is included");
INSERT INTO `wyp_e_submissions_values` VALUES("514", "172", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("515", "172", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("516", "172", "field_d5722b8", "To the nicosloane.com Admin.\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("517", "173", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("518", "173", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("519", "173", "field_d5722b8", "Dear nicosloane.com Owner!\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("520", "174", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("521", "174", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("522", "174", "field_d5722b8", "To the nicosloane.com Owner! \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("523", "175", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("524", "175", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("525", "175", "field_d5722b8", "Hello nicosloane.com Webmaster! \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("526", "176", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("527", "176", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("528", "176", "field_d5722b8", "Dear nicosloane.com Webmaster!\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("529", "177", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("530", "177", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("531", "177", "field_d5722b8", "Hi nicosloane.com Webmaster. my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("532", "178", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("533", "178", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("534", "178", "field_d5722b8", "To the nicosloane.com Admin!\r\n\r\nThis is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("535", "179", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("536", "179", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("537", "179", "field_d5722b8", "Dear nicosloane.com Webmaster! my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("538", "180", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("539", "180", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("540", "180", "field_d5722b8", "Dear nicosloane.com Webmaster.\r\n\r\nThis is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("541", "181", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("542", "181", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("543", "181", "field_d5722b8", "To the nicosloane.com Administrator!\r\n\r\nThis is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("544", "182", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("545", "182", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("546", "182", "field_d5722b8", "To the nicosloane.com Owner! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("547", "183", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("548", "183", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("549", "183", "field_d5722b8", "To the nicosloane.com Admin! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("550", "184", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("551", "184", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("552", "184", "field_d5722b8", "Dear nicosloane.com Admin. I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("553", "185", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("554", "185", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("555", "185", "field_d5722b8", "Dear nicosloane.com Webmaster. I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("556", "186", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("557", "186", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("558", "186", "field_d5722b8", "To the nicosloane.com Admin! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("559", "187", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("560", "187", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("561", "187", "field_d5722b8", "Hello nicosloane.com Administrator! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("562", "188", "name", "Mike Calhoun");
INSERT INTO `wyp_e_submissions_values` VALUES("563", "188", "field_90029d6", "84167836493");
INSERT INTO `wyp_e_submissions_values` VALUES("564", "188", "field_d5722b8", "Hi there \r\n \r\nI Just checked your nicosloane.com ranks and saw that your site is trending down for some time. \r\n \r\nIf you are looking for a trend reversal, we have the right solution for you \r\n \r\nWe are offering affordable Content Marketing plans with humanly written SEO content \r\n \r\nFor more information, please check our offers \r\nhttps://www.digital-x-press.com/product/content-marketing/ \r\n \r\nThanks and regards \r\nMike Calhoun");
INSERT INTO `wyp_e_submissions_values` VALUES("565", "189", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("566", "189", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("567", "189", "field_d5722b8", "Hello nicosloane.com Webmaster! my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("568", "190", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("569", "190", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("570", "190", "field_d5722b8", "Hello nicosloane.com Owner. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("571", "191", "name", "Mike Duncan");
INSERT INTO `wyp_e_submissions_values` VALUES("572", "191", "field_90029d6", "88569942271");
INSERT INTO `wyp_e_submissions_values` VALUES("573", "191", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in MOZ and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed Domain Authority score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike Duncan");
INSERT INTO `wyp_e_submissions_values` VALUES("574", "192", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("575", "192", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("576", "192", "field_d5722b8", "Hello nicosloane.com Webmaster.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("577", "193", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("578", "193", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("579", "193", "field_d5722b8", "Hi nicosloane.com Admin.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("580", "194", "name", "Lela Brake");
INSERT INTO `wyp_e_submissions_values` VALUES("581", "194", "field_90029d6", "715-240-0280");
INSERT INTO `wyp_e_submissions_values` VALUES("582", "194", "field_d5722b8", "We have hacked your website nicosloane.com and extracted your databases. This was due to the security holes you had in your your site/server which have gained us remote control of pretty much everything that was on the server. \r\n\r\nOur team is mostly interested in customer, administrative, and employee information which we have extracted through your databases once we got remote control over the server. It still needs to be sorted out but it will be well-organized once finished. First, we will be going through the emails/sms information and contacting the recipient how you held in disregard about their information being exposed to a hacking group when you could have stopped it. This would be detrimental to your personal image with these relationships with these people. Lastly, now that we have information not only will we be monetizing off it with our methods but made public or sold to other people that will do whatever they wish with the information also after we are done.\r\n\r\nNow you can put a stop to this by paying a $3000 fee (0.11 BTC) in bitcoin to the address 32fT55HRpoXKyz3ZZqncLWtgKXTKBJXyd9 We will be notified of payment which we will then delete the information we have obtained, patch the hole in the site/server which we got in and remove you from any future targeting in the future. You have 72 hours in doing so after viewing this message or the series of steps will commence. You can obtain bitcoin through such services such as paxful.com or do a search on bing.com");
INSERT INTO `wyp_e_submissions_values` VALUES("583", "195", "name", "Mike Goldman");
INSERT INTO `wyp_e_submissions_values` VALUES("584", "195", "field_90029d6", "89425181164");
INSERT INTO `wyp_e_submissions_values` VALUES("585", "195", "field_d5722b8", "Good Day \r\n \r\nThis is Mike Goldman\r\n \r\nLet me show you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Goldman\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("586", "196", "name", "Ruggiero");
INSERT INTO `wyp_e_submissions_values` VALUES("587", "196", "field_90029d6", "89917478765");
INSERT INTO `wyp_e_submissions_values` VALUES("588", "196", "field_d5722b8", "Dear Sir / Madam, \r\n \r\nWe offer all kinds of loans - Business Loan / Real Estate Project Financing. \r\nWe are a comprehensive financial services firm committed to helping our clients improve their long-term financial success. \r\n \r\nOur customized programs are designed to help grow, protect, and conserve our client’s wealth by delivering a superior level of personalized service. \r\n \r\nWe\'re an Investment/Finance firm that specializes in project funding & General financial service offer. Our principal function would assist you in complete financing through our reputable Lending Institute. \r\n \r\nWe are open to having a good business relationship with you. We are currently interested in funding viable businesses, investments or projects in the following areas of interest: \r\n \r\n* Starting up a Franchise \r\n* Business Acquisition \r\n* Business Expansion \r\n* Capital / Infrastructural Project \r\n* Real Estate purchase (fix and flip) \r\n* Contract Execution \r\n* Trade Financing etc. \r\n \r\n- Intermediaries/Consultants/Brokers are welcome to bring their clients and are 100% protected. \r\nWe encourage you to contact us and learn more about the loans services we offer. \r\n \r\nIf you have any questions or want more information about this offer, do not hesitate to contact us at loans@lasvegasloanllc.com \r\n \r\nThanks \r\nRuggiero \r\nemail:loans@lasvegasloanllc.com");
INSERT INTO `wyp_e_submissions_values` VALUES("589", "197", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("590", "197", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("591", "197", "field_d5722b8", "Hi nicosloane.com Administrator.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("592", "198", "name", "Mike Kelly");
INSERT INTO `wyp_e_submissions_values` VALUES("593", "198", "field_90029d6", "83266818257");
INSERT INTO `wyp_e_submissions_values` VALUES("594", "198", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Kelly\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("595", "199", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("596", "199", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("597", "199", "field_d5722b8", "Hello nicosloane.com Administrator!\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("598", "200", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("599", "200", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("600", "200", "field_d5722b8", "To the nicosloane.com Admin!\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("601", "201", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("602", "201", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("603", "201", "field_d5722b8", "Dear nicosloane.com Administrator.\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("604", "202", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("605", "202", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("606", "202", "field_d5722b8", "To the nicosloane.com Administrator.\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("607", "203", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("608", "203", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("609", "203", "field_d5722b8", "Hello nicosloane.com Webmaster!\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("610", "204", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("611", "204", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("612", "204", "field_d5722b8", "Hi nicosloane.com Webmaster!\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("613", "205", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("614", "205", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("615", "205", "field_d5722b8", "Dear nicosloane.com Webmaster.\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("616", "206", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("617", "206", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("618", "206", "field_d5722b8", "Hi nicosloane.com Webmaster!\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("619", "207", "name", "Mike Boolman");
INSERT INTO `wyp_e_submissions_values` VALUES("620", "207", "field_90029d6", "83219793563");
INSERT INTO `wyp_e_submissions_values` VALUES("621", "207", "field_d5722b8", "Hi \r\n \r\nI have just took a look on your SEO for  nicosloane.com for the ranking keywords and saw that your website could use an upgrade. \r\n \r\nWe will improve your ranks organically and safely, using state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Boolman");
INSERT INTO `wyp_e_submissions_values` VALUES("622", "208", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("623", "208", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("624", "208", "field_d5722b8", "Hello nicosloane.com Admin!\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("625", "209", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("626", "209", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("627", "209", "field_d5722b8", "Dear nicosloane.com Admin.\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - nicosloane.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across nicosloane.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("628", "210", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("629", "210", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("630", "210", "field_d5722b8", "Hi nicosloane.com Owner.\r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("631", "211", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("632", "211", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("633", "211", "field_d5722b8", "Hello nicosloane.com Admin.\r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("634", "212", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("635", "212", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("636", "212", "field_d5722b8", "Dear nicosloane.com Administrator! I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("637", "213", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("638", "213", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("639", "213", "field_d5722b8", "Dear nicosloane.com Administrator! I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("640", "214", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("641", "214", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("642", "214", "field_d5722b8", "Hello nicosloane.com Admin. \r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("643", "215", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("644", "215", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("645", "215", "field_d5722b8", "Dear nicosloane.com Administrator! \r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("646", "216", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("647", "216", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("648", "216", "field_d5722b8", "To the nicosloane.com Administrator. my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("649", "217", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("650", "217", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("651", "217", "field_d5722b8", "Hi nicosloane.com Owner. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("652", "218", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("653", "218", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("654", "218", "field_d5722b8", "Dear nicosloane.com Admin! my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("655", "219", "name", "Mike Morgan");
INSERT INTO `wyp_e_submissions_values` VALUES("656", "219", "field_90029d6", "84174543984");
INSERT INTO `wyp_e_submissions_values` VALUES("657", "219", "field_d5722b8", "Hello \r\n \r\nI have just took an in depth look on your  nicosloane.com for onsite errors and saw that your website has a handful of issues which should be addressed. \r\n \r\nNo matter what you are offering or selling, having a poor optimized site, full of bugs and errors, will never help your ranks. \r\n \r\nLet us fix your wordpress site errors today and get your ranks reach their full potential \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/product/wordpress-seo-audit-and-fix-service/ \r\n \r\n \r\nRegards \r\nMike Morgan");
INSERT INTO `wyp_e_submissions_values` VALUES("658", "220", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("659", "220", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("660", "220", "field_d5722b8", "To the nicosloane.com Administrator.\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("661", "221", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("662", "221", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("663", "221", "field_d5722b8", "Hello nicosloane.com Webmaster.\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("664", "222", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("665", "222", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("666", "222", "field_d5722b8", "Hi nicosloane.com Webmaster. my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("667", "223", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("668", "223", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("669", "223", "field_d5722b8", "To the nicosloane.com Webmaster. my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("670", "224", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("671", "224", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("672", "224", "field_d5722b8", "Dear nicosloane.com Owner. \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("673", "225", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("674", "225", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("675", "225", "field_d5722b8", "Hi nicosloane.com Owner. \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("676", "226", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("677", "226", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("678", "226", "field_d5722b8", "Hi nicosloane.com Owner. Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("679", "227", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("680", "227", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("681", "227", "field_d5722b8", "Hello nicosloane.com Owner. Eric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("682", "228", "name", "Mike Samuels");
INSERT INTO `wyp_e_submissions_values` VALUES("683", "228", "field_90029d6", "85152344928");
INSERT INTO `wyp_e_submissions_values` VALUES("684", "228", "field_d5722b8", "Hi \r\n \r\nThis is Mike Samuels\r\n \r\nLet me present you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Samuels\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("685", "229", "name", "Mike Williams");
INSERT INTO `wyp_e_submissions_values` VALUES("686", "229", "field_90029d6", "83111233298");
INSERT INTO `wyp_e_submissions_values` VALUES("687", "229", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in MOZ and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed Domain Authority score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike Williams");
INSERT INTO `wyp_e_submissions_values` VALUES("688", "230", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("689", "230", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("690", "230", "field_d5722b8", "To the nicosloane.com Admin. my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("691", "231", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("692", "231", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("693", "231", "field_d5722b8", "Hi nicosloane.com Admin! my name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("694", "232", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("695", "232", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("696", "232", "field_d5722b8", "Dear nicosloane.com Admin.\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("697", "233", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("698", "233", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("699", "233", "field_d5722b8", "To the nicosloane.com Owner!\r\n\r\nMy name’s Eric and I just came across your website - nicosloane.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like nicosloane.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("700", "234", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("701", "234", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("702", "234", "field_d5722b8", "Hi nicosloane.com Admin. I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("703", "235", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("704", "235", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("705", "235", "field_d5722b8", "Hi nicosloane.com Admin. I just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("706", "236", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("707", "236", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("708", "236", "field_d5722b8", "Dear nicosloane.com Administrator. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("709", "237", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("710", "237", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("711", "237", "field_d5722b8", "To the nicosloane.com Webmaster. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at nicosloane.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("712", "238", "name", "Mike Miers");
INSERT INTO `wyp_e_submissions_values` VALUES("713", "238", "field_90029d6", "89682578147");
INSERT INTO `wyp_e_submissions_values` VALUES("714", "238", "field_d5722b8", "If you have a local business and want to rank it on google maps in a specific area then this service is for you. \r\n \r\nGoogle Map Stacking is one of the best ways to rank your GMB in a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Miers\r\n \r\n \r\nPS: Want an all in one Local Plan that includes everything? \r\nhttps://www.speed-seo.net/product/local-seo-package/");
INSERT INTO `wyp_e_submissions_values` VALUES("715", "239", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("716", "239", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("717", "239", "field_d5722b8", "To the nicosloane.com Admin.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("718", "240", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("719", "240", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("720", "240", "field_d5722b8", "Dear nicosloane.com Administrator.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("721", "241", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("722", "241", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("723", "241", "field_d5722b8", "Hello nicosloane.com Owner!\r\n\r\nThis is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("724", "242", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("725", "242", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("726", "242", "field_d5722b8", "Hello nicosloane.com Webmaster.\r\n\r\nThis is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("727", "243", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("728", "243", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("729", "243", "field_d5722b8", "To the nicosloane.com Administrator!\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("730", "244", "name", "Nam Ulm");
INSERT INTO `wyp_e_submissions_values` VALUES("731", "244", "field_90029d6", "01.07.34.18.88");
INSERT INTO `wyp_e_submissions_values` VALUES("732", "244", "field_d5722b8", "*INFO SERVICE EXPIRATION FOR nicosloane.com\r\n\r\nAttention: Accounts Payable / Domain Owner / Contact – Nicosloane \r\n\r\nYour Domain: www.nicosloane.com \r\nExpected Reply before: Apr 30, 2023.\r\n\r\nThis Notice for: www.nicosloane.com will expire on Apr 30, 2023. \r\n\r\n\r\n\r\n*For details and to make a payment for nicosloane.com services by credit card:\r\n\r\nVisit: https://orkpay.com/?web=nicosloane.com\r\n\r\n\r\n0430202309572001.07.34.18.88");
INSERT INTO `wyp_e_submissions_values` VALUES("733", "245", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("734", "245", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("735", "245", "field_d5722b8", "Dear nicosloane.com Webmaster!\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("736", "246", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("737", "246", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("738", "246", "field_d5722b8", "Hi nicosloane.com Webmaster.\r\n\r\nMy name’s Eric and I just found your site nicosloane.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("739", "247", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("740", "247", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("741", "247", "field_d5722b8", "Dear nicosloane.com Webmaster! \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("742", "248", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("743", "248", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("744", "248", "field_d5722b8", "Hello nicosloane.com Administrator! \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("745", "249", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("746", "249", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("747", "249", "field_d5722b8", "To the nicosloane.com Administrator. \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("748", "250", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("749", "250", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("750", "250", "field_d5722b8", "Dear nicosloane.com Webmaster. \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with nicosloane.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out nicosloane.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("751", "251", "name", "Mike Ford");
INSERT INTO `wyp_e_submissions_values` VALUES("752", "251", "field_90029d6", "89518287956");
INSERT INTO `wyp_e_submissions_values` VALUES("753", "251", "field_d5722b8", "Greetings \r\n \r\nI have just took a look on your SEO for  nicosloane.com for  the current search visibility and saw that your website could use a boost. \r\n \r\nWe will increase your ranks organically and safely, using state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.hilkom-digital.de/cheap-seo-packages/ \r\n \r\nRegards \r\nMike Ford");
INSERT INTO `wyp_e_submissions_values` VALUES("754", "252", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("755", "252", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("756", "252", "field_d5722b8", "To the nicosloane.com Webmaster! my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("757", "253", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("758", "253", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("759", "253", "field_d5722b8", "To the nicosloane.com Webmaster. my name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("760", "254", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("761", "254", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("762", "254", "field_d5722b8", "To the nicosloane.com Owner! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("763", "255", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("764", "255", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("765", "255", "field_d5722b8", "Dear nicosloane.com Webmaster! this is Eric and I ran across nicosloane.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("766", "256", "name", "Mike Pearcy");
INSERT INTO `wyp_e_submissions_values` VALUES("767", "256", "field_90029d6", "88795399447");
INSERT INTO `wyp_e_submissions_values` VALUES("768", "256", "field_d5722b8", "Good Day \r\n \r\nI have just checked  nicosloane.com for the current onsite SEO status and saw that your website has a handful of issues which should be addressed. \r\n \r\nNo matter what you are offering or selling, having a poor optimized site, full of bugs and errors, will never help your ranks. \r\n \r\nLet us fix your wordpress site errors today and get your ranks reach their full potential \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/product/wordpress-seo-audit-and-fix-service/ \r\n \r\n \r\nRegards \r\nMike Pearcy");
INSERT INTO `wyp_e_submissions_values` VALUES("769", "257", "name", "Josephdiz");
INSERT INTO `wyp_e_submissions_values` VALUES("770", "257", "field_90029d6", "83432934147");
INSERT INTO `wyp_e_submissions_values` VALUES("771", "257", "field_d5722b8", "Howdy! nicosloane.com \r\n \r\nDid you know that it is possible to send messages entirely legally and securely? We put forward a method of sending business proposals through contact forms to рromote efficiency. You can locate these feedback forms on lots of websites. \r\nWhen such proposals are sent, no personal data is used, and messages are sent to specially designed forms to receive messages and appeals. Contact Form messages are usually not sent to spam, since they are considered to be important. \r\nWe are giving you the chance to experience our service without any cost. \r\nOn your behalf, we can dispatch up to 50,000 messages. \r\n \r\nThe cost of sending one million messages is $59. \r\n \r\nThis letter is automatically generated. \r\nPlease use the contact details below to get in touch with us. \r\n \r\nContact us. \r\nTelegram - https://t.me/FeedbackFormEU \r\nSkype  live:feedbackform2019 \r\nWhatsApp  +375259112693 \r\nWhatsApp  https://wa.me/+375259112693 \r\n \r\nWe only use chat for communication.");
INSERT INTO `wyp_e_submissions_values` VALUES("772", "258", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("773", "258", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("774", "258", "field_d5722b8", "To the nicosloane.com Webmaster.\r\n\r\nMy name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("775", "259", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("776", "259", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("777", "259", "field_d5722b8", "Hi nicosloane.com Webmaster.\r\n\r\nMy name is Eric and I’m betting you’d like your website nicosloane.com to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at nicosloane.com.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("778", "260", "name", "Mike Longman");
INSERT INTO `wyp_e_submissions_values` VALUES("779", "260", "field_90029d6", "84481564415");
INSERT INTO `wyp_e_submissions_values` VALUES("780", "260", "field_d5722b8", "Hello \r\n \r\nThis is Mike Longman\r\n \r\nLet me present you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your nicosloane.com SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Longman\r\n \r\nmike@strictlydigital.net");
INSERT INTO `wyp_e_submissions_values` VALUES("781", "261", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("782", "261", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("783", "261", "field_d5722b8", "Dear nicosloane.com Administrator.\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("784", "262", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("785", "262", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("786", "262", "field_d5722b8", "To the nicosloane.com Admin!\r\n\r\nMy name’s Eric and I just ran across your website at nicosloane.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("787", "263", "name", "Mike James");
INSERT INTO `wyp_e_submissions_values` VALUES("788", "263", "field_90029d6", "83578895129");
INSERT INTO `wyp_e_submissions_values` VALUES("789", "263", "field_d5722b8", "Hi there \r\n \r\nJust checked your nicosloane.com in MOZ and saw that you could use an authority boost. \r\n \r\nWith our service you will get a guaranteed Domain Authority score within just 3 months time. This will increase the organic visibility and strengthen your website authority, thus getting it stronger against G updates as well. \r\n \r\nFor more information, please check our offers \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Semrush DA is now possible \r\nhttps://www.monkeydigital.co/semrush-da/ \r\n \r\nThanks and regards \r\nMike James");
INSERT INTO `wyp_e_submissions_values` VALUES("790", "264", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("791", "264", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("792", "264", "field_d5722b8", "To the nicosloane.com Owner!\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("793", "265", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("794", "265", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("795", "265", "field_d5722b8", "To the nicosloane.com Owner.\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found nicosloane.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=nicosloane.com");
INSERT INTO `wyp_e_submissions_values` VALUES("796", "266", "name", "Eric Jones");
INSERT INTO `wyp_e_submissions_values` VALUES("797", "266", "field_90029d6", "555-555-1212");
INSERT INTO `wyp_e_submissions_values` VALUES("798", "266", "field_d5722b8", "Hello nicosloane.com Owner.\r\n\r\nEric here with a quick thought about your website nicosloane.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone N